/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tools.console;

import com.openexchange.groupware.update.tools.Constants;
import com.openexchange.java.Streams;
import com.openexchange.management.console.JMXAuthenticatorImpl;
import java.io.Closeable;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public final class UpdateTaskSchemasAndVersionsCLT {
    private static final Options toolkitOptions = new Options();

    private static void printHelp() {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp("schemasAndVersions", toolkitOptions);
    }

    private UpdateTaskSchemasAndVersionsCLT() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        PosixParser parser = new PosixParser();
        try {
            HashMap<String, JMXAuthenticatorImpl> environment;
            String val;
            CommandLine cmd = parser.parse(toolkitOptions, args);
            if (cmd.hasOption('h')) {
                UpdateTaskSchemasAndVersionsCLT.printHelp();
                System.exit(0);
            }
            int port = 9999;
            if (cmd.hasOption('p') && null != (val = cmd.getOptionValue('p'))) {
                try {
                    port = Integer.parseInt(val.trim());
                }
                catch (NumberFormatException e) {
                    System.err.println("Port parameter is not a number: " + val);
                    UpdateTaskSchemasAndVersionsCLT.printHelp();
                    System.exit(0);
                }
                if (port < 1 || port > 65535) {
                    System.err.println("Port parameter is out of range: " + val + ". Valid range is from 1 to 65535.");
                    UpdateTaskSchemasAndVersionsCLT.printHelp();
                    System.exit(0);
                }
            }
            String jmxLogin = null;
            if (cmd.hasOption('l')) {
                jmxLogin = cmd.getOptionValue('l');
            }
            String jmxPassword = null;
            if (cmd.hasOption('s')) {
                jmxPassword = cmd.getOptionValue('s');
            }
            if (jmxLogin == null || jmxPassword == null) {
                environment = null;
            } else {
                environment = new HashMap<String, JMXAuthenticatorImpl>(1);
                environment.put("jmx.remote.authenticator", new JMXAuthenticatorImpl(jmxLogin, jmxPassword));
            }
            JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://localhost:" + port + "/server");
            JMXConnector jmxConnector = JMXConnectorFactory.connect(url, environment);
            try {
                MBeanServerConnection mbsc = jmxConnector.getMBeanServerConnection();
                String output = (String)mbsc.invoke(Constants.OBJECT_NAME, "schemasAndVersions", null, null);
                System.out.println(output);
            }
            finally {
                Streams.close((Closeable)jmxConnector);
            }
        }
        catch (ParseException e) {
            System.err.println("Unable to parse command line: " + e.getMessage());
            UpdateTaskSchemasAndVersionsCLT.printHelp();
        }
        catch (MalformedURLException e) {
            System.err.println("URL to connect to server is invalid: " + e.getMessage());
        }
        catch (IOException e) {
            System.err.println("Unable to communicate with the server: " + e.getMessage());
        }
        catch (InstanceNotFoundException e) {
            System.err.println("Instance is not available: " + e.getMessage());
        }
        catch (MBeanException e) {
            Throwable t = e.getCause();
            String message = null == t ? e.getMessage() : t.getMessage();
            System.err.println(null == message ? "Unexpected error." : "Unexpected error: " + message);
        }
        catch (ReflectionException e) {
            System.err.println("Problem with reflective type handling: " + e.getMessage());
        }
        catch (RuntimeException e) {
            System.err.println("Problem in runtime: " + e.getMessage());
            UpdateTaskSchemasAndVersionsCLT.printHelp();
        }
    }

    static {
        toolkitOptions.addOption("h", "help", false, "Prints a help text");
        toolkitOptions.addOption("p", "port", true, "The optional JMX port (default:9999)");
        toolkitOptions.addOption("l", "login", true, "The optional JMX login (if JMX has authentication enabled)");
        toolkitOptions.addOption("s", "password", true, "The optional JMX password (if JMX has authentication enabled)");
    }
}

