/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public class ContactInfoField2Text
extends UpdateTaskAdapter {
    private static final String UPDATE = "ALTER TABLE prg_contacts CHANGE COLUMN field34 field34 TEXT";
    private static final String UPDATE_DEL = "ALTER TABLE del_contacts CHANGE COLUMN field34 field34 TEXT";

    @Override
    public String[] getDependencies() {
        return new String[0];
    }

    @Override
    public void perform(PerformParameters params) throws OXException {
        int contextId = params.getContextId();
        Connection con = null;
        try {
            con = Database.getNoTimeout(contextId, true);
            this.innerPerform(con);
        }
        catch (OXException e) {
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        finally {
            if (con != null) {
                Database.backNoTimeout(contextId, true, con);
            }
        }
    }

    private void innerPerform(Connection con) throws OXException {
        Statement stmt = null;
        try {
            this.execute(con, UPDATE);
            this.execute(con, UPDATE_DEL);
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(Connection con, String update) throws SQLException {
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            stmt.executeUpdate(update);
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }
}

