/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.database.AbstractCreateTableImpl;
import com.openexchange.database.DatabaseService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Attributes;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.Schema;
import com.openexchange.groupware.update.TaskAttributes;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.groupware.update.UpdateTaskV2;
import com.openexchange.log.LogFactory;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;

public class AggregatingContactTableService
extends AbstractCreateTableImpl
implements UpdateTaskV2 {
    private static final String AGGREGATING_CONTACTS = "aggregatingContacts";

    private String getTableSQL() {
        return "CREATE TABLE aggregatingContacts (contributor BINARY(16) NOT NULL, aggregator BINARY(16) NOT NULL,state TINYINT NOT NULL) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci";
    }

    protected String[] getCreateStatements() {
        return new String[]{this.getTableSQL()};
    }

    @Override
    public TaskAttributes getAttributes() {
        return new Attributes();
    }

    @Override
    public String[] getDependencies() {
        return new String[0];
    }

    @Override
    public void perform(PerformParameters params) throws OXException {
        int contextId = params.getContextId();
        this.createTable(AGGREGATING_CONTACTS, this.getTableSQL(), contextId);
        Log logger = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(AggregatingContactTableService.class));
        if (logger.isInfoEnabled()) {
            logger.info((Object)("UpdateTask '" + AggregatingContactTableService.class.getSimpleName() + "' successfully performed!"));
        }
    }

    @Override
    public int addedWithVersion() {
        return -1;
    }

    @Override
    public int getPriority() {
        return UpdateTask.UpdateTaskPriority.NORMAL.priority;
    }

    @Override
    public void perform(Schema schema, int contextId) throws OXException {
        UpdateTaskAdapter.perform(this, schema, contextId);
    }

    public String[] requiredTables() {
        return new String[0];
    }

    public String[] tablesToCreate() {
        return new String[]{AGGREGATING_CONTACTS};
    }

    private void createTable(String tablename, String sqlCreate, int contextId) throws OXException {
        DatabaseService ds = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
        Connection writeCon = ds.getWritable(contextId);
        PreparedStatement stmt = null;
        try {
            if (this.tableExists(writeCon, tablename)) {
                return;
            }
            stmt = writeCon.prepareStatement(sqlCreate);
            stmt.executeUpdate();
            DBUtils.closeSQLStuff(stmt);
        }
        catch (SQLException e) {
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
            ds.backWritable(contextId, writeCon);
        }
        ds.backWritable(contextId, writeCon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tableExists(Connection con, String table) throws SQLException {
        DatabaseMetaData metaData = con.getMetaData();
        ResultSet rs = null;
        boolean retval = false;
        try {
            rs = metaData.getTables(null, null, table, new String[]{"TABLE"});
            retval = rs.next() && rs.getString("TABLE_NAME").equals(table);
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(rs);
            throw throwable;
        }
        DBUtils.closeSQLStuff(rs);
        return retval;
    }
}

