/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.internal;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.SchemaStore;
import com.openexchange.groupware.update.SchemaUpdateState;
import com.openexchange.groupware.update.internal.UpdateExecutor;
import com.openexchange.groupware.update.internal.UpdateTaskCollection;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;

public class UpdateProcess
implements Runnable {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(UpdateProcess.class));
    private final int contextId;
    private final SchemaStore schemaStore = SchemaStore.getInstance();

    public UpdateProcess(int contextId) {
        this.contextId = contextId;
    }

    @Override
    public void run() {
        try {
            SchemaUpdateState state = this.schemaStore.getSchema(this.contextId);
            if (!UpdateTaskCollection.getInstance().needsUpdate(state)) {
                return;
            }
            new UpdateExecutor(state, this.contextId, null).execute();
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Throwable t) {
            LOG.error((Object)t.getMessage(), t);
        }
    }
}

