/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update;

import com.openexchange.groupware.update.SimpleUpdateTask;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public abstract class SimpleStatementsUpdateTask
extends SimpleUpdateTask {
    private final List<StatementHolder> statements = new ArrayList<StatementHolder>();

    public SimpleStatementsUpdateTask() {
        this.statements();
    }

    protected abstract void statements();

    public void add(String statement, Object ... values) {
        this.statements.add(new StatementHolder(statement, values));
    }

    @Override
    protected final void perform(Connection con) throws SQLException {
        for (StatementHolder sqlStatement : this.statements) {
            sqlStatement.execute(con);
        }
    }

    protected static class StatementHolder {
        private final String statement;
        private final Object[] values;

        public StatementHolder(String statement, Object ... values) {
            this.statement = statement;
            this.values = values;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Connection con) throws SQLException {
            PreparedStatement stmt = null;
            try {
                stmt = con.prepareStatement(this.statement);
                for (int i = 0; i < this.values.length; ++i) {
                    stmt.setObject(i + 1, this.values[i]);
                }
                stmt.execute();
            }
            finally {
                if (stmt != null) {
                    DBUtils.closeSQLStuff(stmt);
                }
            }
        }
    }
}

