/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update;

import com.openexchange.database.DatabaseService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Attributes;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.Schema;
import com.openexchange.groupware.update.TaskAttributes;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskV2;
import com.openexchange.tools.update.Column;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.SQLException;

public abstract class ChangeColumnTypeUpdateTask
implements UpdateTaskV2 {
    private final DatabaseService dbService;
    private final String tableName;
    private final Column column;

    public ChangeColumnTypeUpdateTask(DatabaseService dbService, String tableName, String columnName, String newType) {
        this.column = new Column(columnName, newType);
        this.tableName = tableName;
        this.dbService = dbService;
    }

    @Override
    public TaskAttributes getAttributes() {
        return new Attributes();
    }

    @Override
    public void perform(PerformParameters params) throws OXException {
        this.perform(params.getSchema(), params.getContextId());
    }

    @Override
    public void perform(Schema schema, int contextId) throws OXException {
        Connection con = null;
        try {
            con = this.getDatabaseService().getForUpdateTask(contextId);
            if (!this.correctType(con)) {
                this.before(con);
                this.changeType(con);
                this.after(con);
            }
        }
        catch (SQLException x) {
            throw UpdateExceptionCodes.SQL_PROBLEM.create(x.getMessage(), x);
        }
        finally {
            if (con != null) {
                this.getDatabaseService().backForUpdateTask(contextId, con);
            }
        }
    }

    public DatabaseService getDatabaseService() {
        return this.dbService;
    }

    protected void before(Connection con) throws SQLException {
    }

    protected void after(Connection con) throws SQLException {
    }

    protected void changeType(Connection con) throws SQLException {
        Tools.modifyColumns(con, this.tableName, this.modifyColumn(this.column));
    }

    protected Column modifyColumn(Column c) {
        return c;
    }

    protected boolean correctType(Connection con) throws OXException, SQLException {
        String name = Tools.getColumnTypeName(con, this.tableName, this.column.getName());
        if (name == null) {
            throw UpdateExceptionCodes.COLUMN_NOT_FOUND.create(this.column.getName());
        }
        return name.equalsIgnoreCase(this.column.getDefinition());
    }
}

