/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.tasks;

import com.openexchange.api2.TasksSQLInterface;
import com.openexchange.event.impl.EventClient;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.search.Order;
import com.openexchange.groupware.search.TaskSearchObject;
import com.openexchange.groupware.tasks.ConfirmTask;
import com.openexchange.groupware.tasks.DeleteData;
import com.openexchange.groupware.tasks.Folder;
import com.openexchange.groupware.tasks.GetTask;
import com.openexchange.groupware.tasks.InternalParticipant;
import com.openexchange.groupware.tasks.ParticipantStorage;
import com.openexchange.groupware.tasks.Permission;
import com.openexchange.groupware.tasks.Reminder;
import com.openexchange.groupware.tasks.Search;
import com.openexchange.groupware.tasks.StorageType;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.groupware.tasks.TaskExceptionCode;
import com.openexchange.groupware.tasks.TaskLogic;
import com.openexchange.groupware.tasks.TaskParticipant;
import com.openexchange.groupware.tasks.TaskSearch;
import com.openexchange.groupware.tasks.TaskStorage;
import com.openexchange.groupware.tasks.Tools;
import com.openexchange.groupware.tasks.UpdateData;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.java.Autoboxing;
import com.openexchange.log.LogFactory;
import com.openexchange.session.Session;
import com.openexchange.tools.iterator.ArrayIterator;
import com.openexchange.tools.iterator.SearchIterator;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import org.apache.commons.logging.Log;

public class TasksSQLImpl
implements TasksSQLInterface {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(TasksSQLImpl.class));
    private final Session session;

    public TasksSQLImpl(Session session) {
        this.session = session;
    }

    @Override
    public SearchIterator<Task> getTaskList(int folderId, int from, int until, int orderBy, Order order, int[] columns) throws OXException {
        int userId = this.session.getUserId();
        Context ctx = Tools.getContext(this.session.getContextId());
        User user = Tools.getUser(ctx, userId);
        UserConfiguration configuration = Tools.getUserConfiguration(ctx, userId);
        FolderObject folder = Tools.getFolder(ctx, folderId);
        boolean onlyOwn = Permission.canReadInFolder(ctx, user, configuration, folder);
        boolean noPrivate = Tools.isFolderShared(folder, user);
        return TaskStorage.getInstance().list(ctx, folderId, from, until, orderBy, order, columns, onlyOwn, userId, noPrivate);
    }

    @Override
    public Task getTaskById(int taskId, int folderId) throws OXException {
        int userId = this.session.getUserId();
        Context ctx = Tools.getContext(this.session.getContextId());
        User user = Tools.getUser(ctx, userId);
        UserConfiguration userConfig = Tools.getUserConfiguration(ctx, userId);
        GetTask get = new GetTask(ctx, user, userConfig, folderId, taskId, StorageType.ACTIVE);
        return get.loadAndCheck();
    }

    private SearchIterator<Task> getModifiedTasksInFolder(int folderId, int[] columns, Date since, StorageType type) throws OXException {
        int userId = this.session.getUserId();
        Context ctx = Tools.getContext(this.session.getContextId());
        User user = Tools.getUser(ctx, userId);
        UserConfiguration userConfig = Tools.getUserConfiguration(ctx, userId);
        FolderObject folder = Tools.getFolder(ctx, folderId);
        boolean onlyOwn = Permission.canReadInFolder(ctx, user, userConfig, folder);
        boolean noPrivate = Tools.isFolderShared(folder, user);
        return TaskSearch.getInstance().listModifiedTasks(ctx, folderId, type, columns, since, onlyOwn, userId, noPrivate);
    }

    @Override
    public SearchIterator<Task> getModifiedTasksInFolder(int folderId, int[] columns, Date since) throws OXException {
        return this.getModifiedTasksInFolder(folderId, columns, since, StorageType.ACTIVE);
    }

    @Override
    public SearchIterator<Task> getDeletedTasksInFolder(int folderId, int[] columns, Date since) throws OXException {
        return this.getModifiedTasksInFolder(folderId, columns, since, StorageType.DELETED);
    }

    @Override
    public void insertTaskObject(Task task) throws OXException {
        Set<Folder> folders2;
        Context ctx = Tools.getContext(this.session.getContextId());
        int userId = this.session.getUserId();
        User user = Tools.getUser(ctx, userId);
        UserConfiguration userConfig = Tools.getUserConfiguration(ctx, userId);
        Set<TaskParticipant> parts = TaskLogic.createParticipants(ctx, task.getParticipants());
        TaskLogic.checkNewTask(task, userId, userConfig, parts);
        int folderId = task.getParentFolderID();
        FolderObject folder = Tools.getFolder(ctx, folderId);
        Permission.checkCreate(ctx, user, userConfig, folder);
        if (task.getPrivateFlag() && (Tools.isFolderPublic(folder) || Tools.isFolderShared(folder, user))) {
            throw TaskExceptionCode.PRIVATE_FLAG.create(Autoboxing.I((int)folderId));
        }
        if (Tools.isFolderPublic(folder)) {
            folders2 = TaskLogic.createFolderMapping(folderId, task.getCreatedBy(), InternalParticipant.EMPTY_INTERNAL);
        } else {
            Tools.fillStandardFolders(ctx, ParticipantStorage.extractInternal(parts));
            int creator = userId;
            if (Tools.isFolderShared(folder, user)) {
                creator = folder.getCreator();
            }
            folders2 = TaskLogic.createFolderMapping(folderId, creator, ParticipantStorage.extractInternal(parts));
        }
        TaskLogic.insertTask(ctx, task, parts, folders2);
        if (task.containsAlarm()) {
            Reminder.createReminder(ctx, task);
        }
        task.setUsers(TaskLogic.createUserParticipants(parts));
        new EventClient(this.session).create(task, folder);
    }

    @Override
    public void updateTaskObject(Task task, int folderId, Date lastRead) throws OXException {
        int userId = this.session.getUserId();
        Context ctx = Tools.getContext(this.session.getContextId());
        User user = Tools.getUser(ctx, userId);
        UserConfiguration userConfig = Tools.getUserConfiguration(ctx, userId);
        FolderObject folder = Tools.getFolder(ctx, folderId);
        UpdateData update = new UpdateData(ctx, user, userConfig, folder, task, lastRead);
        update.prepare();
        update.doUpdate();
        update.sentEvent(this.session);
        update.updateReminder();
        update.makeNextRecurrence(this.session);
    }

    @Override
    public void deleteTaskObject(int taskId, int folderId, Date lastModified) throws OXException {
        int userId = this.session.getUserId();
        Context ctx = Tools.getContext(this.session.getContextId());
        User user = Tools.getUser(ctx, userId);
        UserConfiguration userConfig = Tools.getUserConfiguration(ctx, userId);
        FolderObject folder = Tools.getFolder(ctx, folderId);
        DeleteData delete = new DeleteData(ctx, user, userConfig, folder, taskId, lastModified);
        delete.prepare();
        delete.doDelete();
        delete.deleteReminder();
        delete.sentEvent(this.session);
    }

    @Override
    public Date setUserConfirmation(int taskId, int userId, int confirm, String message) throws OXException {
        Context ctx = Tools.getContext(this.session.getContextId());
        ConfirmTask confirmT = new ConfirmTask(ctx, taskId, userId, confirm, message);
        confirmT.prepare();
        confirmT.doConfirmation();
        Date lastModified = confirmT.getLastModified();
        confirmT.sentEvent(this.session);
        return lastModified;
    }

    @Override
    public SearchIterator<Task> getObjectsById(int[][] ids, int[] columns) throws OXException {
        int userId = this.session.getUserId();
        Context ctx = Tools.getContext(this.session.getContextId());
        User user = Tools.getUser(ctx, userId);
        UserConfiguration userConfig = Tools.getUserConfiguration(ctx, userId);
        ArrayList<Task> tasks2 = new ArrayList<Task>();
        for (int[] objectAndFolderId : ids) {
            GetTask get = new GetTask(ctx, user, userConfig, objectAndFolderId[1], objectAndFolderId[0], StorageType.ACTIVE);
            try {
                tasks2.add(get.loadAndCheck());
            }
            catch (OXException e) {
                LOG.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
        return new ArrayIterator((Object[])tasks2.toArray(new Task[tasks2.size()]));
    }

    @Override
    public SearchIterator<Task> getTasksByExtendedSearch(TaskSearchObject searchData, int orderBy, Order order, int[] columns) throws OXException {
        int userId = this.session.getUserId();
        Context ctx = Tools.getContext(this.session.getContextId());
        User user = Tools.getUser(ctx, userId);
        UserConfiguration config = Tools.getUserConfiguration(ctx, userId);
        Search search = new Search(ctx, user, config, searchData, orderBy, order, columns);
        return search.perform();
    }
}

