/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.tasks;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.attach.AttachmentEvent;
import com.openexchange.groupware.attach.AttachmentListener;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.tasks.StorageType;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.groupware.tasks.TaskExceptionCode;
import com.openexchange.groupware.tasks.TaskStorage;
import com.openexchange.groupware.tasks.UpdateData;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import java.sql.Connection;
import java.util.Date;

public class TaskAttachmentListener
implements AttachmentListener {
    private static final int[] UPDATE_FIELDS = new int[]{5, 3, 104};
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(TaskAttachmentListener.class));

    @Override
    public long attached(AttachmentEvent event) throws OXException {
        TaskStorage storage = TaskStorage.getInstance();
        Context ctx = event.getContext();
        Date lastModified = new Date();
        Task task = new Task();
        task.setObjectID(event.getAttachedId());
        task.setLastModified(lastModified);
        task.setModifiedBy(event.getUser().getId());
        Connection con = event.getWriteConnection();
        Task oldTask = storage.selectTask(ctx, con, event.getAttachedId(), StorageType.ACTIVE);
        Date lastRead = oldTask.getLastModified();
        task.setNumberOfAttachments(oldTask.getNumberOfAttachments() + 1);
        UpdateData.updateTask(ctx, con, task, lastRead, UPDATE_FIELDS, null, null, null, null);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Increased number of attachments for task " + event.getAttachedId() + " in context " + ctx.getContextId() + " to " + task.getNumberOfAttachments()));
        }
        return lastModified.getTime();
    }

    @Override
    public long detached(AttachmentEvent event) throws OXException {
        TaskStorage storage = TaskStorage.getInstance();
        Context ctx = event.getContext();
        Task task = new Task();
        task.setObjectID(event.getAttachedId());
        Date lastModified = new Date();
        task.setLastModified(lastModified);
        task.setModifiedBy(event.getUser().getId());
        Connection con = event.getWriteConnection();
        Task oldTask = storage.selectTask(ctx, con, event.getAttachedId(), StorageType.ACTIVE);
        Date lastRead = oldTask.getLastModified();
        int numOfAttachments = oldTask.getNumberOfAttachments() - event.getDetached().length;
        if (numOfAttachments < 0) {
            throw TaskExceptionCode.WRONG_ATTACHMENT_COUNT.create();
        }
        task.setNumberOfAttachments(numOfAttachments);
        UpdateData.updateTask(ctx, con, task, lastRead, UPDATE_FIELDS, null, null, null, null);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Decreased number of attachments for task " + event.getAttachedId() + " in context " + ctx.getContextId() + " to " + task.getNumberOfAttachments()));
        }
        return lastModified.getTime();
    }
}

