/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.tasks;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.reminder.ReminderExceptionCode;
import com.openexchange.groupware.reminder.ReminderHandler;
import com.openexchange.groupware.reminder.ReminderObject;
import com.openexchange.groupware.tasks.Folder;
import com.openexchange.groupware.tasks.InternalParticipant;
import com.openexchange.groupware.tasks.ParticipantStorage;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.groupware.tasks.TaskParticipant;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.Collections;
import java.sql.Connection;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;

final class Reminder {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(Reminder.class));

    private Reminder() {
    }

    static void createReminder(Context ctx, Task task) throws OXException {
        ReminderObject remind = new ReminderObject();
        remind.setDate(task.getAlarm());
        remind.setModule(4);
        remind.setTargetId(task.getObjectID());
        remind.setFolder(task.getParentFolderID());
        remind.setUser(task.getCreatedBy());
        ReminderHandler reminder = new ReminderHandler(ctx);
        reminder.insertReminder(remind);
    }

    static void fixAlarm(Context ctx, Task task, Set<TaskParticipant> removed, Set<Folder> folders2) throws OXException {
        int userId;
        ReminderHandler reminder = new ReminderHandler(ctx);
        int taskId = task.getObjectID();
        for (InternalParticipant participant : ParticipantStorage.extractInternal(removed)) {
            userId = participant.getIdentifier();
            if (!reminder.existsReminder(taskId, userId, 4)) continue;
            reminder.deleteReminder(taskId, userId, 4);
        }
        for (Folder folder : folders2) {
            userId = folder.getUser();
            if (!reminder.existsReminder(taskId, userId, 4)) continue;
            ReminderObject remind = reminder.loadReminder(taskId, folder.getUser(), 4);
            int folderId = folder.getIdentifier();
            try {
                if (remind.getFolder() == folderId) continue;
                remind.setFolder(folderId);
                reminder.updateReminder(remind);
            }
            catch (NumberFormatException nfe) {
                LOG.error((Object)"Parsing reminder folder identifier failed.", (Throwable)nfe);
            }
        }
    }

    static void updateAlarm(Context ctx, Task task, User user) throws OXException {
        ReminderHandler reminder = new ReminderHandler(ctx);
        int taskId = task.getObjectID();
        int userId = user.getId();
        if (null == task.getAlarm()) {
            if (reminder.existsReminder(taskId, userId, 4)) {
                reminder.deleteReminder(taskId, userId, 4);
            }
        } else {
            ReminderObject remind = new ReminderObject();
            remind.setDate(task.getAlarm());
            remind.setModule(4);
            remind.setTargetId(taskId);
            remind.setFolder(task.getParentFolderID());
            remind.setUser(userId);
            if (reminder.existsReminder(taskId, userId, 4)) {
                reminder.updateReminder(remind);
            } else {
                reminder.insertReminder(remind);
            }
        }
    }

    static void loadReminder(Context ctx, int userId, Collection<Task> tasks2) throws OXException {
        ReminderHandler remStor = new ReminderHandler(ctx);
        HashMap<Integer, Task> tmp = new HashMap<Integer, Task>();
        for (Task task : tasks2) {
            tmp.put(task.getObjectID(), task);
        }
        ReminderObject[] reminders = remStor.loadReminder(Collections.toArray(tmp.keySet()), userId, 4);
        for (ReminderObject reminder : reminders) {
            ((Task)tmp.get(reminder.getTargetId())).setAlarm(reminder.getDate());
        }
    }

    static void loadReminder(Context ctx, int userId, Collection<Task> tasks2, Connection con) throws OXException {
        ReminderObject[] reminders;
        ReminderHandler remStor = new ReminderHandler(ctx);
        HashMap<Integer, Task> tmp = new HashMap<Integer, Task>();
        for (Task task : tasks2) {
            tmp.put(task.getObjectID(), task);
        }
        for (ReminderObject reminder : reminders = remStor.loadReminders(Collections.toArray(tmp.keySet()), userId, 4, con)) {
            ((Task)tmp.get(reminder.getTargetId())).setAlarm(reminder.getDate());
        }
    }

    static void loadReminder(Context ctx, int userId, Task task) throws OXException {
        ReminderHandler reminder = new ReminderHandler(ctx);
        int taskId = task.getObjectID();
        if (reminder.existsReminder(taskId, userId, 4)) {
            ReminderObject remind = reminder.loadReminder(taskId, userId, 4);
            task.setAlarm(remind.getDate());
        }
    }

    static void deleteReminder(Context ctx, Task task) throws OXException {
        block2: {
            ReminderHandler reminder = new ReminderHandler(ctx);
            try {
                reminder.deleteReminder(task.getObjectID(), 4);
            }
            catch (OXException e) {
                if (ReminderExceptionCode.NOT_FOUND.equals(e)) break block2;
                throw e;
            }
        }
    }
}

