/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.settings.tree.modules.mail;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.settings.IValueHandler;
import com.openexchange.groupware.settings.PreferencesItemService;
import com.openexchange.groupware.settings.Setting;
import com.openexchange.groupware.settings.SettingExceptionCodes;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.mail.usersetting.UserSettingMailStorage;
import com.openexchange.session.Session;
import java.math.BigInteger;

public class LineWrap
implements PreferencesItemService {
    @Override
    public String[] getPath() {
        return new String[]{"modules", "mail", "linewrap"};
    }

    @Override
    public IValueHandler getSharedValue() {
        return new IValueHandler(){

            @Override
            public void getValue(Session session, Context ctx, User user, UserConfiguration userConfig, Setting setting) throws OXException {
                UserSettingMail settings = UserSettingMailStorage.getInstance().getUserSettingMail(user.getId(), ctx);
                if (null != settings) {
                    setting.setSingleValue(settings.getAutoLinebreak());
                }
            }

            @Override
            public boolean isAvailable(UserConfiguration userConfig) {
                return userConfig.hasWebMail();
            }

            @Override
            public boolean isWritable() {
                return true;
            }

            @Override
            public void writeValue(Session session, Context ctx, User user, Setting setting) throws OXException {
                UserSettingMailStorage storage = UserSettingMailStorage.getInstance();
                UserSettingMail settings = storage.getUserSettingMail(user.getId(), ctx);
                if (null != settings) {
                    String s = setting.getSingleValue().toString();
                    try {
                        try {
                            settings.setAutoLinebreak(Integer.parseInt(s));
                        }
                        catch (NumberFormatException e) {
                            settings.setAutoLinebreak(new BigInteger(s).intValue());
                        }
                        storage.saveUserSettingMail(settings, user.getId(), ctx);
                    }
                    catch (NumberFormatException e) {
                        throw SettingExceptionCodes.JSON_READ_ERROR.create(e, new Object[0]);
                    }
                }
            }

            @Override
            public int getId() {
                return -1;
            }
        };
    }
}

