/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.settings.tree;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserImpl;
import com.openexchange.groupware.settings.IValueHandler;
import com.openexchange.groupware.settings.PreferencesItemService;
import com.openexchange.groupware.settings.Setting;
import com.openexchange.groupware.settings.impl.AbstractUserFuncs;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.session.Session;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public final class SpellCheck
implements PreferencesItemService {
    private static final String NAME = "spellcheck";

    @Override
    public String[] getPath() {
        return new String[]{NAME};
    }

    @Override
    public IValueHandler getSharedValue() {
        return new AbstractUserFuncs(){

            @Override
            public void getValue(Session session, Context ctx, User user, UserConfiguration userConfig, Setting setting) throws OXException {
                Set<String> set = user.getAttributes().get(SpellCheck.NAME);
                if (null != set && !set.isEmpty()) {
                    setting.setSingleValue(Boolean.valueOf(set.iterator().next()));
                } else {
                    setting.setSingleValue(Boolean.FALSE);
                }
            }

            @Override
            public boolean isAvailable(UserConfiguration userConfig) {
                return true;
            }

            @Override
            public boolean isWritable() {
                return true;
            }

            @Override
            protected void setValue(UserImpl newUser, String value, User originalUser) {
                HashMap<String, Set<String>> clonedAttrs = new HashMap<String, Set<String>>(originalUser.getAttributes());
                HashSet<String> spellCheck = new HashSet<String>(1);
                spellCheck.add(value);
                clonedAttrs.put(SpellCheck.NAME, Collections.unmodifiableSet(spellCheck));
                newUser.setAttributes(Collections.unmodifiableMap(clonedAttrs));
            }
        };
    }
}

