/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.reminder.internal;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.reminder.ReminderExceptionCode;
import com.openexchange.groupware.reminder.TargetService;
import com.openexchange.java.Autoboxing;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;

public class TargetRegistry {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(TargetRegistry.class));
    private static final TargetRegistry SINGLETON = new TargetRegistry();
    private final TIntObjectMap<TargetService> registry = new TIntObjectHashMap();

    private TargetRegistry() {
    }

    public static final TargetRegistry getInstance() {
        return SINGLETON;
    }

    public TargetService getService(int module) throws OXException {
        TargetService retval = (TargetService)this.registry.get(module);
        if (null == retval) {
            throw ReminderExceptionCode.NO_TARGET_SERVICE.create(Autoboxing.I((int)module));
        }
        return retval;
    }

    public void addService(int module, TargetService targetService) {
        TargetService previous = (TargetService)this.registry.putIfAbsent(module, (Object)targetService);
        if (null == previous) {
            return;
        }
        LOG.error((Object)("Duplicate registration of a reminder target service for module " + module + " with implementation " + targetService.getClass().getName() + "."));
    }

    public void removeService(int module) {
        this.registry.remove(module);
    }
}

