/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.notify.hostname.internal;

import com.openexchange.groupware.notify.hostname.HostnameService;
import com.openexchange.groupware.notify.hostname.internal.HostDataImpl;
import com.openexchange.login.BlockingLoginHandlerService;
import com.openexchange.login.LoginRequest;
import com.openexchange.login.LoginResult;
import com.openexchange.session.Session;
import com.openexchange.systemname.SystemNameService;

public final class HostDataLoginHandler
implements BlockingLoginHandlerService {
    private HostnameService hostnameService;
    private SystemNameService systemNameService;

    @Override
    public void handleLogin(LoginResult login) {
        LoginRequest request = login.getRequest();
        Session session = login.getSession();
        HostDataImpl hostData = new HostDataImpl(request.isSecure(), this.determineHost(request, session.getContextId(), session.getUserId()), request.getServerPort(), this.determineHttpSessionId(request.getHttpSessionID()));
        session.setParameter("com.openexchange.groupware.hostdata", (Object)hostData);
    }

    private String determineHost(LoginRequest request, int contextId, int userId) {
        String tmp;
        String host = request.getServerName();
        if (null != this.hostnameService && null != (tmp = this.hostnameService.getHostname(userId, contextId))) {
            host = tmp;
        }
        return host;
    }

    private String determineHttpSessionId(String httpSessionId) {
        String retval = null == httpSessionId ? "0123456789." + this.systemNameService.getSystemName() : (httpSessionId.indexOf(46) > 0 ? httpSessionId : httpSessionId + '.' + this.systemNameService.getSystemName());
        return retval;
    }

    @Override
    public void handleLogout(LoginResult logout) {
    }

    public void setHostnameService(HostnameService hostnameService) {
        this.hostnameService = hostnameService;
    }

    public void setSystemNameService(SystemNameService systemNameService) {
        this.systemNameService = systemNameService;
    }
}

