/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.ldap;

import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionFactory;

public enum LdapExceptionCode implements OXExceptionCode
{
    PROPERTY_MISSING("Cannot find property %s.", Category.CATEGORY_CONFIGURATION, 1),
    DN_PROBLEM("Cannot build distinguished name from %s.", Category.CATEGORY_ERROR, 2),
    CLASS_NOT_FOUND("Class %s can not be loaded.", Category.CATEGORY_CONFIGURATION, 3),
    INSTANTIATION_PROBLEM("Cannot instantiate class %s.", Category.CATEGORY_CONFIGURATION, 4),
    NO_CONNECTION("Cannot get database connection.", Category.CATEGORY_SERVICE_DOWN, 5),
    SQL_ERROR("SQL problem: \"%s\"", Category.CATEGORY_ERROR, 6),
    CACHE_PROBLEM("Problem putting/removing an object into/from the cache.", Category.CATEGORY_ERROR, 7),
    HASH_ALGORITHM("Hash algorithm %s could not be found.", Category.CATEGORY_ERROR, 8),
    UNSUPPORTED_ENCODING("Encoding %s cannot be used.", Category.CATEGORY_ERROR, 9),
    RESOURCEGROUP_NOT_FOUND("Cannot find resource group with identifier %d.", Category.CATEGORY_ERROR, 10),
    RESOURCEGROUP_CONFLICT("Found resource groups with same identifier %d.", Category.CATEGORY_ERROR, 11),
    RESOURCE_NOT_FOUND("Cannot find resource with identifier %d.", Category.CATEGORY_ERROR, 12),
    RESOURCE_CONFLICT("Found resources with same identifier %d.", Category.CATEGORY_ERROR, 13),
    NO_USER_BY_MAIL("Cannot find user with E-Mail %s.", Category.CATEGORY_ERROR, 14),
    USER_NOT_FOUND("Cannot find user with identifier %1$s in context %2$d.", Category.CATEGORY_ERROR, 15),
    GROUP_NOT_FOUND("Cannot find group with identifier %1$s in context %2$d.", Category.CATEGORY_ERROR, 17),
    UNEXPECTED_ERROR("Unexpected error: %1$s", Category.CATEGORY_ERROR, 18);

    private final String message;
    private final Category category;
    private final int detailNumber;

    private LdapExceptionCode(String message, Category category, int detailNumber) {
        this.message = message;
        this.category = category;
        this.detailNumber = detailNumber;
    }

    public String getPrefix() {
        return "";
    }

    public Category getCategory() {
        return this.category;
    }

    public int getNumber() {
        return this.detailNumber;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean equals(OXException e) {
        return e.getCode() == this.getNumber();
    }

    public OXException create() {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, new Object[0]);
    }

    public OXException create(Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, (Throwable)null, args);
    }

    public OXException create(Throwable cause, Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, cause, args);
    }
}

