/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.ldap;

import com.openexchange.caching.Cache;
import com.openexchange.caching.CacheKey;
import com.openexchange.caching.CacheService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.LdapExceptionCode;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserExceptionCode;
import com.openexchange.groupware.ldap.UserFactory;
import com.openexchange.groupware.ldap.UserReloader;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.java.Autoboxing;
import com.openexchange.log.LogFactory;
import com.openexchange.server.osgi.ServerActivator;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.sessiond.SessiondEventConstants;
import com.openexchange.sessiond.SessiondService;
import com.openexchange.sessiond.SessiondServiceExtended;
import gnu.trove.ConcurrentTIntObjectHashMap;
import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class CachingUserStorage
extends UserStorage
implements EventHandler {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(CachingUserStorage.class));
    private static final String REGION_NAME = "User";
    private final UserStorage delegate;
    private final ConcurrentTIntObjectHashMap<Lock> cacheLockMap;
    private volatile ServiceRegistration<EventHandler> registration;

    public CachingUserStorage(UserStorage delegate) {
        this.delegate = delegate;
        this.cacheLockMap = new ConcurrentTIntObjectHashMap(1024);
    }

    public void handleEvent(Event event) {
        block3: {
            String topic;
            block4: {
                block2: {
                    topic = event.getTopic();
                    if (!"com/openexchange/sessiond/remove/data".equals(topic)) break block2;
                    Map container = (Map)event.getProperty("com.openexchange.sessiond.container");
                    for (Session session : container.values()) {
                        this.handleRemovedSession(session);
                    }
                    break block3;
                }
                if (!"com/openexchange/sessiond/remove/session".equals(topic)) break block4;
                Session session = (Session)event.getProperty("com.openexchange.sessiond.session");
                this.handleRemovedSession(session);
                break block3;
            }
            if (!"com/openexchange/sessiond/remove/container".equals(topic)) break block3;
            Map container = (Map)event.getProperty("com.openexchange.sessiond.container");
            for (Session session : container.values()) {
                this.handleRemovedSession(session);
            }
        }
    }

    private void handleRemovedSession(Session session) {
        int contextId;
        SessiondService service = (SessiondService)SessiondService.SERVICE_REFERENCE.get();
        if (service instanceof SessiondServiceExtended && !((SessiondServiceExtended)service).hasForContext(contextId = session.getContextId())) {
            this.cacheLockMap.remove(contextId);
        }
    }

    private Lock lockFor(Context ctx) {
        return this.lockFor(ctx.getContextId());
    }

    private Lock lockFor(int contextId) {
        ReentrantLock newLock;
        Lock tmp = (Lock)this.cacheLockMap.get(contextId);
        if (null == tmp && null == (tmp = (Lock)this.cacheLockMap.putIfAbsent(contextId, (Object)(newLock = new ReentrantLock(true))))) {
            tmp = newLock;
        }
        return tmp;
    }

    @Override
    public User getUser(int uid, Context context) throws OXException {
        CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
        if (cacheService == null) {
            return this.delegate.getUser(uid, context);
        }
        return this.createProxy(context, uid, cacheService, null);
    }

    private User createProxy(Context ctx, int userId, CacheService cacheService, User user) throws OXException {
        UserFactory factory = new UserFactory(this.delegate, cacheService, this.lockFor(ctx), ctx, userId);
        return null == user ? new UserReloader(factory, REGION_NAME) : new UserReloader(factory, user, REGION_NAME);
    }

    @Override
    public int createUser(Connection con, Context context, User user) throws OXException {
        return this.delegate.createUser(con, context, user);
    }

    @Override
    public int createUser(Context context, User user) throws OXException {
        return this.delegate.createUser(context, user);
    }

    @Override
    public User getUser(Context ctx, int userId, Connection con) throws OXException {
        CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
        if (cacheService == null) {
            return this.delegate.getUser(ctx, userId, con);
        }
        User user = this.delegate.getUser(ctx, userId, con);
        return this.createProxy(ctx, userId, cacheService, user);
    }

    @Override
    public User[] getUser(Context ctx) throws OXException {
        return this.getUser(ctx, this.listAllUser(ctx));
    }

    @Override
    public User[] getUser(Context ctx, int[] userIds) throws OXException {
        User[] loaded;
        CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
        if (cacheService == null) {
            return this.delegate.getUser(ctx);
        }
        Cache cache = cacheService.getCache(REGION_NAME);
        HashMap<Integer, User> map = new HashMap<Integer, User>(userIds.length, 1.0f);
        ArrayList<Integer> toLoad = new ArrayList<Integer>(userIds.length);
        Lock lock = this.lockFor(ctx);
        for (int userId : userIds) {
            UserFactory factory = new UserFactory(this.delegate, cacheService, lock, ctx, userId);
            Object object = cache.get(factory.getKey());
            if (object instanceof User) {
                map.put(Autoboxing.I((int)userId), new UserReloader(factory, (User)object, REGION_NAME));
                continue;
            }
            toLoad.add(Autoboxing.I((int)userId));
        }
        for (User user : loaded = this.delegate.getUser(ctx, Autoboxing.I2i(toLoad))) {
            map.put(Autoboxing.I((int)user.getId()), this.createProxy(ctx, user.getId(), cacheService, user));
        }
        ArrayList retval = new ArrayList(userIds.length);
        for (int userId : userIds) {
            retval.add(map.get(Autoboxing.I((int)userId)));
        }
        return retval.toArray(new User[retval.size()]);
    }

    @Override
    public void updateUserInternal(User user, Context context) throws OXException {
        this.delegate.updateUser(user, context);
        this.invalidateUser(context, user.getId());
    }

    @Override
    public String getUserAttribute(String name, int userId, Context context) throws OXException {
        CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
        if (cacheService == null) {
            return this.delegate.getUserAttribute(name, userId, context);
        }
        Set<String> set = this.getUser(userId, context).getAttributes().get("attr_" + name);
        return null == set ? null : (set.isEmpty() ? null : set.iterator().next());
    }

    @Override
    public void setUserAttribute(String name, String value, int userId, Context context) throws OXException {
        this.delegate.setUserAttribute(name, value, userId, context);
        this.invalidateUser(context, userId);
    }

    @Override
    public void setAttribute(String name, String value, int userId, Context context) throws OXException {
        this.delegate.setAttribute(name, value, userId, context);
        this.invalidateUser(context, userId);
    }

    @Override
    public int getUserId(String uid, Context context) throws OXException {
        Integer tmp;
        CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
        if (null == cacheService) {
            return this.delegate.getUserId(uid, context);
        }
        Cache cache = cacheService.getCache(REGION_NAME);
        CacheKey key = cache.newCacheKey(context.getContextId(), new Serializable[]{uid});
        int identifier = -1;
        try {
            tmp = (Integer)cache.get((Serializable)key);
        }
        catch (ClassCastException e) {
            tmp = null;
        }
        if (null == tmp) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Cache MISS. Context: " + context.getContextId() + " User: " + uid));
            }
            identifier = this.delegate.getUserId(uid, context);
            try {
                cache.put((Serializable)key, (Serializable)Integer.valueOf(identifier), false);
            }
            catch (OXException e) {
                throw LdapExceptionCode.CACHE_PROBLEM.create(e, new Object[0]).setPrefix("USR");
            }
        } else {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Cache HIT. Context: " + context.getContextId() + " User: " + uid));
            }
            identifier = tmp;
        }
        return identifier;
    }

    @Override
    public int[] listModifiedUser(Date modifiedSince, Context context) throws OXException {
        return this.delegate.listModifiedUser(modifiedSince, context);
    }

    @Override
    public User searchUser(String email, Context context) throws OXException {
        return this.delegate.searchUser(email, context);
    }

    @Override
    public User[] searchUserByMailLogin(String login, Context context) throws OXException {
        return this.delegate.searchUserByMailLogin(login, context);
    }

    @Override
    public User[] searchUserByName(String name, Context context, int searchType) throws OXException {
        return this.delegate.searchUserByName(name, context, searchType);
    }

    @Override
    public int[] listAllUser(Context ctx) throws OXException {
        return this.delegate.listAllUser(ctx);
    }

    @Override
    public int[] resolveIMAPLogin(String imapLogin, Context context) throws OXException {
        CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
        if (null == cacheService) {
            return this.delegate.resolveIMAPLogin(imapLogin, context);
        }
        try {
            int[] identifiers;
            int[] tmp;
            Cache cache = cacheService.getCache(REGION_NAME);
            CacheKey key = cache.newCacheKey(context.getContextId(), new Serializable[]{new StringBuilder(imapLogin.length() + 1).append('~').append(imapLogin).toString()});
            try {
                tmp = (int[])cache.get((Serializable)key);
            }
            catch (ClassCastException e) {
                tmp = null;
            }
            if (null == tmp) {
                identifiers = this.delegate.resolveIMAPLogin(imapLogin, context);
                try {
                    if (null != cache.get((Serializable)key)) {
                        cache.remove((Serializable)key);
                    }
                    cache.put((Serializable)key, (Serializable)identifiers, false);
                }
                catch (OXException e) {
                    throw UserExceptionCode.CACHE_PROBLEM.create(e, new Object[0]);
                }
            } else {
                identifiers = tmp;
            }
            return identifiers;
        }
        catch (OXException e) {
            throw UserExceptionCode.CACHE_PROBLEM.create(e, new Object[0]);
        }
    }

    @Override
    public void invalidateUser(Context ctx, int userId) throws OXException {
        CacheService cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class);
        if (null != cacheService) {
            try {
                Cache cache = cacheService.getCache(REGION_NAME);
                cache.remove((Serializable)cache.newCacheKey(ctx.getContextId(), userId));
            }
            catch (OXException e) {
                throw UserExceptionCode.CACHE_PROBLEM.create(e, new Object[0]);
            }
        }
        try {
            UserConfigurationStorage.getInstance().removeUserConfiguration(userId, ctx);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @Override
    protected void startInternal() {
        BundleContext context = ServerActivator.getContext();
        if (null != context) {
            Hashtable<String, String[]> serviceProperties = new Hashtable<String, String[]>(1);
            ((Dictionary)serviceProperties).put("event.topics", SessiondEventConstants.getAllTopics());
            this.registration = context.registerService(EventHandler.class, (Object)this, serviceProperties);
        }
    }

    @Override
    protected void stopInternal() throws OXException {
        CacheService cacheService;
        ServiceRegistration<EventHandler> registration = this.registration;
        if (null != registration) {
            registration.unregister();
            this.registration = null;
        }
        if ((cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class)) != null) {
            cacheService.freeCache(REGION_NAME);
        }
    }

    UserStorage getDelegate() {
        return this.delegate;
    }
}

