/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.webdav;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.infostore.webdav.Lock;
import com.openexchange.groupware.infostore.webdav.LockManager;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import com.openexchange.tools.session.SessionHolder;
import com.openexchange.webdav.protocol.WebdavLock;
import com.openexchange.webdav.protocol.WebdavPath;
import com.openexchange.webdav.protocol.WebdavProtocolException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class LockHelper {
    private final Map<String, WebdavLock> locks = new HashMap<String, WebdavLock>();
    private final WebdavPath url;
    protected int id;
    private final Set<String> removedLocks = new HashSet<String>();
    private final Set<Integer> removedLockIDs = new HashSet<Integer>();
    private final SessionHolder sessionHolder;
    private final LockManager lockManager;
    private boolean loadedLocks;

    public LockHelper(LockManager lockManager, SessionHolder sessionHolder, WebdavPath url) {
        this.lockManager = lockManager;
        if (null == sessionHolder) {
            throw new IllegalArgumentException("sessionHolder may not be null");
        }
        this.sessionHolder = sessionHolder;
        this.url = url;
    }

    public void setId(int id) {
        this.id = id;
    }

    public WebdavLock getLock(String token) throws WebdavProtocolException {
        this.loadLocks();
        return this.locks.get(token);
    }

    public List<WebdavLock> getAllLocks() throws WebdavProtocolException {
        this.loadLocks();
        ArrayList<WebdavLock> lockList = new ArrayList<WebdavLock>(this.locks.values());
        ArrayList<WebdavLock> notExpired = new ArrayList<WebdavLock>();
        long now = System.currentTimeMillis();
        for (WebdavLock lock : lockList) {
            if (lock.isActive(now)) {
                notExpired.add(lock);
                continue;
            }
            this.removeLock(lock.getToken());
        }
        return notExpired;
    }

    public void addLock(WebdavLock lock) throws WebdavProtocolException {
        try {
            this.loadLocks();
            if (lock.getToken() != null && this.locks.containsKey(lock.getToken())) {
                this.relock(lock);
                this.locks.put(lock.getToken(), lock);
                return;
            }
            int lockId = this.saveLock(lock);
            lock.setToken("http://www.open-xchange.com/webdav/locks/" + lockId);
            this.locks.put(lock.getToken(), lock);
        }
        catch (OXException e) {
            throw WebdavProtocolException.generalError(e, this.url, 500);
        }
    }

    protected abstract void relock(WebdavLock var1) throws OXException;

    protected abstract int saveLock(WebdavLock var1) throws OXException;

    public void removeLock(String token) {
        this.locks.remove(token);
        this.markRemovedLock(token);
    }

    public void setLocks(List<Lock> locks) {
        for (Lock lock : locks) {
            WebdavLock l = this.toWebdavLock(lock);
            this.locks.put(l.getToken(), l);
        }
    }

    protected abstract WebdavLock toWebdavLock(Lock var1);

    protected abstract Lock toLock(WebdavLock var1);

    private synchronized void loadLocks() throws WebdavProtocolException {
        if (this.loadedLocks) {
            return;
        }
        if (this.id == 0) {
            return;
        }
        this.loadedLocks = true;
        try {
            ServerSession session = this.getSession();
            List<Lock> locks = this.lockManager.findLocks(this.id, session.getContext(), UserStorage.getStorageUser(session.getUserId(), session.getContext()), UserConfigurationStorage.getInstance().getUserConfigurationSafe(session.getUserId(), session.getContext()));
            ArrayList<Lock> cleanedLocks = new ArrayList<Lock>();
            for (Lock lock : locks) {
                if (this.removedLockIDs.contains(lock.getId())) continue;
                cleanedLocks.add(lock);
            }
            this.setLocks(cleanedLocks);
        }
        catch (OXException e) {
            throw WebdavProtocolException.generalError(e, this.url, 500);
        }
    }

    private void markRemovedLock(String token) {
        this.removedLocks.add(token);
        int lockId = Integer.parseInt(token.substring(41));
        this.removedLockIDs.add(lockId);
    }

    public void dumpLocksToDB() throws OXException {
        if (this.removedLocks.isEmpty()) {
            return;
        }
        ServerSession session = this.getSession();
        Context ctx = session.getContext();
        User user = UserStorage.getStorageUser(session.getUserId(), session.getContext());
        UserConfiguration userConfig = UserConfigurationStorage.getInstance().getUserConfigurationSafe(session.getUserId(), session.getContext());
        for (int id : this.removedLockIDs) {
            this.lockManager.unlock(id, ctx, user, userConfig);
        }
        this.removedLocks.clear();
        this.removedLockIDs.clear();
    }

    public void deleteLocks() throws OXException {
        ServerSession session = this.getSession();
        this.lockManager.removeAll(this.id, session.getContext(), UserStorage.getStorageUser(session.getUserId(), session.getContext()), UserConfigurationStorage.getInstance().getUserConfigurationSafe(session.getUserId(), session.getContext()));
    }

    public void transferLock(WebdavLock lock) throws OXException {
        ServerSession session = this.getSession();
        this.lockManager.insertLock(this.id, this.toLock(lock), session.getContext(), UserStorage.getStorageUser(session.getUserId(), session.getContext()), UserConfigurationStorage.getInstance().getUserConfigurationSafe(session.getUserId(), session.getContext()));
    }

    private ServerSession getSession() throws OXException {
        return ServerSessionAdapter.valueOf(this.sessionHolder.getSessionObject());
    }
}

