/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.osgi;

import com.openexchange.database.CreateTableService;
import com.openexchange.database.provider.DBPoolProvider;
import com.openexchange.file.storage.registry.FileStorageServiceRegistry;
import com.openexchange.groupware.impl.FolderLockManagerImpl;
import com.openexchange.groupware.infostore.InfostoreAvailable;
import com.openexchange.groupware.infostore.database.impl.InfostoreFilenameReservationsCreateTableTask;
import com.openexchange.groupware.infostore.webdav.EntityLockManagerImpl;
import com.openexchange.groupware.infostore.webdav.LockCleaner;
import com.openexchange.groupware.infostore.webdav.PropertyCleaner;
import com.openexchange.groupware.infostore.webdav.PropertyStoreImpl;
import com.openexchange.groupware.update.UpdateTaskProviderService;
import com.openexchange.groupware.update.UpdateTaskV2;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.EventHandler;
import org.osgi.util.tracker.ServiceTracker;

public class InfostoreActivator
implements BundleActivator {
    public static final AtomicReference<InfostoreAvailable> INFOSTORE_FILE_STORAGE_AVAILABLE = new AtomicReference();
    private volatile Queue<ServiceRegistration<?>> registrations;
    private volatile ServiceTracker<FileStorageServiceRegistry, FileStorageServiceRegistry> tracker;

    public void start(BundleContext context) throws Exception {
        try {
            final InfostoreFilenameReservationsCreateTableTask task = new InfostoreFilenameReservationsCreateTableTask();
            LockCleaner lockCleaner = new LockCleaner(new FolderLockManagerImpl(new DBPoolProvider()), new EntityLockManagerImpl(new DBPoolProvider(), "infostore_lock"));
            PropertyCleaner propertyCleaner = new PropertyCleaner(new PropertyStoreImpl(new DBPoolProvider(), "oxfolder_property"), new PropertyStoreImpl(new DBPoolProvider(), "infostore_property"));
            Hashtable<String, String> serviceProperties = new Hashtable<String, String>(1);
            ((Dictionary)serviceProperties).put("event.topics", "com/openexchange/groupware/infostore/*");
            LinkedList registrations = new LinkedList();
            registrations.offer(context.registerService(CreateTableService.class.getName(), (Object)task, null));
            registrations.offer(context.registerService(UpdateTaskProviderService.class.getName(), (Object)new UpdateTaskProviderService(){

                public Collection<UpdateTaskV2> getUpdateTasks() {
                    return Arrays.asList(task);
                }
            }, null));
            registrations.offer(context.registerService(EventHandler.class, (Object)lockCleaner, serviceProperties));
            registrations.offer(context.registerService(EventHandler.class, (Object)propertyCleaner, serviceProperties));
            this.registrations = registrations;
            final class AvailableTracker
            extends ServiceTracker<FileStorageServiceRegistry, FileStorageServiceRegistry> {
                AvailableTracker(BundleContext context) {
                    super(context, FileStorageServiceRegistry.class, null);
                }

                public FileStorageServiceRegistry addingService(ServiceReference<FileStorageServiceRegistry> reference) {
                    final FileStorageServiceRegistry registry = (FileStorageServiceRegistry)super.addingService(reference);
                    INFOSTORE_FILE_STORAGE_AVAILABLE.set(new InfostoreAvailable(){

                        @Override
                        public boolean available() {
                            return registry.containsFileStorageService("com.openexchange.infostore");
                        }
                    });
                    return registry;
                }

                public void removedService(ServiceReference<FileStorageServiceRegistry> reference, FileStorageServiceRegistry service) {
                    INFOSTORE_FILE_STORAGE_AVAILABLE.set(null);
                    super.removedService(reference, (Object)service);
                }
            }
            AvailableTracker tracker = new AvailableTracker(context);
            tracker.open();
            this.tracker = tracker;
        }
        catch (Exception e) {
            Log logger = com.openexchange.log.Log.loggerFor(InfostoreActivator.class);
            logger.error((Object)"Starting InfostoreActivator failed.", (Throwable)e);
            throw e;
        }
    }

    public void stop(BundleContext context) throws Exception {
        try {
            Queue<ServiceRegistration<?>> registrations;
            ServiceTracker<FileStorageServiceRegistry, FileStorageServiceRegistry> tracker = this.tracker;
            if (null != tracker) {
                tracker.close();
                this.tracker = null;
            }
            if (null != (registrations = this.registrations)) {
                ServiceRegistration<?> polled;
                while ((polled = registrations.poll()) != null) {
                    polled.unregister();
                }
                this.registrations = null;
            }
        }
        catch (Exception e) {
            Log logger = com.openexchange.log.Log.loggerFor(InfostoreActivator.class);
            logger.error((Object)"Stopping InfostoreActivator failed.", (Throwable)e);
            throw e;
        }
    }
}

