/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.database.impl;

import com.openexchange.database.tx.AbstractDBAction;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.database.impl.AbstractDocumentListAction;
import com.openexchange.groupware.infostore.database.impl.InfostoreQueryCatalog;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class DeleteDocumentAction
extends AbstractDocumentListAction {
    private static final int batchSize = 1000;

    protected void undoAction() throws OXException {
        if (this.getDocuments().size() == 0) {
            return;
        }
        AbstractDBAction.UpdateBlock[] updates = new AbstractDBAction.UpdateBlock[this.getDocuments().size()];
        int i = 0;
        for (final DocumentMetadata doc : this.getDocuments()) {
            updates[i++] = new AbstractDBAction.Update(this.getQueryCatalog().getDocumentInsert()){

                @Override
                public void fillStatement() throws SQLException {
                    DeleteDocumentAction.this.fillStmt(this.stmt, DeleteDocumentAction.this.getQueryCatalog().getWritableDocumentFields(), doc, DeleteDocumentAction.this.getContext().getContextId());
                }
            };
        }
        this.doUpdates(updates);
    }

    public void perform() throws OXException {
        if (this.getDocuments().size() == 0) {
            return;
        }
        List<DocumentMetadata> documents = this.getDocuments();
        List<DocumentMetadata>[] slices = this.getSlices(1000, documents);
        ArrayList<AbstractDBAction.UpdateBlock> updates = new ArrayList<AbstractDBAction.UpdateBlock>();
        int size = slices.length;
        for (int j = 0; j < size; ++j) {
            updates.add(new AbstractDBAction.Update(this.getQueryCatalog().getDelete(InfostoreQueryCatalog.Table.INFOSTORE, this.getDocuments())){

                @Override
                public void fillStatement() throws SQLException {
                    this.stmt.setInt(1, DeleteDocumentAction.this.getContext().getContextId());
                }
            });
        }
        this.doUpdates(updates);
    }

    @Override
    protected Object[] getAdditionals(DocumentMetadata doc) {
        return null;
    }
}

