/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Format
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int HTML = 1;
    public static final int PDF = 2;
    public static final int WIKI = 3;
    public static final int WIKI_WITH_XML = 4;
    public static final int MS_WORD_DOC = 5;
    public static final int OPEN_OFFICE = 6;
    public static final Format HTML_LITERAL = new Format(1, "HTML", "text/html", "html");
    public static final Format PDF_LITERAL = new Format(2, "PDF", "application/octet-stream", "pdf");
    public static final Format WIKI_LITERAL = new Format(3, "WIKI", "text/plain", "wiki");
    public static final Format WIKI_WITH_XML_LITERAL = new Format(4, "WIKI_WITH_XML", "text/plain", "xwiki");
    public static final Format MS_WORD_DOC_LITERAL = new Format(5, "MS_WORD_DOC", "text/todo", "doc");
    public static final Format OPEN_OFFICE_LITERAL = new Format(6, "OPEN_OFFICE", "text/todo", "odt");
    private static final Format[] VALUES_ARRAY = new Format[]{HTML_LITERAL, PDF_LITERAL, WIKI_LITERAL, WIKI_WITH_XML_LITERAL, MS_WORD_DOC_LITERAL, OPEN_OFFICE_LITERAL};
    public static final transient List<Format> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    private final int id;
    private final String name;
    private final String mimeType;
    private final String extension;

    private Format(int id, String name, String mimeType, String extension) {
        this.id = id;
        this.name = name;
        this.mimeType = mimeType;
        this.extension = extension;
    }

    public static Format get(int i) {
        switch (i) {
            case 1: {
                return HTML_LITERAL;
            }
            case 2: {
                return PDF_LITERAL;
            }
            case 3: {
                return WIKI_LITERAL;
            }
            case 4: {
                return WIKI_WITH_XML_LITERAL;
            }
            case 5: {
                return MS_WORD_DOC_LITERAL;
            }
        }
        return null;
    }

    public static Format get(String format) {
        for (Format f : VALUES) {
            if (!f.getName().equals(format)) continue;
            return f;
        }
        return null;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getExtension() {
        return this.extension;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (null == o) {
            return false;
        }
        try {
            return ((Format)o).id == this.id;
        }
        catch (ClassCastException x) {
            return false;
        }
    }

    public static Format getByExtension(String extension) {
        for (Format f : VALUES) {
            if (!f.getExtension().equals(extension)) continue;
            return f;
        }
        return null;
    }
}

