/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.attach.impl;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.attach.AttachmentAuthorization;
import com.openexchange.groupware.attach.AttachmentExceptionCodes;
import com.openexchange.java.Autoboxing;
import com.openexchange.tools.service.ServicePriorityConflictException;
import com.openexchange.tools.service.SpecificServiceChooser;
import com.openexchange.tools.session.ServerSession;

public class OverridableAttachmentAuthorization
implements AttachmentAuthorization {
    private final SpecificServiceChooser<AttachmentAuthorization> chooser;

    public OverridableAttachmentAuthorization(SpecificServiceChooser<AttachmentAuthorization> chooser) {
        this.chooser = chooser;
    }

    @Override
    public void checkMayAttach(ServerSession session, int folderId, int objectId) throws OXException {
        this.getDelegate(folderId, session.getContextId()).checkMayAttach(session, folderId, objectId);
    }

    @Override
    public void checkMayDetach(ServerSession session, int folderId, int objectId) throws OXException {
        this.getDelegate(folderId, session.getContextId()).checkMayDetach(session, folderId, objectId);
    }

    @Override
    public void checkMayReadAttachments(ServerSession session, int folderId, int objectId) throws OXException {
        this.getDelegate(folderId, session.getContextId()).checkMayReadAttachments(session, folderId, objectId);
    }

    private AttachmentAuthorization getDelegate(int folderId, int contextId) throws OXException {
        try {
            return this.chooser.choose(contextId, folderId);
        }
        catch (ServicePriorityConflictException e) {
            throw AttachmentExceptionCodes.SERVICE_CONFLICT.create(Autoboxing.I((int)contextId), Autoboxing.I((int)folderId));
        }
    }
}

