/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.group.json.actions;

import com.openexchange.ajax.parser.DataParser;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.writer.GroupWriter;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.group.Group;
import com.openexchange.group.GroupStorage;
import com.openexchange.group.json.GroupAJAXRequest;
import com.openexchange.group.json.actions.AbstractGroupAction;
import com.openexchange.server.ServiceLookup;
import com.openexchange.tools.session.ServerSession;
import java.util.Date;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Action(method=RequestMethod.PUT, name="search", description="Search groups", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module.")}, requestBody="An object with search parameters as described in Group search.", responseDescription="Response with timestamp: An array of group objects as described in Group data.")
public final class SearchAction
extends AbstractGroupAction {
    public SearchAction(ServiceLookup services) {
        super(services);
    }

    @Override
    protected AJAXRequestResult perform(GroupAJAXRequest req) throws OXException, JSONException {
        JSONObject jData = (JSONObject)req.getData();
        String searchpattern = null;
        if (jData.has("pattern")) {
            searchpattern = DataParser.parseString(jData, "pattern");
        }
        Date timestamp = new Date(0L);
        ServerSession session = req.getSession();
        JSONArray jsonResponseArray = new JSONArray();
        GroupStorage groupStorage = GroupStorage.getInstance();
        Group[] groups = null;
        groups = "*".equals(searchpattern) ? groupStorage.getGroups(true, session.getContext()) : groupStorage.searchGroups(searchpattern, true, session.getContext());
        GroupWriter groupWriter = new GroupWriter();
        for (int a = 0; a < groups.length; ++a) {
            JSONObject jsonGroupObj = new JSONObject();
            groupWriter.writeGroup(groups[a], jsonGroupObj);
            if (groups[a].getLastModified().after(timestamp)) {
                timestamp = groups[a].getLastModified();
            }
            jsonResponseArray.put((Object)jsonGroupObj);
        }
        return new AJAXRequestResult(jsonResponseArray, timestamp, "json");
    }
}

