/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.group.internal;

import com.openexchange.exception.OXException;
import com.openexchange.group.Group;
import com.openexchange.group.GroupExceptionCodes;
import com.openexchange.group.GroupStorage;
import com.openexchange.group.internal.GroupTools;
import com.openexchange.group.internal.Logic;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.java.Autoboxing;
import com.openexchange.log.LogFactory;
import com.openexchange.server.impl.DBPool;
import com.openexchange.tools.oxfolder.OXFolderAdminHelper;
import com.openexchange.tools.sql.DBUtils;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import org.apache.commons.logging.Log;

final class Update {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(Update.class));
    private final Context ctx;
    private final User user;
    private final Group changed;
    private final Date lastRead;
    private static final GroupStorage storage = GroupStorage.getInstance();
    private Group orig;
    private final TIntSet addedMembers = new TIntHashSet();
    private final TIntSet removedMembers = new TIntHashSet();
    private boolean memberPrepared = false;

    Update(Context ctx, User user, Group group, Date lastRead) {
        this.ctx = ctx;
        this.user = user;
        this.changed = group;
        this.lastRead = lastRead;
    }

    Group getOrig() throws OXException {
        if (null == this.orig) {
            this.orig = storage.getGroup(this.changed.getIdentifier(), this.ctx);
        }
        return this.orig;
    }

    void perform() throws OXException {
        this.allowed();
        this.check();
        this.prepare();
        this.update();
        this.propagate();
    }

    private void allowed() throws OXException {
        if (!UserConfigurationStorage.getInstance().getUserConfiguration(this.user.getId(), this.ctx).isEditGroup()) {
            throw GroupExceptionCodes.NO_MODIFY_PERMISSION.create();
        }
        if (this.changed.getIdentifier() == GroupTools.GROUP_ZERO.getIdentifier()) {
            try {
                throw GroupExceptionCodes.NO_GROUP_UPDATE.create(GroupTools.getGroupZero(this.ctx).getDisplayName());
            }
            catch (OXException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                throw GroupExceptionCodes.NO_GROUP_UPDATE.create(Autoboxing.I((int)0));
            }
        }
    }

    private void check() throws OXException {
        if (null == this.changed) {
            throw GroupExceptionCodes.NULL.create();
        }
        if (0 == this.changed.getIdentifier()) {
            throw GroupExceptionCodes.NO_GROUP_UPDATE.create(this.getOrig().getDisplayName());
        }
        if (this.getOrig().getLastModified().after(this.lastRead)) {
            throw GroupExceptionCodes.MODIFIED.create();
        }
        Logic.checkMandatoryForUpdate(this.changed);
        Logic.validateSimpleName(this.changed);
        Logic.checkData(this.changed);
        Logic.checkForDuplicate(storage, this.ctx, this.changed);
        Logic.doMembersExist(this.ctx, this.changed);
    }

    private void prepare() throws OXException {
        this.prepareFields();
        this.prepareMember();
    }

    private void prepareFields() throws OXException {
        if (!this.changed.isDisplayNameSet()) {
            this.changed.setDisplayName(this.getOrig().getDisplayName());
        }
        if (!this.changed.isSimpleNameSet()) {
            this.changed.setSimpleName(this.getOrig().getSimpleName());
        }
    }

    private void prepareMember() throws OXException {
        if (this.memberPrepared) {
            return;
        }
        if (this.changed.isMemberSet()) {
            for (int member : this.changed.getMember()) {
                this.addedMembers.add(member);
            }
            for (int member : this.getOrig().getMember()) {
                this.addedMembers.remove(member);
                this.removedMembers.add(member);
            }
            for (int member : this.changed.getMember()) {
                this.removedMembers.remove(member);
            }
        } else {
            this.changed.setMember(this.getOrig().getMember());
        }
        this.memberPrepared = true;
    }

    private void update() throws OXException {
        Connection con = DBPool.pickupWriteable(this.ctx);
        try {
            con.setAutoCommit(false);
            this.update(con);
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw GroupExceptionCodes.SQL_ERROR.create(e, e.getMessage());
        }
        catch (OXException e) {
            DBUtils.rollback(con);
            throw e;
        }
        finally {
            try {
                con.setAutoCommit(true);
            }
            catch (SQLException e) {
                LOG.error((Object)"Problem setting autocommit to true.", (Throwable)e);
            }
            DBPool.closeWriterSilent(this.ctx, con);
        }
    }

    public void update(Connection con) throws OXException {
        storage.updateGroup(this.ctx, con, this.changed, this.lastRead);
        int[] tmp = new int[this.addedMembers.size()];
        TIntIterator iter = this.addedMembers.iterator();
        int i = 0;
        while (iter.hasNext()) {
            tmp[i] = iter.next();
            ++i;
        }
        storage.insertMember(this.ctx, con, this.changed, tmp);
        tmp = new int[this.removedMembers.size()];
        iter = this.removedMembers.iterator();
        i = 0;
        while (iter.hasNext()) {
            tmp[i] = iter.next();
            ++i;
        }
        storage.deleteMember(this.ctx, con, this.changed, tmp);
    }

    private void propagate() throws OXException {
        int[] tmp = new int[this.addedMembers.size() + this.removedMembers.size()];
        TIntIterator iter = this.addedMembers.iterator();
        int i = 0;
        while (iter.hasNext()) {
            tmp[i++] = iter.next();
        }
        iter = this.removedMembers.iterator();
        while (iter.hasNext()) {
            tmp[i++] = iter.next();
        }
        UserStorage storage = UserStorage.getInstance();
        storage.invalidateUser(this.ctx, tmp);
        Connection con = DBPool.pickupWriteable(this.ctx);
        try {
            con.setAutoCommit(false);
            this.propagate(con);
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw GroupExceptionCodes.SQL_ERROR.create(e, e.getMessage());
        }
        catch (OXException e) {
            DBUtils.rollback(con);
            throw e;
        }
        finally {
            try {
                con.setAutoCommit(true);
            }
            catch (SQLException e) {
                LOG.error((Object)"Problem setting autocommit to true.", (Throwable)e);
            }
            DBPool.closeWriterSilent(this.ctx, con);
        }
    }

    private void propagate(Connection con) throws OXException {
        try {
            OXFolderAdminHelper.propagateGroupModification(this.changed.getIdentifier(), con, con, this.ctx.getContextId());
        }
        catch (SQLException e) {
            throw GroupExceptionCodes.SQL_ERROR.create(e, e.getMessage());
        }
    }
}

