/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.database.getfolder;

import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.database.DatabaseFolder;
import com.openexchange.folderstorage.database.LocalizedDatabaseFolder;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.tools.iterator.FolderObjectIterator;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.oxfolder.OXFolderIteratorSQL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;

public final class VirtualListFolder {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(VirtualListFolder.class));

    private VirtualListFolder() {
    }

    public static boolean existsVirtualListFolder(int folderId, User user, UserConfiguration userConfiguration, Context ctx, Connection con) throws OXException {
        int module = 11 == folderId ? 1 : (12 == folderId ? 2 : (13 == folderId ? 3 : 8));
        return OXFolderIteratorSQL.hasVisibleFoldersNotSeenInTreeView(module, user.getId(), user.getGroups(), userConfiguration, ctx, con);
    }

    public static DatabaseFolder getVirtualListFolder(int folderId, boolean altNames) {
        FolderObject fo;
        if (11 == folderId) {
            fo = FolderObject.createVirtualFolderObject(folderId, "Other task folders", 5, true, 5);
            fo.setParentFolderID(2);
        } else if (12 == folderId) {
            fo = FolderObject.createVirtualFolderObject(folderId, "Other calendar folders", 5, true, 5);
            fo.setParentFolderID(2);
        } else if (13 == folderId) {
            fo = FolderObject.createVirtualFolderObject(folderId, "Other contact folders", 5, true, 5);
            fo.setParentFolderID(2);
        } else {
            fo = FolderObject.createVirtualFolderObject(folderId, altNames ? "Other files" : "Other infostore folders", 8, true, 5);
            fo.setParentFolderID(9);
        }
        LocalizedDatabaseFolder retval = new LocalizedDatabaseFolder(fo);
        retval.setSubfolderIDs(null);
        retval.setSubscribedSubfolders(true);
        retval.setGlobal(true);
        return retval;
    }

    public static int[] getVirtualListFolderSubfoldersAsInt(int folderId, User user, UserConfiguration userConfiguration, Context ctx, Connection con) throws OXException {
        int module = 11 == folderId ? 1 : (12 == folderId ? 2 : (13 == folderId ? 3 : 8));
        Queue<FolderObject> q = ((FolderObjectIterator)OXFolderIteratorSQL.getVisibleFoldersNotSeenInTreeView(module, user.getId(), user.getGroups(), userConfiguration, ctx, con)).asQueue();
        int[] subfolderIds = new int[q.size()];
        int i = 0;
        for (FolderObject folderObject : q) {
            subfolderIds[i++] = folderObject.getObjectID();
        }
        return subfolderIds;
    }

    public static List<String[]> getVirtualListFolderSubfolders(int folderId, User user, UserConfiguration userConfiguration, Context ctx, Connection con) throws OXException {
        int module = 11 == folderId ? 1 : (12 == folderId ? 2 : (13 == folderId ? 3 : 8));
        Queue<FolderObject> q = ((FolderObjectIterator)OXFolderIteratorSQL.getVisibleFoldersNotSeenInTreeView(module, user.getId(), user.getGroups(), userConfiguration, ctx, con)).asQueue();
        ArrayList<String[]> ret = new ArrayList<String[]>(q.size());
        for (FolderObject folderObject : q) {
            ret.add(new String[]{String.valueOf(folderObject.getObjectID()), folderObject.getFolderName()});
        }
        return ret;
    }
}

