/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.database;

import com.openexchange.folderstorage.SortableId;
import com.openexchange.java.StringAllocator;

public final class DatabaseId
implements SortableId {
    private final String folderId;
    private final int ordinal;
    private final String name;

    public DatabaseId(int folderId, int ordinal, String name) {
        this.folderId = String.valueOf(folderId);
        this.ordinal = ordinal;
        this.name = name;
    }

    public DatabaseId(String folderId, int ordinal, String name) {
        this.folderId = folderId;
        this.ordinal = ordinal;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getId() {
        return this.folderId;
    }

    @Override
    public SortableId.Priority getPriority() {
        return SortableId.Priority.LOW;
    }

    @Override
    public int compareTo(SortableId o) {
        int anotherPrio;
        if (o instanceof DatabaseId) {
            int thisVal = this.ordinal;
            int anotherVal = ((DatabaseId)o).ordinal;
            return thisVal < anotherVal ? -1 : (thisVal == anotherVal ? 0 : 1);
        }
        int thisPrio = this.getPriority().ordinal();
        return thisPrio < (anotherPrio = o.getPriority().ordinal()) ? 1 : (thisPrio == anotherPrio ? 0 : -1);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.ordinal;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DatabaseId)) {
            return false;
        }
        DatabaseId other = (DatabaseId)obj;
        return this.ordinal == other.ordinal;
    }

    public String toString() {
        return new StringAllocator(32).append("{folderId=").append(this.folderId).append(", ordinal=").append(this.ordinal).append('}').toString();
    }
}

