/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.database;

import com.openexchange.cache.impl.FolderCacheManager;
import com.openexchange.database.DatabaseService;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.FileStorageAccount;
import com.openexchange.file.storage.FileStorageAccountAccess;
import com.openexchange.file.storage.FileStorageFolder;
import com.openexchange.file.storage.FileStorageService;
import com.openexchange.folderstorage.ContentType;
import com.openexchange.folderstorage.Folder;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.FolderType;
import com.openexchange.folderstorage.Permission;
import com.openexchange.folderstorage.SortableId;
import com.openexchange.folderstorage.StorageParameters;
import com.openexchange.folderstorage.StorageParametersUtility;
import com.openexchange.folderstorage.StoragePriority;
import com.openexchange.folderstorage.StorageType;
import com.openexchange.folderstorage.SystemContentType;
import com.openexchange.folderstorage.Type;
import com.openexchange.folderstorage.database.DatabaseFolder;
import com.openexchange.folderstorage.database.DatabaseFolderConverter;
import com.openexchange.folderstorage.database.DatabaseFolderStorageUtility;
import com.openexchange.folderstorage.database.DatabaseFolderType;
import com.openexchange.folderstorage.database.DatabaseId;
import com.openexchange.folderstorage.database.DatabaseServiceRegistry;
import com.openexchange.folderstorage.database.FolderIdNamePair;
import com.openexchange.folderstorage.database.contentType.CalendarContentType;
import com.openexchange.folderstorage.database.contentType.ContactContentType;
import com.openexchange.folderstorage.database.contentType.InfostoreContentType;
import com.openexchange.folderstorage.database.contentType.TaskContentType;
import com.openexchange.folderstorage.database.contentType.UnboundContentType;
import com.openexchange.folderstorage.database.getfolder.SharedPrefixFolder;
import com.openexchange.folderstorage.database.getfolder.SystemInfostoreFolder;
import com.openexchange.folderstorage.database.getfolder.SystemPrivateFolder;
import com.openexchange.folderstorage.database.getfolder.SystemPublicFolder;
import com.openexchange.folderstorage.database.getfolder.SystemRootFolder;
import com.openexchange.folderstorage.database.getfolder.SystemSharedFolder;
import com.openexchange.folderstorage.database.getfolder.VirtualListFolder;
import com.openexchange.folderstorage.filestorage.FileStorageFolderIdentifier;
import com.openexchange.folderstorage.type.PrivateType;
import com.openexchange.folderstorage.type.PublicType;
import com.openexchange.folderstorage.type.SharedType;
import com.openexchange.folderstorage.type.SystemType;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.infostore.InfostoreFacades;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.tools.iterator.FolderObjectIterator;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.session.Session;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.oxfolder.OXFolderBatchLoader;
import com.openexchange.tools.oxfolder.OXFolderExceptionCode;
import com.openexchange.tools.oxfolder.OXFolderIteratorSQL;
import com.openexchange.tools.oxfolder.OXFolderLoader;
import com.openexchange.tools.oxfolder.OXFolderManager;
import com.openexchange.tools.oxfolder.OXFolderSQL;
import com.openexchange.tools.oxfolder.OXFolderUtility;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import com.openexchange.tools.sql.DBUtils;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Queue;

public final class DatabaseFolderStorage
implements FolderStorage {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(DatabaseFolderStorage.class));
    private static final String PARAM_CONNECTION = "DB.Con";
    private static final int MAX = 3;
    private static final TIntSet SPECIALS = new TIntHashSet(new int[]{1, 2, 10});
    private static final int[] PUBLIC_FOLDER_IDS = new int[]{2, 9, 10, 15};
    private static final int[] VIRTUAL_IDS = new int[]{11, 12, 13, 14};

    @Override
    public void clearCache(int userId, int contextId) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void checkConsistency(String treeId, StorageParameters storageParameters) throws OXException {
        DatabaseService databaseService = DatabaseServiceRegistry.getService(DatabaseService.class, true);
        int contextId = storageParameters.getContextId();
        Connection con = null;
        boolean close = true;
        try {
            ConnectionMode conMode = DatabaseFolderStorage.optParameter(ConnectionMode.class, PARAM_CONNECTION, storageParameters);
            if (null != conMode && conMode.readWrite) {
                con = conMode.connection;
                close = false;
            } else {
                con = databaseService.getWritable(contextId);
            }
            ServerSession session = ServerSessionAdapter.valueOf(storageParameters.getSession());
            if (null == session) {
                throw FolderExceptionErrorMessage.MISSING_SESSION.create(new Object[0]);
            }
            Context context = session.getContext();
            int[] nonExistingParents = OXFolderSQL.getNonExistingParents(context, con);
            TIntHashSet shared = new TIntHashSet();
            OXFolderManager manager = OXFolderManager.getInstance(session, con, con);
            OXFolderAccess folderAccess = DatabaseFolderStorage.getFolderAccess(context, con);
            int userId = session.getUserId();
            long now = System.currentTimeMillis();
            int runCount = 0;
            TIntHashSet tmp = new TIntHashSet();
            do {
                for (int folderId : nonExistingParents) {
                    if (folderId < 20) continue;
                    if (3 == folderAccess.getFolderType(folderId, userId)) {
                        shared.add(folderId);
                        continue;
                    }
                    manager.deleteValidatedFolder(folderId, now, -1, true);
                }
                tmp.clear();
                tmp.addAll(OXFolderSQL.getNonExistingParents(context, con));
                if (tmp.isEmpty()) {
                    nonExistingParents = null;
                    continue;
                }
                tmp.removeAll(shared.toArray());
                for (int i = 0; i < 20; ++i) {
                    tmp.remove(i);
                }
                nonExistingParents = tmp.toArray();
            } while (++runCount <= 3 && null != nonExistingParents && nonExistingParents.length > 0);
            if (null == con || !close) return;
        }
        catch (Throwable throwable) {
            if (null == con || !close) throw throwable;
            databaseService.backWritable(contextId, con);
            throw throwable;
        }
        databaseService.backWritable(contextId, con);
    }

    @Override
    public ContentType[] getSupportedContentTypes() {
        return new ContentType[]{TaskContentType.getInstance(), CalendarContentType.getInstance(), ContactContentType.getInstance(), InfostoreContentType.getInstance(), UnboundContentType.getInstance(), SystemContentType.getInstance()};
    }

    @Override
    public ContentType getDefaultContentType() {
        return ContactContentType.getInstance();
    }

    @Override
    public void commitTransaction(StorageParameters params) throws OXException {
        ConnectionMode con;
        try {
            con = DatabaseFolderStorage.optParameter(ConnectionMode.class, PARAM_CONNECTION, params);
        }
        catch (OXException e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Storage already committed:\n" + params.getCommittedTrace()), (Throwable)e);
            }
            return;
        }
        if (null == con) {
            return;
        }
        if (con.readWrite) {
            try {
                con.connection.commit();
            }
            catch (SQLException e) {
                throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
            }
            finally {
                DBUtils.autocommit(con.connection);
                DatabaseService databaseService = (DatabaseService)DatabaseServiceRegistry.getServiceRegistry().getService(DatabaseService.class);
                if (null != databaseService) {
                    databaseService.backWritable(params.getContext(), con.connection);
                }
                FolderType folderType = this.getFolderType();
                params.putParameter(folderType, PARAM_CONNECTION, null);
                params.markCommitted();
            }
        } else {
            DatabaseService databaseService = (DatabaseService)DatabaseServiceRegistry.getServiceRegistry().getService(DatabaseService.class);
            if (null != databaseService) {
                databaseService.backReadOnly(params.getContext(), con.connection);
            }
            FolderType folderType = this.getFolderType();
            params.putParameter(folderType, PARAM_CONNECTION, null);
            params.markCommitted();
        }
    }

    @Override
    public void restore(String treeId, String folderIdentifier, StorageParameters storageParameters) throws OXException {
        ConnectionProvider provider = DatabaseFolderStorage.getConnection(true, storageParameters);
        try {
            Connection con = provider.getConnection();
            Session session = storageParameters.getSession();
            if (null == session) {
                throw FolderExceptionErrorMessage.MISSING_SESSION.create(new Object[0]);
            }
            int folderId = Integer.parseInt(folderIdentifier);
            Context context = storageParameters.getContext();
            FolderObject.loadFolderObjectFromDB(folderId, context, con, false, false, "del_oxfolder_tree", "del_oxfolder_permissions");
            OXFolderSQL.restore(folderId, context, null);
        }
        catch (NumberFormatException e) {
            throw FolderExceptionErrorMessage.INVALID_FOLDER_ID.create(folderIdentifier);
        }
        catch (SQLException e) {
            throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
        }
        finally {
            provider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createFolder(Folder folder, StorageParameters storageParameters) throws OXException {
        ConnectionProvider provider = DatabaseFolderStorage.getConnection(true, storageParameters);
        try {
            Type t;
            String parentId;
            Connection con = provider.getConnection();
            Session session = storageParameters.getSession();
            if (null == session) {
                throw FolderExceptionErrorMessage.MISSING_SESSION.create(new Object[0]);
            }
            long millis = System.currentTimeMillis();
            FolderObject createMe = new FolderObject();
            createMe.setCreatedBy(session.getUserId());
            createMe.setCreationDate(new Date(millis));
            createMe.setCreator(session.getUserId());
            createMe.setDefaultFolder(false);
            String name = folder.getName();
            if (null != name) {
                createMe.setFolderName(name);
            }
            createMe.setLastModified(new Date(millis));
            createMe.setModifiedBy(session.getUserId());
            ContentType ct = folder.getContentType();
            if (null != ct) {
                createMe.setModule(DatabaseFolderStorage.getModuleByContentType(ct));
            }
            if (null != (parentId = folder.getParentID())) {
                createMe.setParentFolderID(Integer.parseInt(parentId));
            }
            if (null == (t = folder.getType())) {
                createMe.setType(DatabaseFolderStorage.getFolderType(createMe.getParentFolderID(), storageParameters.getContext(), con));
            } else {
                createMe.setType(DatabaseFolderStorage.getTypeByFolderType(t));
            }
            Permission[] perms = folder.getPermissions();
            if (null != perms) {
                OCLPermission[] oclPermissions = new OCLPermission[perms.length];
                for (int i = 0; i < perms.length; ++i) {
                    Permission p = perms[i];
                    OCLPermission oclPerm = new OCLPermission();
                    oclPerm.setEntity(p.getEntity());
                    oclPerm.setGroupPermission(p.isGroup());
                    oclPerm.setFolderAdmin(p.isAdmin());
                    oclPerm.setAllPermission(p.getFolderPermission(), p.getReadPermission(), p.getWritePermission(), p.getDeletePermission());
                    oclPerm.setSystem(p.getSystem());
                    oclPermissions[i] = oclPerm;
                }
                createMe.setPermissionsAsArray(oclPermissions);
            } else {
                int parentFolderID = createMe.getParentFolderID();
                FolderObject parent = DatabaseFolderStorage.getFolderObject(parentFolderID, storageParameters.getContext(), con);
                int userId = storageParameters.getUserId();
                boolean isShared = parent.isShared(userId);
                boolean isSystem = 5 == parent.getModule();
                List<OCLPermission> parentPermissions = parent.getPermissions();
                ArrayList<OCLPermission> permissions = new ArrayList<OCLPermission>((isSystem ? 0 : parentPermissions.size()) + 1);
                if (isShared) {
                    permissions.add(DatabaseFolderStorage.newMaxPermissionFor(parent.getCreatedBy()));
                    permissions.add(DatabaseFolderStorage.newStandardPermissionFor(userId));
                } else {
                    permissions.add(DatabaseFolderStorage.newMaxPermissionFor(userId));
                }
                if (!isSystem) {
                    TIntHashSet ignore = new TIntHashSet(2);
                    ignore.add(userId);
                    if (isShared) {
                        ignore.add(parent.getCreatedBy());
                    }
                    for (OCLPermission permission : parentPermissions) {
                        if (permission.getSystem() > 0 || !permission.isGroupPermission() && ignore.contains(permission.getEntity())) continue;
                        permissions.add(permission);
                    }
                }
                createMe.setPermissions(permissions);
            }
            OXFolderManager folderManager = OXFolderManager.getInstance(session, con, con);
            folderManager.createFolder(createMe, true, millis);
            int fuid = createMe.getObjectID();
            if (fuid <= 0) {
                throw OXFolderExceptionCode.CREATE_FAILED.create(new Object[0]);
            }
            folder.setID(String.valueOf(fuid));
        }
        finally {
            provider.close();
        }
    }

    private static OCLPermission newMaxPermissionFor(int entity) {
        OCLPermission oclPerm = new OCLPermission();
        oclPerm.setEntity(entity);
        oclPerm.setGroupPermission(false);
        oclPerm.setFolderAdmin(true);
        oclPerm.setAllPermission(128, 128, 128, 128);
        oclPerm.setSystem(0);
        return oclPerm;
    }

    private static OCLPermission newStandardPermissionFor(int entity) {
        OCLPermission oclPerm = new OCLPermission();
        oclPerm.setEntity(entity);
        oclPerm.setGroupPermission(false);
        oclPerm.setFolderAdmin(false);
        oclPerm.setAllPermission(2, 4, 4, 4);
        oclPerm.setSystem(0);
        return oclPerm;
    }

    private static int getFolderType(int parentId, Context ctx, Connection con) throws OXException, OXException {
        int type = -1;
        int pid = parentId;
        if (pid == 3) {
            pid = 1;
            type = 3;
        } else {
            type = pid == 1 ? 1 : (Arrays.binarySearch(PUBLIC_FOLDER_IDS, pid) >= 0 ? 2 : (pid == 8 ? 6 : DatabaseFolderStorage.getFolderAccess(ctx, con).getFolderType(pid)));
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearFolder(String treeId, String folderId, StorageParameters storageParameters) throws OXException {
        ConnectionProvider provider = DatabaseFolderStorage.getConnection(true, storageParameters);
        try {
            Connection con = provider.getConnection();
            FolderObject fo = DatabaseFolderStorage.getFolderObject(Integer.parseInt(folderId), storageParameters.getContext(), con);
            Session session = storageParameters.getSession();
            if (null == session) {
                throw FolderExceptionErrorMessage.MISSING_SESSION.create(new Object[0]);
            }
            OXFolderManager folderManager = OXFolderManager.getInstance(session, con, con);
            folderManager.clearFolder(fo, true, System.currentTimeMillis());
        }
        finally {
            provider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteFolder(String treeId, String folderIdentifier, StorageParameters storageParameters) throws OXException {
        ConnectionProvider provider = DatabaseFolderStorage.getConnection(true, storageParameters);
        try {
            Connection con = provider.getConnection();
            FolderObject fo = new FolderObject();
            int folderId = Integer.parseInt(folderIdentifier);
            fo.setObjectID(folderId);
            Session session = storageParameters.getSession();
            if (null == session) {
                throw FolderExceptionErrorMessage.MISSING_SESSION.create(new Object[0]);
            }
            OXFolderManager folderManager = OXFolderManager.getInstance(session, con, con);
            folderManager.deleteFolder(fo, true, System.currentTimeMillis());
        }
        finally {
            provider.close();
        }
    }

    @Override
    public String getDefaultFolderID(User user, String treeId, ContentType contentType, Type type, StorageParameters storageParameters) throws OXException {
        ConnectionProvider provider = DatabaseFolderStorage.getConnection(false, storageParameters);
        try {
            int folderId;
            Connection con = provider.getConnection();
            Session session = storageParameters.getSession();
            if (null == session) {
                throw FolderExceptionErrorMessage.MISSING_SESSION.create(new Object[0]);
            }
            Context context = storageParameters.getContext();
            if (TaskContentType.getInstance().equals(contentType)) {
                folderId = OXFolderSQL.getUserDefaultFolder(session.getUserId(), 1, con, context);
            } else if (CalendarContentType.getInstance().equals(contentType)) {
                folderId = OXFolderSQL.getUserDefaultFolder(session.getUserId(), 2, con, context);
            } else if (ContactContentType.getInstance().equals(contentType)) {
                folderId = OXFolderSQL.getUserDefaultFolder(session.getUserId(), 3, con, context);
            } else if (InfostoreContentType.getInstance().equals(contentType)) {
                folderId = OXFolderSQL.getUserDefaultFolder(session.getUserId(), 8, con, context);
            } else {
                String string = null;
                return string;
            }
            String string = String.valueOf(folderId);
            return string;
        }
        catch (SQLException e) {
            throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
        }
        finally {
            provider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Type getTypeByParent(User user, String treeId, String parentId, StorageParameters storageParameters) throws OXException {
        int pid = Integer.parseInt(parentId);
        if (pid == 3) {
            return SharedType.getInstance();
        }
        if (pid == 1) {
            return PrivateType.getInstance();
        }
        if (Arrays.binarySearch(PUBLIC_FOLDER_IDS, pid) >= 0) {
            return PublicType.getInstance();
        }
        if (pid == 8) {
            return SystemType.getInstance();
        }
        ConnectionProvider provider = DatabaseFolderStorage.getConnection(false, storageParameters);
        try {
            FolderObject p = DatabaseFolderStorage.getFolderAccess(storageParameters.getContext(), provider.getConnection()).getFolderObject(pid);
            int parentType = p.getType();
            if (1 == parentType) {
                Type type = p.getCreatedBy() == user.getId() ? PrivateType.getInstance() : SharedType.getInstance();
                return type;
            }
            if (2 == parentType) {
                PublicType publicType = PublicType.getInstance();
                return publicType;
            }
        }
        finally {
            provider.close();
        }
        return SystemType.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsForeignObjects(User user, String treeId, String folderIdentifier, StorageParameters storageParameters) throws OXException {
        ConnectionProvider provider = DatabaseFolderStorage.getConnection(false, storageParameters);
        try {
            Connection con = provider.getConnection();
            Context ctx = storageParameters.getContext();
            int folderId = DatabaseFolderStorageUtility.getUnsignedInteger(folderIdentifier);
            if (folderId < 0) {
                throw OXFolderExceptionCode.NOT_EXISTS.create(folderIdentifier, ctx.getContextId());
            }
            if (0 == folderId) {
                boolean bl = false;
                return bl;
            }
            if (3 == folderId) {
                boolean bl = false;
                return bl;
            }
            if (2 == folderId) {
                boolean bl = false;
                return bl;
            }
            if (9 == folderId) {
                boolean bl = false;
                return bl;
            }
            if (1 == folderId) {
                boolean bl = false;
                return bl;
            }
            if (Arrays.binarySearch(VIRTUAL_IDS, folderId) >= 0) {
                boolean bl = true;
                return bl;
            }
            OXFolderAccess folderAccess = DatabaseFolderStorage.getFolderAccess(ctx, con);
            boolean bl = folderAccess.containsForeignObjects(DatabaseFolderStorage.getFolderObject(folderId, ctx, con), storageParameters.getSession(), ctx);
            return bl;
        }
        finally {
            provider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty(String treeId, String folderIdentifier, StorageParameters storageParameters) throws OXException {
        ConnectionProvider provider = DatabaseFolderStorage.getConnection(false, storageParameters);
        try {
            Connection con = provider.getConnection();
            Context ctx = storageParameters.getContext();
            int folderId = DatabaseFolderStorageUtility.getUnsignedInteger(folderIdentifier);
            if (folderId < 0) {
                throw OXFolderExceptionCode.NOT_EXISTS.create(folderIdentifier, ctx.getContextId());
            }
            if (0 == folderId) {
                boolean bl = true;
                return bl;
            }
            if (3 == folderId) {
                boolean bl = true;
                return bl;
            }
            if (2 == folderId) {
                boolean bl = true;
                return bl;
            }
            if (9 == folderId) {
                boolean bl = true;
                return bl;
            }
            if (1 == folderId) {
                boolean bl = true;
                return bl;
            }
            if (Arrays.binarySearch(VIRTUAL_IDS, folderId) >= 0) {
                boolean bl = false;
                return bl;
            }
            OXFolderAccess folderAccess = DatabaseFolderStorage.getFolderAccess(ctx, con);
            boolean bl = folderAccess.isEmpty(DatabaseFolderStorage.getFolderObject(folderId, ctx, con), storageParameters.getSession(), ctx);
            return bl;
        }
        finally {
            provider.close();
        }
    }

    @Override
    public void updateLastModified(long lastModified, String treeId, String folderIdentifier, StorageParameters storageParameters) throws OXException {
        ConnectionProvider provider = DatabaseFolderStorage.getConnection(true, storageParameters);
        try {
            Connection con = provider.getConnection();
            Context ctx = storageParameters.getContext();
            int folderId = DatabaseFolderStorageUtility.getUnsignedInteger(folderIdentifier);
            if (DatabaseFolderStorage.getFolderAccess(ctx, con).getFolderLastModified(folderId).after(new Date(lastModified))) {
                throw FolderExceptionErrorMessage.CONCURRENT_MODIFICATION.create();
            }
            OXFolderSQL.updateLastModified(folderId, lastModified, storageParameters.getUserId(), con, ctx);
        }
        catch (SQLException e) {
            throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
        }
        finally {
            provider.close();
        }
    }

    @Override
    public Folder getFolder(String treeId, String folderIdentifier, StorageParameters storageParameters) throws OXException {
        return this.getFolder(treeId, folderIdentifier, StorageType.WORKING, storageParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Folder getFolder(String treeId, String folderIdentifier, StorageType storageType, StorageParameters storageParameters) throws OXException {
        ConnectionProvider provider = DatabaseFolderStorage.getConnection(false, storageParameters);
        try {
            int folderId;
            DatabaseFolder retval;
            Connection con = provider.getConnection();
            User user = storageParameters.getUser();
            Context ctx = storageParameters.getContext();
            Session s = storageParameters.getSession();
            UserConfiguration userConfiguration = s instanceof ServerSession ? ((ServerSession)s).getUserConfiguration() : UserConfigurationStorage.getInstance().getUserConfiguration(user.getId(), ctx);
            if (StorageType.WORKING.equals(storageType)) {
                if (DatabaseFolderStorageUtility.hasSharedPrefix(folderIdentifier)) {
                    retval = SharedPrefixFolder.getSharedPrefixFolder(folderIdentifier, user, ctx);
                } else {
                    folderId = DatabaseFolderStorageUtility.getUnsignedInteger(folderIdentifier);
                    if (folderId < 0) {
                        throw OXFolderExceptionCode.NOT_EXISTS.create(folderIdentifier, ctx.getContextId());
                    }
                    if (0 == folderId) {
                        retval = SystemRootFolder.getSystemRootFolder();
                    } else if (Arrays.binarySearch(VIRTUAL_IDS, folderId) >= 0) {
                        boolean altNames = StorageParametersUtility.getBoolParameter("altNames", storageParameters);
                        retval = VirtualListFolder.getVirtualListFolder(folderId, altNames);
                    } else {
                        FolderObject fo = DatabaseFolderStorage.getFolderObject(folderId, ctx, con);
                        boolean altNames = StorageParametersUtility.getBoolParameter("altNames", storageParameters);
                        retval = DatabaseFolderConverter.convert(fo, user, userConfiguration, ctx, storageParameters.getSession(), altNames, con);
                    }
                }
            } else {
                folderId = DatabaseFolderStorageUtility.getUnsignedInteger(folderIdentifier);
                if (folderId < 0) {
                    throw OXFolderExceptionCode.NOT_EXISTS.create(folderIdentifier, ctx.getContextId());
                }
                FolderObject fo = FolderObject.loadFolderObjectFromDB(folderId, ctx, con, true, false, "del_oxfolder_tree", "del_oxfolder_permissions");
                retval = new DatabaseFolder(fo);
            }
            retval.setTreeID(treeId);
            DatabaseFolder databaseFolder = retval;
            return databaseFolder;
        }
        finally {
            provider.close();
        }
    }

    @Override
    public Folder prepareFolder(String treeId, Folder folder, StorageParameters storageParameters) throws OXException {
        int owner = folder.getCreatedBy();
        if (owner < 0) {
            return folder;
        }
        if (owner != storageParameters.getUserId() && PrivateType.getInstance().equals(folder.getType())) {
            try {
                return this.getFolder(treeId, folder.getID(), StorageType.WORKING, storageParameters);
            }
            catch (OXException e) {
                if (OXFolderExceptionCode.NOT_EXISTS.equals(e) || FolderExceptionErrorMessage.NOT_FOUND.equals(e)) {
                    return this.getFolder(treeId, folder.getID(), StorageType.BACKUP, storageParameters);
                }
                throw e;
            }
        }
        return folder;
    }

    @Override
    public List<Folder> getFolders(String treeId, List<String> folderIdentifiers, StorageParameters storageParameters) throws OXException {
        return this.getFolders(treeId, folderIdentifiers, StorageType.WORKING, storageParameters);
    }

    @Override
    public List<Folder> getFolders(String treeId, List<String> folderIdentifiers, StorageType storageType, StorageParameters storageParameters) throws OXException {
        ConnectionProvider provider = null;
        try {
            User user = storageParameters.getUser();
            Context ctx = storageParameters.getContext();
            Session s = storageParameters.getSession();
            UserConfiguration userConfiguration = s instanceof ServerSession ? ((ServerSession)s).getUserConfiguration() : UserConfigurationStorage.getInstance().getUserConfiguration(user.getId(), ctx);
            boolean altNames = StorageParametersUtility.getBoolParameter("altNames", storageParameters);
            if (StorageType.WORKING.equals(storageType)) {
                int size = folderIdentifiers.size();
                Folder[] ret = new Folder[size];
                TIntIntHashMap map = new TIntIntHashMap(size);
                for (int index = 0; index < size; ++index) {
                    String folderIdentifier = folderIdentifiers.get(index);
                    if (DatabaseFolderStorageUtility.hasSharedPrefix(folderIdentifier)) {
                        ret[index] = SharedPrefixFolder.getSharedPrefixFolder(folderIdentifier, user, ctx);
                        continue;
                    }
                    int folderId = DatabaseFolderStorageUtility.getUnsignedInteger(folderIdentifier);
                    if (0 == folderId) {
                        ret[index] = SystemRootFolder.getSystemRootFolder();
                        continue;
                    }
                    if (Arrays.binarySearch(VIRTUAL_IDS, folderId) >= 0) {
                        ret[index] = VirtualListFolder.getVirtualListFolder(folderId, altNames);
                        continue;
                    }
                    map.put(folderId, index);
                }
                provider = DatabaseFolderStorage.getConnection(false, storageParameters);
                Connection con = provider.getConnection();
                if (!map.isEmpty()) {
                    Session session = storageParameters.getSession();
                    for (FolderObject folderObject : DatabaseFolderStorage.getFolderObjects(map.keys(), ctx, con)) {
                        if (null == folderObject) continue;
                        int index = map.get(folderObject.getObjectID());
                        ret[index] = DatabaseFolderConverter.convert(folderObject, user, userConfiguration, ctx, session, altNames, con);
                    }
                }
                provider.close();
                provider = null;
                for (Folder folder : ret) {
                    if (null == folder) continue;
                    folder.setTreeID(treeId);
                }
                int length = ret.length;
                ArrayList<Folder> l = new ArrayList<Folder>(length);
                for (int i = 0; i < length; ++i) {
                    Folder folder = ret[i];
                    if (null != folder) {
                        l.add(folder);
                        continue;
                    }
                    storageParameters.addWarning(FolderExceptionErrorMessage.NOT_FOUND.create(Integer.valueOf(folderIdentifiers.get(i)), treeId));
                }
                ArrayList<Folder> i = l;
                return i;
            }
            TIntArrayList list = new TIntArrayList(folderIdentifiers.size());
            for (String folderIdentifier : folderIdentifiers) {
                list.add(DatabaseFolderStorageUtility.getUnsignedInteger(folderIdentifier));
            }
            provider = DatabaseFolderStorage.getConnection(false, storageParameters);
            Connection con = provider.getConnection();
            List<FolderObject> folders2 = OXFolderBatchLoader.loadFolderObjectsFromDB(list.toArray(), ctx, con, true, false, "del_oxfolder_tree", "del_oxfolder_permissions");
            provider.close();
            provider = null;
            int size = folders2.size();
            ArrayList<Folder> ret = new ArrayList<Folder>(size);
            for (int i = 0; i < size; ++i) {
                FolderObject fo = folders2.get(i);
                if (null == fo) {
                    storageParameters.addWarning(FolderExceptionErrorMessage.NOT_FOUND.create(list.get(i), treeId));
                    continue;
                }
                DatabaseFolder df = new DatabaseFolder(fo);
                df.setTreeID(treeId);
                ret.add(df);
            }
            ArrayList<Folder> arrayList = ret;
            return arrayList;
        }
        catch (OXException e) {
            throw e;
        }
        finally {
            if (null != provider) {
                provider.close();
            }
        }
    }

    @Override
    public FolderType getFolderType() {
        return DatabaseFolderType.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public SortableId[] getVisibleFolders(String treeId, ContentType contentType, Type type, StorageParameters storageParameters) throws OXException {
        provider = DatabaseFolderStorage.getConnection(false, storageParameters);
        try {
            con = provider.getConnection();
            user = storageParameters.getUser();
            userId = user.getId();
            ctx = storageParameters.getContext();
            s = storageParameters.getSession();
            userConfiguration = s instanceof ServerSession != false ? ((ServerSession)s).getUserConfiguration() : UserConfigurationStorage.getInstance().getUserConfiguration(userId, ctx);
            iType = DatabaseFolderStorage.getTypeByFolderTypeWithShared(type);
            iModule = DatabaseFolderStorage.getModuleByContentType(contentType);
            list = ((FolderObjectIterator)OXFolderIteratorSQL.getAllVisibleFoldersIteratorOfType(userId, user.getGroups(), userConfiguration.getAccessibleModules(), iType, new int[]{iModule}, ctx, con)).asList();
            if (1 == iType) {
                iterator = list.iterator();
                while (iterator.hasNext()) {
                    if (iterator.next().getCreatedBy() == userId) continue;
                    iterator.remove();
                }
            } else if (2 == iType && 3 == iModule) {
                try {
                    gab = DatabaseFolderStorage.getFolderObject(6, ctx, con);
                    if (!gab.isVisible(userId, userConfiguration)) ** GOTO lbl29
                    gab.setFolderName(StringHelper.valueOf(user.getLocale()).getString("Global address book"));
                    list.add(gab);
                }
                catch (RuntimeException e) {
                    throw OXFolderExceptionCode.RUNTIME_ERROR.create(e, new Object[]{ctx.getContextId()});
                }
            }
lbl29:
            // 5 sources

            stringHelper = null;
            for (FolderObject folderObject : list) {
                if (!folderObject.isDefaultFolder()) continue;
                module = folderObject.getModule();
                if (2 == module) {
                    if (null == stringHelper) {
                        stringHelper = StringHelper.valueOf(user.getLocale());
                    }
                    folderObject.setFolderName(stringHelper.getString("Calendar"));
                    continue;
                }
                if (3 == module) {
                    if (null == stringHelper) {
                        stringHelper = StringHelper.valueOf(user.getLocale());
                    }
                    folderObject.setFolderName(stringHelper.getString("Contacts"));
                    continue;
                }
                if (1 != module) continue;
                if (null == stringHelper) {
                    stringHelper = StringHelper.valueOf(user.getLocale());
                }
                folderObject.setFolderName(stringHelper.getString("Tasks"));
            }
            if (1 == iType) {
                Collections.sort(list, new FolderObjectComparator(user.getLocale(), ctx));
            } else {
                Collections.sort(list, new FolderNameComparator(user.getLocale(), storageParameters.getContext()));
            }
            ret = new SortableId[list.size()];
            for (i = 0; i < ret.length; ++i) {
                folderObject = list.get(i);
                id = String.valueOf(folderObject.getObjectID());
                ret[i] = new DatabaseId(id, i, folderObject.getFolderName());
            }
            var15_19 = ret;
            return var15_19;
        }
        finally {
            provider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortableId[] getSubfolders(String treeId, String parentIdentifier, StorageParameters storageParameters) throws OXException {
        Session session;
        FileStorageAccount defaultAccount;
        int parentId;
        Connection con;
        block37: {
            ConnectionProvider provider = DatabaseFolderStorage.getConnection(false, storageParameters);
            try {
                con = provider.getConnection();
                if (DatabaseFolderStorageUtility.hasSharedPrefix(parentIdentifier)) {
                    User user = storageParameters.getUser();
                    Context ctx = storageParameters.getContext();
                    Session s = storageParameters.getSession();
                    UserConfiguration userConfiguration = s instanceof ServerSession ? ((ServerSession)s).getUserConfiguration() : UserConfigurationStorage.getInstance().getUserConfiguration(user.getId(), ctx);
                    List<FolderIdNamePair> subfolderIds = SharedPrefixFolder.getSharedPrefixFolderSubfolders(parentIdentifier, user, userConfiguration, ctx, con);
                    ArrayList<DatabaseId> list = new ArrayList<DatabaseId>(subfolderIds.size());
                    int i = 0;
                    for (FolderIdNamePair props : subfolderIds) {
                        list.add(new DatabaseId(props.fuid, i++, props.name));
                    }
                    SortableId[] i$ = list.toArray(new SortableId[list.size()]);
                    return i$;
                }
                parentId = Integer.parseInt(parentIdentifier);
                if (0 == parentId) {
                    List<String[]> subfolderIds = SystemRootFolder.getSystemRootFolderSubfolder(storageParameters.getUser().getLocale());
                    ArrayList<DatabaseId> list = new ArrayList<DatabaseId>(subfolderIds.size());
                    int i = 0;
                    for (String[] sa : subfolderIds) {
                        list.add(new DatabaseId(sa[0], i++, sa[1]));
                    }
                    SortableId[] i$ = list.toArray(new SortableId[list.size()]);
                    return i$;
                }
                if (Arrays.binarySearch(VIRTUAL_IDS, parentId) >= 0) {
                    User user = storageParameters.getUser();
                    Context ctx = storageParameters.getContext();
                    Session s = storageParameters.getSession();
                    UserConfiguration userConfiguration = s instanceof ServerSession ? ((ServerSession)s).getUserConfiguration() : UserConfigurationStorage.getInstance().getUserConfiguration(user.getId(), ctx);
                    List<String[]> subfolderIds = VirtualListFolder.getVirtualListFolderSubfolders(parentId, user, userConfiguration, ctx, con);
                    int size = subfolderIds.size();
                    ArrayList<DatabaseId> list = new ArrayList<DatabaseId>(size);
                    for (int i = 0; i < size; ++i) {
                        String[] sa = subfolderIds.get(i);
                        list.add(new DatabaseId(sa[0], i, sa[1]));
                    }
                    SortableId[] i = list.toArray(new SortableId[list.size()]);
                    return i;
                }
                if (1 == parentId) {
                    User user = storageParameters.getUser();
                    Context ctx = storageParameters.getContext();
                    Session s = storageParameters.getSession();
                    UserConfiguration userConfiguration = s instanceof ServerSession ? ((ServerSession)s).getUserConfiguration() : UserConfigurationStorage.getInstance().getUserConfiguration(user.getId(), ctx);
                    List<String[]> subfolderIds = SystemPrivateFolder.getSystemPrivateFolderSubfolders(user, userConfiguration, ctx, con);
                    int size = subfolderIds.size();
                    ArrayList<DatabaseId> list = new ArrayList<DatabaseId>(size);
                    for (int i = 0; i < size; ++i) {
                        String[] sa = subfolderIds.get(i);
                        list.add(new DatabaseId(sa[0], i, sa[1]));
                    }
                    SortableId[] i = list.toArray(new SortableId[list.size()]);
                    return i;
                }
                if (3 == parentId) {
                    User user = storageParameters.getUser();
                    Context ctx = storageParameters.getContext();
                    Session s = storageParameters.getSession();
                    UserConfiguration userConfiguration = s instanceof ServerSession ? ((ServerSession)s).getUserConfiguration() : UserConfigurationStorage.getInstance().getUserConfiguration(user.getId(), ctx);
                    List<String[]> subfolderIds = SystemSharedFolder.getSystemSharedFolderSubfolder(user, userConfiguration, ctx, con);
                    int size = subfolderIds.size();
                    ArrayList<DatabaseId> list = new ArrayList<DatabaseId>(size);
                    for (int i = 0; i < size; ++i) {
                        String[] sa = subfolderIds.get(i);
                        list.add(new DatabaseId(sa[0], i, sa[1]));
                    }
                    SortableId[] i = list.toArray(new SortableId[list.size()]);
                    return i;
                }
                if (2 == parentId) {
                    User user = storageParameters.getUser();
                    Context ctx = storageParameters.getContext();
                    Session s = storageParameters.getSession();
                    UserConfiguration userConfiguration = s instanceof ServerSession ? ((ServerSession)s).getUserConfiguration() : UserConfigurationStorage.getInstance().getUserConfiguration(user.getId(), ctx);
                    List<String[]> subfolderIds = SystemPublicFolder.getSystemPublicFolderSubfolders(user, userConfiguration, ctx, con);
                    int size = subfolderIds.size();
                    ArrayList<DatabaseId> list = new ArrayList<DatabaseId>(size);
                    for (int i = 0; i < size; ++i) {
                        String[] sa = subfolderIds.get(i);
                        list.add(new DatabaseId(sa[0], i, sa[1]));
                    }
                    SortableId[] i = list.toArray(new SortableId[list.size()]);
                    return i;
                }
                if (9 == parentId) {
                    User user = storageParameters.getUser();
                    Context ctx = storageParameters.getContext();
                    Session s = storageParameters.getSession();
                    UserConfiguration userConfiguration = s instanceof ServerSession ? ((ServerSession)s).getUserConfiguration() : UserConfigurationStorage.getInstance().getUserConfiguration(user.getId(), ctx);
                    boolean altNames = StorageParametersUtility.getBoolParameter("altNames", storageParameters);
                    List<String[]> subfolderIds = SystemInfostoreFolder.getSystemInfostoreFolderSubfolders(user, userConfiguration, ctx, altNames, con);
                    int size = subfolderIds.size();
                    ArrayList<DatabaseId> list = new ArrayList<DatabaseId>(size);
                    for (int i = 0; i < size; ++i) {
                        String[] sa = subfolderIds.get(i);
                        list.add(new DatabaseId(sa[0], i, sa[1]));
                    }
                    SortableId[] i = list.toArray(new SortableId[list.size()]);
                    return i;
                }
                if (10 != parentId || InfostoreFacades.isInfoStoreAvailable() || null == (defaultAccount = DatabaseFolderConverter.getDefaultFileStorageAccess(session = storageParameters.getSession()))) break block37;
                FileStorageService fileStorageService = defaultAccount.getFileStorageService();
                String defaultId = "0";
                FileStorageAccountAccess defaultFileStorageAccess = fileStorageService.getAccountAccess("0", session);
                defaultFileStorageAccess.connect();
                try {
                    FileStorageFolder personalFolder = defaultFileStorageAccess.getFolderAccess().getPersonalFolder();
                    FileStorageFolderIdentifier fsfi = new FileStorageFolderIdentifier(fileStorageService.getId(), defaultAccount.getId(), personalFolder.getId());
                    SortableId[] i = new SortableId[]{new DatabaseId(fsfi.toString(), 0, personalFolder.getName())};
                    return i;
                }
                finally {
                    defaultFileStorageAccess.close();
                }
            }
            catch (SQLException e) {
                throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
            }
            finally {
                provider.close();
            }
        }
        if (15 == parentId && !InfostoreFacades.isInfoStoreAvailable() && null != (defaultAccount = DatabaseFolderConverter.getDefaultFileStorageAccess(session = storageParameters.getSession()))) {
            FileStorageService fileStorageService = defaultAccount.getFileStorageService();
            String defaultId = "0";
            FileStorageAccountAccess defaultFileStorageAccess = fileStorageService.getAccountAccess("0", session);
            defaultFileStorageAccess.connect();
            try {
                FileStorageFolder[] publicFolders = defaultFileStorageAccess.getFolderAccess().getPublicFolders();
                SortableId[] ret = new SortableId[publicFolders.length];
                String serviceId = fileStorageService.getId();
                String accountId = defaultAccount.getId();
                for (int i = 0; i < publicFolders.length; ++i) {
                    FileStorageFolder folder = publicFolders[i];
                    FileStorageFolderIdentifier fsfi = new FileStorageFolderIdentifier(serviceId, accountId, folder.getId());
                    ret[i] = new DatabaseId(fsfi.toString(), i, folder.getName());
                }
                SortableId[] sortableIdArray = ret;
                return sortableIdArray;
            }
            finally {
                defaultFileStorageAccess.close();
            }
        }
        boolean doDBSorting = true;
        List<OXFolderLoader.IdAndName> idAndNames = OXFolderLoader.getSubfolderIdAndNames(parentId, storageParameters.getContext(), con);
        int size = idAndNames.size();
        ArrayList<DatabaseId> list = new ArrayList<DatabaseId>(size);
        for (int i = 0; i < size; ++i) {
            OXFolderLoader.IdAndName idAndName = idAndNames.get(i);
            list.add(new DatabaseId(idAndName.getFolderId(), i, idAndName.getName()));
        }
        SortableId[] sortableIdArray = list.toArray(new SortableId[size]);
        return sortableIdArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(StorageParameters params) {
        ConnectionMode con;
        try {
            con = DatabaseFolderStorage.optParameter(ConnectionMode.class, PARAM_CONNECTION, params);
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return;
        }
        if (null == con) {
            return;
        }
        if (con.readWrite) {
            try {
                DBUtils.rollback(con.connection);
            }
            finally {
                DBUtils.autocommit(con.connection);
                DatabaseService databaseService = (DatabaseService)DatabaseServiceRegistry.getServiceRegistry().getService(DatabaseService.class);
                if (null != databaseService) {
                    databaseService.backWritable(params.getContext(), con.connection);
                }
                params.putParameter(this.getFolderType(), PARAM_CONNECTION, null);
            }
        } else {
            DatabaseService databaseService = (DatabaseService)DatabaseServiceRegistry.getServiceRegistry().getService(DatabaseService.class);
            if (null != databaseService) {
                databaseService.backReadOnly(params.getContext(), con.connection);
            }
        }
    }

    @Override
    public boolean startTransaction(StorageParameters parameters, boolean modify) throws OXException {
        FolderType folderType = this.getFolderType();
        try {
            DatabaseService databaseService = (DatabaseService)DatabaseServiceRegistry.getServiceRegistry().getService(DatabaseService.class, true);
            Context context = parameters.getContext();
            ConnectionMode con = (ConnectionMode)parameters.getParameter(folderType, PARAM_CONNECTION);
            if (null != con) {
                if (con.readWrite || modify == con.readWrite) {
                    return false;
                }
                parameters.putParameter(folderType, PARAM_CONNECTION, null);
                if (con.readWrite) {
                    try {
                        con.connection.commit();
                    }
                    catch (Exception e) {
                        DBUtils.rollback(con.connection);
                    }
                    DBUtils.autocommit(con.connection);
                    databaseService.backWritable(context, con.connection);
                } else {
                    databaseService.backReadOnly(context, con.connection);
                }
            }
            if (modify) {
                con = new ConnectionMode(databaseService.getWritable(context), true);
                con.connection.setAutoCommit(false);
            } else {
                con = new ConnectionMode(databaseService.getReadOnly(context), false);
            }
            if (!parameters.putParameterIfAbsent(folderType, PARAM_CONNECTION, con)) {
                if (modify) {
                    con.connection.setAutoCommit(true);
                    databaseService.backWritable(context, con.connection);
                } else {
                    databaseService.backReadOnly(context, con.connection);
                }
            }
            return true;
        }
        catch (SQLException e) {
            throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateFolder(Folder folder, StorageParameters storageParameters) throws OXException {
        ConnectionProvider provider = DatabaseFolderStorage.getConnection(true, storageParameters);
        try {
            Permission[] perms;
            String parentId;
            Connection con = provider.getConnection();
            Session session = storageParameters.getSession();
            if (null == session) {
                throw FolderExceptionErrorMessage.MISSING_SESSION.create(new Object[0]);
            }
            String id = folder.getID();
            Context context = storageParameters.getContext();
            if (DatabaseFolderStorageUtility.hasSharedPrefix(id)) {
                int owner = Integer.parseInt(id.substring("u:".length()));
                throw OXFolderExceptionCode.NO_ADMIN_ACCESS.create(OXFolderUtility.getUserName(session.getUserId(), context), UserStorage.getStorageUser(owner, context).getDisplayName(), context.getContextId());
            }
            int folderId = Integer.parseInt(id);
            Date clientLastModified = storageParameters.getTimeStamp();
            if (null != clientLastModified && DatabaseFolderStorage.getFolderAccess(context, con).getFolderLastModified(folderId).after(clientLastModified)) {
                throw FolderExceptionErrorMessage.CONCURRENT_MODIFICATION.create();
            }
            Date millis = new Date();
            FolderObject updateMe = new FolderObject();
            updateMe.setObjectID(folderId);
            updateMe.setDefaultFolder(false);
            String name = folder.getName();
            if (null != name) {
                updateMe.setFolderName(name);
            }
            updateMe.setLastModified(millis);
            folder.setLastModified(millis);
            updateMe.setModifiedBy(session.getUserId());
            ContentType ct = folder.getContentType();
            if (null != ct) {
                updateMe.setModule(DatabaseFolderStorage.getModuleByContentType(ct));
            }
            if (null == (parentId = folder.getParentID())) {
                updateMe.setParentFolderID(DatabaseFolderStorage.getFolderObject(folderId, context, con).getParentFolderID());
            } else if (DatabaseFolderStorageUtility.hasSharedPrefix(parentId)) {
                updateMe.setParentFolderID(DatabaseFolderStorage.getFolderObject(folderId, context, con).getParentFolderID());
            } else {
                updateMe.setParentFolderID(Integer.parseInt(parentId));
            }
            Type t = folder.getType();
            if (null != t) {
                updateMe.setType(DatabaseFolderStorage.getTypeByFolderType(t));
            }
            if (null != (perms = folder.getPermissions())) {
                OCLPermission[] oclPermissions = new OCLPermission[perms.length];
                for (int i = 0; i < perms.length; ++i) {
                    Permission p = perms[i];
                    OCLPermission oclPerm = new OCLPermission();
                    oclPerm.setEntity(p.getEntity());
                    oclPerm.setGroupPermission(p.isGroup());
                    oclPerm.setFolderAdmin(p.isAdmin());
                    oclPerm.setAllPermission(p.getFolderPermission(), p.getReadPermission(), p.getWritePermission(), p.getDeletePermission());
                    oclPerm.setSystem(p.getSystem());
                    oclPermissions[i] = oclPerm;
                }
                updateMe.setPermissionsAsArray(oclPermissions);
            }
            OXFolderManager folderManager = OXFolderManager.getInstance(session, con, con);
            folderManager.updateFolder(updateMe, true, StorageParametersUtility.isHandDownPermissions(storageParameters), millis.getTime());
        }
        finally {
            provider.close();
        }
    }

    @Override
    public StoragePriority getStoragePriority() {
        return StoragePriority.NORMAL;
    }

    @Override
    public boolean containsFolder(String treeId, String folderIdentifier, StorageParameters storageParameters) throws OXException {
        return this.containsFolder(treeId, folderIdentifier, StorageType.WORKING, storageParameters);
    }

    @Override
    public boolean containsFolder(String treeId, String folderIdentifier, StorageType storageType, StorageParameters storageParameters) throws OXException {
        ConnectionProvider provider = DatabaseFolderStorage.getConnection(false, storageParameters);
        try {
            int folderId;
            Connection con = provider.getConnection();
            User user = storageParameters.getUser();
            Context ctx = storageParameters.getContext();
            Session s = storageParameters.getSession();
            UserConfiguration userConfiguration = s instanceof ServerSession ? ((ServerSession)s).getUserConfiguration() : UserConfigurationStorage.getInstance().getUserConfiguration(user.getId(), ctx);
            boolean retval = StorageType.WORKING.equals(storageType) ? (DatabaseFolderStorageUtility.hasSharedPrefix(folderIdentifier) ? SharedPrefixFolder.existsSharedPrefixFolder(folderIdentifier, user, userConfiguration, ctx, con) : ((folderId = DatabaseFolderStorageUtility.getUnsignedInteger(folderIdentifier)) < 0 ? false : (0 == folderId ? true : (Arrays.binarySearch(VIRTUAL_IDS, folderId) >= 0 ? VirtualListFolder.existsVirtualListFolder(folderId, user, userConfiguration, ctx, con) : (3 == folderId ? true : (2 == folderId ? true : (9 == folderId ? true : (1 == folderId ? true : OXFolderSQL.exists(folderId, con, ctx))))))))) : ((folderId = DatabaseFolderStorageUtility.getUnsignedInteger(folderIdentifier)) < 0 ? false : OXFolderSQL.exists(folderId, con, ctx, "del_oxfolder_tree"));
            boolean bl = retval;
            return bl;
        }
        catch (SQLException e) {
            throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
        }
        finally {
            provider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getModifiedFolderIDs(String treeId, Date timeStamp, ContentType[] includeContentTypes, StorageParameters storageParameters) throws OXException {
        ConnectionProvider provider = DatabaseFolderStorage.getConnection(false, storageParameters);
        try {
            Connection con = provider.getConnection();
            Context ctx = storageParameters.getContext();
            Queue<FolderObject> q = ((FolderObjectIterator)OXFolderIteratorSQL.getAllModifiedFoldersSince(timeStamp == null ? new Date(0L) : timeStamp, ctx, con)).asQueue();
            int size = q.size();
            Iterator iterator = q.iterator();
            String[] ret = new String[size];
            for (int i = 0; i < size; ++i) {
                ret[i] = String.valueOf(((FolderObject)iterator.next()).getObjectID());
            }
            String[] stringArray = ret;
            return stringArray;
        }
        finally {
            provider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getDeletedFolderIDs(String treeId, Date timeStamp, StorageParameters storageParameters) throws OXException {
        ConnectionProvider provider = DatabaseFolderStorage.getConnection(false, storageParameters);
        try {
            Connection con = provider.getConnection();
            User user = storageParameters.getUser();
            Context ctx = storageParameters.getContext();
            Session s = storageParameters.getSession();
            UserConfiguration userConfiguration = s instanceof ServerSession ? ((ServerSession)s).getUserConfiguration() : UserConfigurationStorage.getInstance().getUserConfiguration(user.getId(), ctx);
            Queue<FolderObject> q = ((FolderObjectIterator)OXFolderIteratorSQL.getDeletedFoldersSince(timeStamp, user.getId(), user.getGroups(), userConfiguration.getAccessibleModules(), ctx, con)).asQueue();
            int size = q.size();
            Iterator iterator = q.iterator();
            String[] ret = new String[size];
            for (int i = 0; i < size; ++i) {
                ret[i] = String.valueOf(((FolderObject)iterator.next()).getObjectID());
            }
            String[] stringArray = ret;
            return stringArray;
        }
        finally {
            provider.close();
        }
    }

    private static FolderObject getFolderObject(int folderId, Context ctx, Connection con) throws OXException {
        if (!FolderCacheManager.isEnabled()) {
            return FolderObject.loadFolderObjectFromDB(folderId, ctx, con, true, true);
        }
        FolderCacheManager cacheManager = FolderCacheManager.getInstance();
        FolderObject fo = cacheManager.getFolderObject(folderId, ctx);
        if (null == fo) {
            fo = FolderObject.loadFolderObjectFromDB(folderId, ctx, con, true, true);
            cacheManager.putFolderObject(fo, ctx, false, null);
        }
        return fo;
    }

    private static List<FolderObject> getFolderObjects(int[] folderIds, Context ctx, Connection con) throws OXException {
        if (!FolderCacheManager.isEnabled()) {
            return OXFolderBatchLoader.loadFolderObjectsFromDB(folderIds, ctx, con, true, true);
        }
        int length = folderIds.length;
        FolderObject[] ret = new FolderObject[length];
        TIntIntHashMap toLoad = new TIntIntHashMap(length);
        FolderCacheManager cacheManager = FolderCacheManager.getInstance();
        for (int index = 0; index < length; ++index) {
            int folderId = folderIds[index];
            FolderObject fo = cacheManager.getFolderObject(folderId, ctx);
            if (null == fo) {
                toLoad.put(folderId, index);
                continue;
            }
            ret[index] = fo;
        }
        if (!toLoad.isEmpty()) {
            List<FolderObject> list = OXFolderBatchLoader.loadFolderObjectsFromDB(toLoad.keys(), ctx, con, true, true);
            for (FolderObject folderObject : list) {
                if (null == folderObject) continue;
                int index = toLoad.get(folderObject.getObjectID());
                ret[index] = folderObject;
                cacheManager.putFolderObject(folderObject, ctx, false, null);
            }
        }
        return Arrays.asList(ret);
    }

    private static OXFolderAccess getFolderAccess(Context ctx, Connection con) {
        return new OXFolderAccess(con, ctx);
    }

    private static ConnectionProvider getConnection(boolean modify, StorageParameters storageParameters) throws OXException {
        ConnectionMode connection = DatabaseFolderStorage.optParameter(ConnectionMode.class, PARAM_CONNECTION, storageParameters);
        if (null != connection) {
            return new NonClosingConnectionProvider(connection);
        }
        Context context = storageParameters.getContext();
        DatabaseService databaseService = (DatabaseService)DatabaseServiceRegistry.getServiceRegistry().getService(DatabaseService.class, true);
        connection = modify ? new ConnectionMode(databaseService.getWritable(context), true) : new ConnectionMode(databaseService.getReadOnly(context), false);
        return new ClosingConnectionProvider(connection, databaseService, context.getContextId());
    }

    private static <T> T getParameter(Class<T> clazz, String name, StorageParameters parameters) throws OXException {
        T parameter = DatabaseFolderStorage.optParameter(clazz, name, parameters);
        if (null == parameter) {
            throw OXFolderExceptionCode.MISSING_PARAMETER.create(name);
        }
        return parameter;
    }

    private static <T> T optParameter(Class<T> clazz, String name, StorageParameters parameters) throws OXException {
        Object obj = parameters.getParameter(DatabaseFolderType.getInstance(), name);
        if (null == obj) {
            return null;
        }
        try {
            return clazz.cast(obj);
        }
        catch (ClassCastException e) {
            throw OXFolderExceptionCode.MISSING_PARAMETER.create(e, name);
        }
    }

    private static int getModuleByContentType(ContentType contentType) {
        String cts = ((Object)contentType).toString();
        if (TaskContentType.getInstance().toString().equals(cts)) {
            return 1;
        }
        if (CalendarContentType.getInstance().toString().equals(cts)) {
            return 2;
        }
        if (ContactContentType.getInstance().toString().equals(cts)) {
            return 3;
        }
        if (InfostoreContentType.getInstance().toString().equals(cts)) {
            return 8;
        }
        return 4;
    }

    private static int getTypeByFolderType(Type type) {
        if (PrivateType.getInstance().equals(type)) {
            return 1;
        }
        if (PublicType.getInstance().equals(type)) {
            return 2;
        }
        return 5;
    }

    private static int getTypeByFolderTypeWithShared(Type type) {
        if (PrivateType.getInstance().equals(type)) {
            return 1;
        }
        if (PublicType.getInstance().equals(type)) {
            return 2;
        }
        if (SharedType.getInstance().equals(type)) {
            return 3;
        }
        return 5;
    }

    public static final class ConnectionMode {
        public final Connection connection;
        public final boolean readWrite;

        public ConnectionMode(Connection connection, boolean readWrite) {
            this.connection = connection;
            this.readWrite = readWrite;
        }
    }

    private static final class FolderNameComparator
    implements Comparator<FolderObject> {
        private final Collator collator;
        private final Context context;

        public FolderNameComparator(Locale locale, Context context) {
            this.collator = Collator.getInstance(locale);
            this.collator.setStrength(1);
            this.context = context;
        }

        @Override
        public int compare(FolderObject o1, FolderObject o2) {
            String folderName2;
            String folderName1 = o1.getFolderName();
            if (folderName1.equals(folderName2 = o2.getFolderName())) {
                int owner1 = o1.getCreatedBy();
                int owner2 = o2.getCreatedBy();
                if (owner1 > 0 && owner2 > 0) {
                    return this.collator.compare(UserStorage.getStorageUser(owner1, this.context).getDisplayName(), UserStorage.getStorageUser(owner2, this.context).getDisplayName());
                }
            }
            return this.collator.compare(folderName1, folderName2);
        }
    }

    private static final class FolderObjectComparator
    implements Comparator<FolderObject> {
        private final Collator collator;
        private final Context context;

        public FolderObjectComparator(Locale locale, Context context) {
            this.collator = Collator.getInstance(locale);
            this.collator.setStrength(1);
            this.context = context;
        }

        @Override
        public int compare(FolderObject o1, FolderObject o2) {
            if (o1.isDefaultFolder()) {
                if (o2.isDefaultFolder()) {
                    if (o1.getFolderName().equals(o2.getFolderName())) {
                        int owner1 = o1.getCreatedBy();
                        int owner2 = o2.getCreatedBy();
                        if (owner1 > 0 && owner2 > 0) {
                            return this.collator.compare(UserStorage.getStorageUser(owner1, this.context).getDisplayName(), UserStorage.getStorageUser(owner2, this.context).getDisplayName());
                        }
                    }
                    return FolderObjectComparator.compareById(o1.getObjectID(), o2.getObjectID());
                }
                return -1;
            }
            if (o2.isDefaultFolder()) {
                return 1;
            }
            return this.collator.compare(o1.getFolderName(), o2.getFolderName());
        }

        private static int compareById(int id1, int id2) {
            return id1 < id2 ? -1 : (id1 == id2 ? 0 : 1);
        }
    }

    private static final class ClosingConnectionProvider
    implements ConnectionProvider {
        private final DatabaseService databaseService;
        private final ConnectionMode connection;
        private final int contextId;

        protected ClosingConnectionProvider(ConnectionMode connection, DatabaseService databaseService, int contextId) {
            this.connection = connection;
            this.databaseService = databaseService;
            this.contextId = contextId;
        }

        @Override
        public Connection getConnection() {
            return this.connection.connection;
        }

        @Override
        public void close() {
            if (this.connection.readWrite) {
                this.databaseService.backWritable(this.contextId, this.connection.connection);
            } else {
                this.databaseService.backReadOnly(this.contextId, this.connection.connection);
            }
        }
    }

    private static final class NonClosingConnectionProvider
    implements ConnectionProvider {
        private final ConnectionMode connection;

        protected NonClosingConnectionProvider(ConnectionMode connection) {
            this.connection = connection;
        }

        @Override
        public Connection getConnection() {
            return this.connection.connection;
        }

        @Override
        public void close() {
        }
    }

    private static interface ConnectionProvider {
        public Connection getConnection();

        public void close();
    }
}

