/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage;

import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionFactory;

public enum FolderExceptionErrorMessage implements OXExceptionCode
{
    UNEXPECTED_ERROR("Unexpected error: %1$s", Category.CATEGORY_ERROR, 1001),
    IO_ERROR("I/O error: %1$s", Category.CATEGORY_ERROR, 1002),
    FOLDER_NOT_VISIBLE("Folder \"%1$s\" is not visible to user \"%2$s\" in context \"%3$s\"", Category.CATEGORY_PERMISSION_DENIED, 3),
    NO_STORAGE_FOR_ID("No appropriate folder storage for tree identifier \"%1$s\" and folder identifier \"%2$s\".", Category.CATEGORY_ERROR, 1004),
    NO_STORAGE_FOR_CT("No appropriate folder storage for tree identifier \"%1$s\" and content type \"%2$s\".", Category.CATEGORY_ERROR, 1005),
    MISSING_SESSION("Missing session.", Category.CATEGORY_ERROR, 1006),
    SQL_ERROR("SQL error: %1$s", Category.CATEGORY_ERROR, 1007),
    NOT_FOUND("Folder \"%1$s\" could not be found in tree \"%2$s\".", Category.CATEGORY_ERROR, 8),
    MISSING_TREE_ID("Missing tree identifier.", Category.CATEGORY_ERROR, 1009),
    MISSING_PARENT_ID("Missing parent folder identifier.", Category.CATEGORY_ERROR, 1010),
    MISSING_FOLDER_ID("Missing folder identifier.", Category.CATEGORY_ERROR, 1011),
    INVALID_CONTENT_TYPE("Parent folder \"%1$s\" does not allow folder content type \"%2$s\" in tree \"%3$s\" for user %4$s in context %5$s.", Category.CATEGORY_ERROR, 1012),
    MOVE_NOT_PERMITTED("Move operation not permitted.", Category.CATEGORY_ERROR, 1013),
    EQUAL_NAME("A folder named \"%1$s\" already exists below parent folder \"%2$s\" in tree \"%3$s\".", Category.CATEGORY_PERMISSION_DENIED, 1014),
    NO_REAL_SUBSCRIBE("Subscribe operation not permitted on tree \"%1$s\".", Category.CATEGORY_PERMISSION_DENIED, 1015),
    NO_REAL_UNSUBSCRIBE("Unsubscribe operation not permitted on tree \"%1$s\".", Category.CATEGORY_PERMISSION_DENIED, 1016),
    NO_UNSUBSCRIBE("Unsubscribe operation not permitted on folder \"%1$s\" in tree \"%2$s\". Unsubscribe subfolders first.", Category.CATEGORY_PERMISSION_DENIED, 1017),
    UNKNOWN_CONTENT_TYPE("Unknown content type: %1$s.", Category.CATEGORY_ERROR, 1018),
    MISSING_PARAMETER("Missing parameter: %1$s.", Category.CATEGORY_ERROR, 1019),
    UNSUPPORTED_STORAGE_TYPE("Unsupported storage type: %1$s.", Category.CATEGORY_ERROR, 1020),
    MISSING_PROPERTY("Missing property: %1$s.", Category.CATEGORY_ERROR, 1021),
    CONCURRENT_MODIFICATION("The object has been changed in the meantime.", Category.CATEGORY_CONFLICT, 1022),
    JSON_ERROR("JSON error: %1$s", Category.CATEGORY_ERROR, 1023),
    NO_DEFAULT_FOLDER("No default folder available for content type \"%1$s\" in tree \"%2$s\".", Category.CATEGORY_ERROR, 1024),
    INVALID_FOLDER_ID("Invalid folder identifier: %1$s.", Category.CATEGORY_ERROR, 1025),
    FOLDER_NOT_DELETEABLE("Folder \"%1$s\" must not be deleted by user \"%2$s\" in context \"%3$s\".", Category.CATEGORY_PERMISSION_DENIED, 1026),
    FOLDER_NOT_MOVEABLE("Folder \"%1$s\" must not be moved by user \"%2$s\" in context \"%3$s\".", Category.CATEGORY_PERMISSION_DENIED, 1027),
    TEMPORARY_ERROR("A temporary error occurred. Please retry.", Category.CATEGORY_ERROR, 1028),
    NO_CREATE_SUBFOLDERS("User \"%2$s\" must not create subfolders below folder \"%2$s\" in context \"%3$s\".", Category.CATEGORY_PERMISSION_DENIED, 1029),
    NO_PUBLIC_MAIL_FOLDER("No mail folder allowed below a public folder.", Category.CATEGORY_PERMISSION_DENIED, 1030),
    TREE_NOT_FOUND("No such tree with identifier \"%1$s\".", Category.CATEGORY_PERMISSION_DENIED, 1031),
    DUPLICATE_TREE("A tree with identifier \"%1$s\" already exists.", Category.CATEGORY_ERROR, 1032),
    RESERVED_NAME("The folder name \"%1$s\" is reserved. Please choose another name.", Category.CATEGORY_PERMISSION_DENIED, 1033),
    DUPLICATE_NAME("Found two folders named \"%1$s\" located below the parent folder \"%2$s\". Please rename one of the folders. There should be no two folders with the same name.", Category.CATEGORY_PERMISSION_DENIED, 1034),
    TRY_AGAIN("An unexpected error occurred: %1$s. Please try again.", Category.CATEGORY_TRY_AGAIN, 1035);

    private static final String PREFIX = "FLD";
    private final Category category;
    private final int detailNumber;
    private final String message;

    public static String prefix() {
        return PREFIX;
    }

    private FolderExceptionErrorMessage(String message, Category category, int detailNumber) {
        this.message = message;
        this.detailNumber = detailNumber;
        this.category = category;
    }

    public String getPrefix() {
        return PREFIX;
    }

    public Category getCategory() {
        return this.category;
    }

    public int getNumber() {
        return this.detailNumber;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean equals(OXException e) {
        return OXExceptionFactory.getInstance().equals((OXExceptionCode)this, e);
    }

    public OXException create() {
        return this.specials(OXExceptionFactory.getInstance().create((OXExceptionCode)this, new Object[0]));
    }

    public OXException create(Object ... args) {
        return this.specials(OXExceptionFactory.getInstance().create((OXExceptionCode)this, (Throwable)null, args));
    }

    public OXException create(Throwable cause, Object ... args) {
        return this.specials(OXExceptionFactory.getInstance().create((OXExceptionCode)this, cause, args));
    }

    private OXException specials(OXException exc) {
        switch (this) {
            case NOT_FOUND: {
                exc.setGeneric(OXException.Generic.NOT_FOUND);
            }
        }
        if (exc.getCategories().contains(Category.CATEGORY_CONFLICT)) {
            exc.setGeneric(OXException.Generic.CONFLICT);
        }
        if (exc.getCategories().contains(Category.CATEGORY_PERMISSION_DENIED)) {
            exc.setGeneric(OXException.Generic.NO_PERMISSION);
        }
        return exc;
    }
}

