/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.filemanagement.internal;

import com.openexchange.exception.OXException;
import com.openexchange.filemanagement.ManagedFileExceptionErrorMessage;
import com.openexchange.filemanagement.ManagedFileManagement;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.stream.UnsynchronizedByteArrayInputStream;
import com.openexchange.tools.stream.UnsynchronizedByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public final class ManagedInputStream
extends InputStream {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(ManagedInputStream.class));
    private static final int SIZE_LIMIT = 0x100000;
    private final InputStream delegate;

    public ManagedInputStream(byte[] bytes, ManagedFileManagement management) throws OXException {
        this(bytes, 0x100000, management);
    }

    public ManagedInputStream(byte[] bytes, int capacity, ManagedFileManagement management) throws OXException {
        this.delegate = bytes.length <= capacity ? new UnsynchronizedByteArrayInputStream(bytes) : management.createManagedFile(bytes).getInputStream();
    }

    public ManagedInputStream(InputStream in, ManagedFileManagement management) throws OXException {
        this(in, -1, 0x100000, management);
    }

    public ManagedInputStream(InputStream in, int capacity, ManagedFileManagement management) throws OXException {
        this(in, -1, capacity, management);
    }

    public ManagedInputStream(InputStream in, int size, int capacity, ManagedFileManagement management) throws OXException {
        if (size >= 0 && size <= capacity) {
            this.delegate = in;
        } else {
            try {
                int nob;
                UnsynchronizedByteArrayOutputStream tmp = new UnsynchronizedByteArrayOutputStream(8192);
                byte[] buf = new byte[2048];
                int len = -1;
                for (nob = 0; nob < capacity && (len = in.read(buf, 0, buf.length)) > 0; nob += len) {
                    tmp.write(buf, 0, len);
                }
                if (nob >= capacity) {
                    this.delegate = management.createManagedFile((InputStream)new CombinedInputStream(tmp.toByteArray(), in)).getInputStream();
                } else {
                    this.delegate = new UnsynchronizedByteArrayInputStream(tmp.toByteArray());
                    in.close();
                }
            }
            catch (IOException e) {
                throw ManagedFileExceptionErrorMessage.IO_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    @Override
    public int available() throws IOException {
        return this.delegate.available();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public void mark(int readAheadLimit) {
        this.delegate.mark(readAheadLimit);
    }

    @Override
    public boolean markSupported() {
        return this.delegate.markSupported();
    }

    @Override
    public int read() throws IOException {
        return this.delegate.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.delegate.read(b, off, len);
    }

    @Override
    public void reset() throws IOException {
        this.delegate.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.delegate.skip(n);
    }

    private static final class CombinedInputStream
    extends InputStream {
        private final byte[] consumed;
        private final InputStream remaining;
        private int count;

        public CombinedInputStream(byte[] consumed, InputStream remaining) {
            this.consumed = consumed;
            this.remaining = remaining;
            this.count = 0;
        }

        @Override
        public int read() throws IOException {
            if (this.count < this.consumed.length) {
                return this.consumed[this.count++];
            }
            return this.remaining.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            if (this.count < this.consumed.length) {
                int buffered = this.consumed.length - this.count;
                if (buffered >= len) {
                    int retval = buffered <= len ? buffered : len;
                    System.arraycopy(this.consumed, this.count, b, off, retval);
                    this.count += retval;
                    return retval;
                }
                System.arraycopy(this.consumed, this.count, b, off, buffered);
                this.count += buffered;
                return buffered + this.remaining.read(b, off + buffered, len - buffered);
            }
            return this.remaining.read(b, off, len);
        }
    }
}

