/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.filemanagement.internal;

import com.openexchange.filemanagement.ManagedFileManagement;
import com.openexchange.filemanagement.internal.ManagedFileManagementImpl;
import com.openexchange.server.Initialization;
import com.openexchange.server.osgi.ServerActivator;
import com.openexchange.server.services.ServerServiceRegistry;
import java.util.concurrent.atomic.AtomicBoolean;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public final class ManagedFileInitialization
implements Initialization {
    private final AtomicBoolean started = new AtomicBoolean();
    private volatile ServiceRegistration<ManagedFileManagement> registerService;

    public void start() {
        if (!this.started.compareAndSet(false, true)) {
            return;
        }
        ManagedFileManagementImpl fileManagement = ManagedFileManagementImpl.getInstance();
        ServerServiceRegistry.getInstance().addService(ManagedFileManagement.class, fileManagement);
        BundleContext context = ServerActivator.getContext();
        if (null != context) {
            this.registerService = context.registerService(ManagedFileManagement.class, (Object)fileManagement, null);
        }
    }

    public void stop() {
        if (!this.started.compareAndSet(true, false)) {
            return;
        }
        ServiceRegistration<ManagedFileManagement> registerService = this.registerService;
        if (null != registerService) {
            registerService.unregister();
            this.registerService = null;
        }
        ServerServiceRegistry.getInstance().removeService(ManagedFileManagement.class);
        ManagedFileManagementImpl.releaseInstance();
    }
}

