/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.database.internal;

import com.openexchange.ajax.AJAXServlet;
import com.openexchange.database.ConfigDatabaseService;
import com.openexchange.database.DBPoolingExceptionCodes;
import com.openexchange.database.internal.Configuration;
import com.openexchange.database.internal.ConnectionData;
import com.openexchange.database.internal.ConnectionPool;
import com.openexchange.database.internal.Management;
import com.openexchange.database.internal.PoolLifeCycle;
import com.openexchange.database.internal.Timer;
import com.openexchange.exception.OXException;
import com.openexchange.java.Autoboxing;
import com.openexchange.pooling.ExhaustedActions;
import com.openexchange.pooling.ReentrantLockPool;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.internet.idn.IDNA;

public class ContextDatabaseLifeCycle
implements PoolLifeCycle {
    private static final Pattern pattern = Pattern.compile("[\\?\\&]([\\p{ASCII}&&[^=\\&]]*)=([\\p{ASCII}&&[^=\\&]]*)");
    private static final String SELECT = "SELECT url,driver,login,password,hardlimit,max,initial FROM db_pool WHERE db_pool_id=?";
    private final Management management;
    private final Timer timer;
    private final ConfigDatabaseService configDatabaseService;
    private final ReentrantLockPool.Config defaultPoolConfig;
    private final Map<Integer, ConnectionPool> pools = new ConcurrentHashMap<Integer, ConnectionPool>();

    public ContextDatabaseLifeCycle(Configuration configuration, Management management, Timer timer, ConfigDatabaseService configDatabaseService) {
        this.management = management;
        this.timer = timer;
        this.configDatabaseService = configDatabaseService;
        this.defaultPoolConfig = configuration.getPoolConfig();
    }

    @Override
    public ConnectionPool create(int poolId) throws OXException {
        ConnectionData data = this.loadPoolData(poolId);
        try {
            Class.forName(data.driverClass);
        }
        catch (ClassNotFoundException e) {
            throw DBPoolingExceptionCodes.NO_DRIVER.create((Throwable)e, new Object[]{data.driverClass});
        }
        ConnectionPool retval = new ConnectionPool(data.url, data.props, this.getConfig(data));
        this.pools.put(Autoboxing.I((int)poolId), retval);
        this.timer.addTask(retval.getCleanerTask());
        this.management.addPool(poolId, retval);
        return retval;
    }

    @Override
    public boolean destroy(int poolId) {
        ConnectionPool toDestroy = this.pools.remove(Autoboxing.I((int)poolId));
        if (null == toDestroy) {
            return false;
        }
        this.management.removePool(poolId);
        this.timer.removeTask(toDestroy.getCleanerTask());
        toDestroy.destroy();
        return true;
    }

    private ReentrantLockPool.Config getConfig(ConnectionData data) {
        ReentrantLockPool.Config retval = this.defaultPoolConfig.clone();
        retval.maxActive = data.max;
        retval.minIdle = data.min;
        retval.exhaustedAction = data.block ? ExhaustedActions.BLOCK : ExhaustedActions.GROW;
        return retval;
    }

    private static void parseUrlToProperties(ConnectionData retval) throws OXException {
        int paramStart = retval.url.indexOf(63);
        if (-1 != paramStart) {
            Matcher matcher = pattern.matcher(retval.url);
            retval.url = retval.url.substring(0, paramStart);
            while (matcher.find()) {
                String name = matcher.group(1);
                String value = matcher.group(2);
                if (name == null || name.length() <= 0 || value == null || value.length() <= 0) continue;
                try {
                    retval.props.put(name, AJAXServlet.decodeUrl(value, "UTF-8"));
                }
                catch (RuntimeException e) {
                    throw DBPoolingExceptionCodes.PARAMETER_PROBLEM.create((Throwable)e, new Object[]{value});
                }
            }
        }
    }

    ConnectionData loadPoolData(int poolId) throws OXException {
        ConnectionData retval = null;
        Connection con = this.configDatabaseService.getReadOnly();
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.prepareStatement(SELECT);
            stmt.setInt(1, poolId);
            result = stmt.executeQuery();
            if (!result.next()) {
                throw DBPoolingExceptionCodes.NO_DBPOOL.create(new Object[]{Autoboxing.I((int)poolId)});
            }
            retval = new ConnectionData();
            retval.props = new Properties();
            int pos = 1;
            retval.url = IDNA.toASCII((String)result.getString(pos++));
            retval.driverClass = result.getString(pos++);
            retval.props.put("user", result.getString(pos++));
            retval.props.put("password", result.getString(pos++));
            retval.block = result.getBoolean(pos++);
            retval.max = result.getInt(pos++);
            retval.min = result.getInt(pos++);
        }
        catch (SQLException e) {
            try {
                throw DBPoolingExceptionCodes.SQL_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                this.configDatabaseService.backReadOnly(con);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        this.configDatabaseService.backReadOnly(con);
        ContextDatabaseLifeCycle.parseUrlToProperties(retval);
        return retval;
    }
}

