/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.database.internal;

import com.openexchange.caching.Cache;
import com.openexchange.caching.CacheKey;
import com.openexchange.caching.CacheService;
import com.openexchange.database.Assignment;
import com.openexchange.database.ConfigDatabaseService;
import com.openexchange.database.DBPoolingExceptionCodes;
import com.openexchange.database.internal.AssignmentImpl;
import com.openexchange.database.internal.ContextDatabaseAssignmentService;
import com.openexchange.database.internal.Server;
import com.openexchange.exception.OXException;
import com.openexchange.java.Autoboxing;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.sql.DBUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;

public final class ContextDatabaseAssignmentImpl
implements ContextDatabaseAssignmentService {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(ContextDatabaseAssignmentImpl.class));
    private static final String SELECT = "SELECT read_db_pool_id,write_db_pool_id,db_schema FROM context_server2db_pool WHERE server_id=? AND cid=?";
    private static final String INSERT = "INSERT INTO context_server2db_pool (server_id,cid,read_db_pool_id,write_db_pool_id,db_schema) VALUES (?,?,?,?,?)";
    private final ConfigDatabaseService configDatabaseService;
    private static final String CACHE_NAME = "OXDBPoolCache";
    private CacheService cacheService;
    private Cache cache;
    private final Lock cacheLock = new ReentrantLock(true);

    public ContextDatabaseAssignmentImpl(ConfigDatabaseService configDatabaseService) {
        this.configDatabaseService = configDatabaseService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssignmentImpl getAssignment(int contextId) throws OXException {
        AssignmentImpl retval;
        if (null == this.cache) {
            retval = this.loadAssignment(contextId);
        } else {
            CacheKey key = this.cacheService.newCacheKey(contextId, Server.getServerId());
            this.cacheLock.lock();
            try {
                retval = (AssignmentImpl)this.cache.get((Serializable)key);
                if (null == retval) {
                    retval = this.loadAssignment(contextId);
                    try {
                        this.cache.putSafe((Serializable)key, (Serializable)retval);
                    }
                    catch (OXException e) {
                        LOG.error((Object)"Cannot put database assignment into cache.", (Throwable)e);
                    }
                }
            }
            finally {
                this.cacheLock.unlock();
            }
        }
        return retval;
    }

    private AssignmentImpl loadAssignment(int contextId) throws OXException {
        AssignmentImpl retval = null;
        Connection con = this.configDatabaseService.getReadOnly();
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.prepareStatement(SELECT);
            stmt.setInt(1, Server.getServerId());
            stmt.setInt(2, contextId);
            result = stmt.executeQuery();
            if (!result.next()) {
                throw DBPoolingExceptionCodes.RESOLVE_FAILED.create(new Object[]{Autoboxing.I((int)contextId), Autoboxing.I((int)Server.getServerId())});
            }
            int pos = 1;
            retval = new AssignmentImpl(contextId, Server.getServerId(), result.getInt(pos++), result.getInt(pos++), result.getString(pos++));
        }
        catch (SQLException e) {
            try {
                throw DBPoolingExceptionCodes.SQL_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                this.configDatabaseService.backReadOnly(con);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        this.configDatabaseService.backReadOnly(con);
        return retval;
    }

    private void writeAssignmentDB(Connection con, Assignment assign) throws OXException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement(INSERT);
            int pos = 1;
            stmt.setInt(pos++, assign.getServerId());
            stmt.setInt(pos++, assign.getContextId());
            stmt.setInt(pos++, assign.getReadPoolId());
            stmt.setInt(pos++, assign.getWritePoolId());
            stmt.setString(pos++, assign.getSchema());
            int count = stmt.executeUpdate();
            if (1 != count) {
                throw DBPoolingExceptionCodes.INSERT_FAILED.create(new Object[]{Autoboxing.I((int)assign.getContextId()), Autoboxing.I((int)assign.getServerId())});
            }
        }
        catch (SQLException e) {
            throw DBPoolingExceptionCodes.SQL_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeAssignment(Connection con, Assignment assign) throws OXException {
        if (null != this.cache) {
            CacheKey key = this.cacheService.newCacheKey(assign.getContextId(), assign.getServerId());
            this.cacheLock.lock();
            try {
                try {
                    this.cache.putSafe((Serializable)key, (Serializable)new AssignmentImpl(assign));
                }
                catch (OXException e) {
                    LOG.error((Object)"Cannot put database assignment into cache.", (Throwable)e);
                }
            }
            finally {
                this.cacheLock.unlock();
            }
        }
        this.writeAssignmentDB(con, assign);
    }

    @Override
    public void removeAssignments(int contextId) {
        if (null != this.cache) {
            try {
                this.cache.remove((Serializable)this.cache.newCacheKey(contextId, Server.getServerId()));
            }
            catch (OXException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    void setCacheService(CacheService service) {
        this.cacheService = service;
        try {
            this.cache = service.getCache(CACHE_NAME);
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    void removeCacheService() {
        this.cacheService = null;
        if (null != this.cache) {
            try {
                this.cache.clear();
            }
            catch (OXException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            this.cache = null;
        }
    }
}

