/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.database.internal;

import com.openexchange.config.ConfigurationService;
import com.openexchange.database.DBPoolingExceptionCodes;
import com.openexchange.database.internal.ConnectionPool;
import com.openexchange.exception.OXException;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.pooling.ExhaustedActions;
import com.openexchange.pooling.ReentrantLockPool;
import java.util.Properties;

public final class Configuration {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(Configuration.class));
    private static final String CONFIG_FILENAME = "configdb.properties";
    private Properties props;
    private final Properties readProps = new Properties();
    private final Properties writeProps = new Properties();
    private final ReentrantLockPool.Config poolConfig = ConnectionPool.DEFAULT_CONFIG;

    Configuration() {
    }

    String getReadUrl() {
        return this.getProperty(Property.READ_URL);
    }

    Properties getReadProps() {
        return this.readProps;
    }

    String getWriteUrl() {
        return this.getProperty(Property.WRITE_URL);
    }

    Properties getWriteProps() {
        return this.writeProps;
    }

    private String getProperty(Property property) {
        return this.getProperty(property, null);
    }

    private <T> T getUniversal(Property property, T def, Convert<T> converter) {
        T retval = this.props != null && this.props.containsKey(property.getPropertyName()) ? converter.convert(this.props.getProperty(property.getPropertyName())) : def;
        return retval;
    }

    String getProperty(Property property, String def) {
        return this.getUniversal(property, def, new Convert<String>(){

            @Override
            public String convert(String toConvert) {
                return toConvert;
            }
        });
    }

    int getInt(Property property, int def) {
        return this.getUniversal(property, def, new Convert<Integer>(){

            @Override
            public Integer convert(String toConvert) {
                return Integer.valueOf(toConvert);
            }
        });
    }

    long getLong(Property property, long def) {
        return this.getUniversal(property, def, new Convert<Long>(){

            @Override
            public Long convert(String toConvert) {
                return Long.valueOf(toConvert);
            }
        });
    }

    boolean getBoolean(Property property, boolean def) {
        return this.getUniversal(property, def, new Convert<Boolean>(){

            @Override
            public Boolean convert(String toConvert) {
                return Boolean.valueOf(toConvert);
            }
        });
    }

    public void readConfiguration(ConfigurationService service) throws OXException {
        if (null != this.props) {
            throw DBPoolingExceptionCodes.ALREADY_INITIALIZED.create(new Object[]{this.getClass().getName()});
        }
        this.props = service.getFile(CONFIG_FILENAME);
        if (this.props.isEmpty()) {
            throw DBPoolingExceptionCodes.MISSING_CONFIGURATION.create();
        }
        this.separateReadWrite();
        this.loadDrivers();
        this.initPoolConfig();
    }

    private void separateReadWrite() {
        for (Object tmp : this.props.keySet()) {
            String readValue;
            String readKey;
            int equalSignPos;
            String value;
            String key = (String)tmp;
            if (key.startsWith("readProperty.")) {
                value = this.props.getProperty(key);
                equalSignPos = value.indexOf(61);
                readKey = value.substring(0, equalSignPos);
                readValue = value.substring(equalSignPos + 1);
                this.readProps.put(readKey, readValue);
                continue;
            }
            if (!key.startsWith("writeProperty.")) continue;
            value = this.props.getProperty(key);
            equalSignPos = value.indexOf(61);
            readKey = value.substring(0, equalSignPos);
            readValue = value.substring(equalSignPos + 1);
            this.writeProps.put(readKey, readValue);
        }
    }

    private void loadDrivers() throws OXException {
        String readDriverClass = this.getProperty(Property.READ_DRIVER_CLASS);
        if (null == readDriverClass) {
            throw DBPoolingExceptionCodes.PROPERTY_MISSING.create(new Object[]{Property.READ_DRIVER_CLASS.getPropertyName()});
        }
        try {
            Class.forName(readDriverClass);
        }
        catch (ClassNotFoundException e) {
            throw DBPoolingExceptionCodes.NO_DRIVER.create((Throwable)e, new Object[]{readDriverClass});
        }
        String writeDriverClass = this.getProperty(Property.WRITE_DRIVER_CLASS);
        if (null == writeDriverClass) {
            throw DBPoolingExceptionCodes.PROPERTY_MISSING.create(new Object[]{Property.WRITE_DRIVER_CLASS.getPropertyName()});
        }
        try {
            Class.forName(writeDriverClass);
        }
        catch (ClassNotFoundException e) {
            throw DBPoolingExceptionCodes.NO_DRIVER.create((Throwable)e, new Object[]{writeDriverClass});
        }
    }

    public void clear() {
        this.props = null;
        this.readProps.clear();
        this.writeProps.clear();
    }

    private void initPoolConfig() {
        this.poolConfig.minIdle = this.getInt(Property.MIN_IDLE, this.poolConfig.minIdle);
        this.poolConfig.maxIdle = this.getInt(Property.MAX_IDLE, this.poolConfig.maxIdle);
        this.poolConfig.maxIdleTime = this.getLong(Property.MAX_IDLE_TIME, this.poolConfig.maxIdleTime);
        this.poolConfig.maxActive = this.getInt(Property.MAX_ACTIVE, this.poolConfig.maxActive);
        this.poolConfig.maxWait = this.getLong(Property.MAX_WAIT, this.poolConfig.maxWait);
        this.poolConfig.maxLifeTime = this.getLong(Property.MAX_LIFE_TIME, this.poolConfig.maxLifeTime);
        this.poolConfig.exhaustedAction = ExhaustedActions.valueOf(this.getProperty(Property.EXHAUSTED_ACTION, this.poolConfig.exhaustedAction.name()));
        this.poolConfig.testOnActivate = this.getBoolean(Property.TEST_ON_ACTIVATE, this.poolConfig.testOnActivate);
        this.poolConfig.testOnDeactivate = this.getBoolean(Property.TEST_ON_DEACTIVATE, this.poolConfig.testOnDeactivate);
        this.poolConfig.testOnIdle = this.getBoolean(Property.TEST_ON_IDLE, this.poolConfig.testOnIdle);
        this.poolConfig.testThreads = this.getBoolean(Property.TEST_THREADS, this.poolConfig.testThreads);
        LOG.info((Object)this.poolConfig.toString());
    }

    ReentrantLockPool.Config getPoolConfig() {
        return this.poolConfig;
    }

    public static enum Property {
        READ_URL("readUrl"),
        WRITE_URL("writeUrl"),
        READ_DRIVER_CLASS("readDriverClass"),
        WRITE_DRIVER_CLASS("writeDriverClass"),
        CLEANER_INTERVAL("cleanerInterval"),
        MIN_IDLE("minIdle"),
        MAX_IDLE("maxIdle"),
        MAX_IDLE_TIME("maxIdleTime"),
        MAX_ACTIVE("maxActive"),
        MAX_WAIT("maxWait"),
        MAX_LIFE_TIME("maxLifeTime"),
        EXHAUSTED_ACTION("exhaustedAction"),
        TEST_ON_ACTIVATE("testOnActivate"),
        TEST_ON_DEACTIVATE("testOnDeactivate"),
        TEST_ON_IDLE("testOnIdle"),
        TEST_THREADS("testThreads");

        private String propertyName;

        private Property(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }

    private static interface Convert<T> {
        public T convert(String var1);
    }
}

