/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.database.internal;

import com.openexchange.database.ConfigDatabaseService;
import com.openexchange.database.DBPoolingExceptionCodes;
import com.openexchange.database.internal.Server;
import com.openexchange.exception.OXException;
import com.openexchange.tools.sql.DBUtils;
import gnu.trove.list.linked.TIntLinkedList;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ConfigDBStorage {
    private final ConfigDatabaseService configDatabaseService;
    private static final String SQL_SELECT_CONTEXTS = "SELECT cid FROM context_server2db_pool WHERE server_id=? AND write_db_pool_id=? AND db_schema=?";

    public ConfigDBStorage(ConfigDatabaseService configDatabaseService) {
        this.configDatabaseService = configDatabaseService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int[] getContextsFromSchema(String schema, int writePoolId) throws OXException {
        int[] nArray;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = this.configDatabaseService.getReadOnly();
            stmt = con.prepareStatement(SQL_SELECT_CONTEXTS);
            stmt.setInt(1, Server.getServerId());
            stmt.setInt(2, writePoolId);
            stmt.setString(3, schema);
            rs = stmt.executeQuery();
            TIntLinkedList tmp = new TIntLinkedList();
            while (rs.next()) {
                tmp.add(rs.getInt(1));
            }
            nArray = tmp.toArray();
        }
        catch (Throwable throwable) {
            try {
                DBUtils.closeSQLStuff(rs, stmt);
                if (con != null) {
                    this.configDatabaseService.backReadOnly(con);
                }
                throw throwable;
            }
            catch (SQLException e) {
                throw DBPoolingExceptionCodes.SQL_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        if (con != null) {
            this.configDatabaseService.backReadOnly(con);
        }
        return nArray;
    }
}

