/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.consistency;

import com.openexchange.consistency.ConsistencyMBean;
import com.openexchange.consistency.MBeanConsistency;
import com.openexchange.consistency.MBeanNamer;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class ConsistencyCheck {
    public static void main(String[] args) {
        SimpleLexer lexer = new SimpleLexer(args);
        Configuration config = new Configuration();
        lexer.noise("in");
        if (lexer.consume("host")) {
            String hostname = lexer.getCurrent();
            String[] hostAndPort = hostname.split(":");
            config.setHost(hostAndPort[0]);
            if (hostAndPort.length > 1) {
                config.setPort(Integer.parseInt(hostAndPort[1]));
            }
            lexer.advance();
        } else {
            config.setHost("localhost");
        }
        if (lexer.consume("repair")) {
            config.setAction("repair");
        } else if (lexer.consume("list")) {
            if (lexer.consume("missing")) {
                config.setAction("listMissing");
            } else if (lexer.consume("unassigned")) {
                config.setAction("listUnassigned");
            } else {
                System.exit(ConsistencyCheck.dontKnowWhatToList());
            }
        } else {
            System.exit(ConsistencyCheck.noaction());
        }
        lexer.noise("files");
        lexer.noise("errors");
        lexer.noise("in");
        if (lexer.consume("database")) {
            config.setSource("database");
            if (!ConsistencyCheck.parseId(lexer, config)) {
                System.exit(ConsistencyCheck.noid());
            }
        } else if (lexer.consume("filestore")) {
            config.setSource("filestore");
            if (!ConsistencyCheck.parseId(lexer, config)) {
                System.exit(ConsistencyCheck.noid());
            }
        } else if (lexer.consume("context")) {
            config.setSource("context");
            if (!ConsistencyCheck.parseId(lexer, config)) {
                System.exit(ConsistencyCheck.noid());
            }
        } else if (lexer.consume("all") || lexer.consume("everywhere")) {
            config.setSource("all");
        } else {
            System.exit(ConsistencyCheck.noproblemsource());
        }
        lexer.noise("with");
        lexer.noise("policies");
        while (!lexer.eol()) {
            if (lexer.consume("missing_file_for_infoitem")) {
                lexer.noise(":");
                if (lexer.consume("create_dummy")) {
                    config.addPolicy("missing_file_for_infoitem", "create_dummy");
                    continue;
                }
                if (lexer.consume("delete")) {
                    config.addPolicy("missing_file_for_infoitem", "delete");
                    continue;
                }
                System.exit(ConsistencyCheck.unknownAction("missing_file_for_infoitem", lexer.getCurrent(), "create_dummy, delete"));
                continue;
            }
            if (lexer.consume("missing_file_for_attachment")) {
                lexer.noise(":");
                if (lexer.consume("create_dummy")) {
                    config.addPolicy("missing_file_for_attachment", "create_dummy");
                    continue;
                }
                if (lexer.consume("delete")) {
                    config.addPolicy("missing_file_for_attachment", "delete");
                    continue;
                }
                System.exit(ConsistencyCheck.unknownAction("missing_file_for_infoitem", lexer.getCurrent(), "create_dummy, delete"));
                continue;
            }
            if (lexer.consume("missing_entry_for_file")) {
                lexer.noise(":");
                if (lexer.consume("create_admin_infoitem")) {
                    config.addPolicy("missing_entry_for_file", "create_admin_infoitem");
                    continue;
                }
                if (lexer.consume("delete")) {
                    config.addPolicy("missing_entry_for_file", "delete");
                    continue;
                }
                System.exit(ConsistencyCheck.unknownAction("missing_file_for_infoitem", lexer.getCurrent(), "create_admin_infoitem, delete"));
                continue;
            }
            System.exit(ConsistencyCheck.unknownCondition(lexer.getCurrent(), "missing_file_for_infoitem, missing_file_for_attachment, missing_entry_for_file"));
        }
        try {
            config.run();
            System.out.println("Done");
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    private static boolean parseId(SimpleLexer lexer, Configuration config) {
        try {
            config.setSourceId(Integer.parseInt(lexer.getCurrent()));
            lexer.advance();
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    private static int dontKnowWhatToList() {
        System.err.println("Please tell me what to list. Either list missing or list unassigned.");
        return 6;
    }

    private static int unknownAction(String condition, String action, String possibleActions) {
        System.err.println("Unknown action " + action + " for condition " + condition + ". I know only " + possibleActions);
        return 5;
    }

    private static int unknownCondition(String condition, String possibleConditions) {
        System.err.println("Unknown condition " + condition + " I know only about: " + possibleConditions);
        return 4;
    }

    private static int noid() {
        System.err.println("Please specify an id for the context, filestore or database that I should check.");
        return 3;
    }

    private static int noproblemsource() {
        System.err.println("Please specify what to search for problems (either \"context [id]\" or \"filestore [id]\" or  \"database [id]\".");
        return 2;
    }

    private static int noaction() {
        System.err.println("Please specify an action (either \"list missing\", \"list unassigned\" or \"repair\" ");
        return 1;
    }

    private static final class Configuration {
        private String host;
        private int port = 9999;
        private String action;
        private String source;
        private int sourceId;
        private final Map<String, String> policies = new HashMap<String, String>();
        private ConsistencyMBean consistency;
        private JMXConnector jmxConnector;

        private Configuration() {
        }

        public void setHost(String host) {
            this.host = host;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public void setAction(String action) {
            this.action = action;
        }

        public void setSource(String source) {
            this.source = source;
        }

        public void setSourceId(int sourceId) {
            this.sourceId = sourceId;
        }

        public void addPolicy(String condition, String action) {
            if (this.policies.containsKey(condition)) {
                throw new IllegalArgumentException("Condition " + condition + " already has an action assigned to it.");
            }
            this.policies.put(condition, action);
        }

        public void run() throws Exception {
            if ("listMissing".equals(this.action)) {
                this.listMissing();
            } else if ("listUnassigned".equals(this.action)) {
                this.listUnassigned();
            } else {
                this.repair();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void listMissing() throws MBeanException, IOException, MalformedObjectNameException, NullPointerException {
            Map<Integer, List<String>> result = null;
            try {
                this.connect();
                if ("database".equals(this.source)) {
                    result = this.consistency.listMissingFilesInDatabase(this.sourceId);
                } else if ("filestore".equals(this.source)) {
                    result = this.consistency.listMissingFilesInFilestore(this.sourceId);
                } else if ("context".equals(this.source)) {
                    result = new HashMap<Integer, List<String>>();
                    result.put(this.sourceId, this.consistency.listMissingFilesInContext(this.sourceId));
                } else if ("all".equals(this.source)) {
                    result = this.consistency.listAllMissingFiles();
                }
            }
            finally {
                this.disconnect();
            }
            this.print(result);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void repair() throws MBeanException, IOException, MalformedObjectNameException, NullPointerException {
            if (this.policies.isEmpty()) {
                System.out.println("Nothing to be done. Please specify one or more resolver policies");
                return;
            }
            try {
                this.connect();
                if ("database".equals(this.source)) {
                    this.consistency.repairFilesInDatabase(this.sourceId, this.getPolicyString());
                } else if ("filestore".equals(this.source)) {
                    this.consistency.repairFilesInFilestore(this.sourceId, this.getPolicyString());
                } else if ("context".equals(this.source)) {
                    this.consistency.repairFilesInContext(this.sourceId, this.getPolicyString());
                } else if ("all".equals(this.source)) {
                    this.consistency.repairAllFiles(this.getPolicyString());
                }
            }
            finally {
                this.disconnect();
            }
        }

        private String getPolicyString() {
            StringBuilder sb = new StringBuilder();
            for (String condition : this.policies.keySet()) {
                sb.append(condition).append(':').append(this.policies.get(condition)).append(',');
            }
            sb.setLength(sb.length() - 1);
            return sb.toString();
        }

        private void disconnect() {
            if (null != this.jmxConnector) {
                try {
                    this.jmxConnector.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private void connect() throws IOException, MalformedObjectNameException, NullPointerException {
            JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + this.host + ":" + this.port + "/server");
            this.jmxConnector = JMXConnectorFactory.connect(url, null);
            MBeanServerConnection mbsc = this.jmxConnector.getMBeanServerConnection();
            ObjectName name = MBeanNamer.getName();
            this.consistency = new MBeanConsistency(mbsc, name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void listUnassigned() throws MBeanException, IOException, MalformedObjectNameException, NullPointerException {
            Map<Integer, List<String>> result = null;
            try {
                this.connect();
                if ("database".equals(this.source)) {
                    result = this.consistency.listUnassignedFilesInDatabase(this.sourceId);
                } else if ("filestore".equals(this.source)) {
                    result = this.consistency.listUnassignedFilesInFilestore(this.sourceId);
                } else if ("context".equals(this.source)) {
                    result = new HashMap<Integer, List<String>>();
                    result.put(this.sourceId, this.consistency.listUnassignedFilesInContext(this.sourceId));
                } else if ("all".equals(this.source)) {
                    result = this.consistency.listAllUnassignedFiles();
                }
            }
            finally {
                this.disconnect();
            }
            this.print(result);
        }

        private void print(Map<Integer, List<String>> result) {
            if (null == result) {
                return;
            }
            for (Map.Entry<Integer, List<String>> entry : result.entrySet()) {
                int ctxId = entry.getKey();
                List<String> brokenFiles = entry.getValue();
                System.out.println("I found " + brokenFiles.size() + " problems in context " + ctxId);
                for (String brokenFile : brokenFiles) {
                    System.out.println("\t" + brokenFile);
                }
            }
        }
    }

    private static class SimpleLexer {
        private final String[] args;
        private int index;

        public SimpleLexer(String[] args) {
            this.args = args;
            this.index = 0;
        }

        public String getCurrent() {
            if (this.eol()) {
                return "";
            }
            return this.args[this.index];
        }

        public void advance() {
            ++this.index;
        }

        public boolean lookahead(String expect) {
            return this.getCurrent().equals(expect);
        }

        public boolean consume(String expect) {
            if (this.lookahead(expect)) {
                this.advance();
                return true;
            }
            return false;
        }

        public boolean lookahead(Pattern p) {
            return p.matcher(this.getCurrent()).find();
        }

        public Matcher consume(Pattern p) {
            Matcher m = p.matcher(this.getCurrent());
            if (m.find()) {
                this.advance();
                return m;
            }
            return null;
        }

        public void noise(String token) {
            this.consume(token);
        }

        public boolean eol() {
            return this.index >= this.args.length;
        }
    }
}

