/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.authentication.service.osgi;

import com.openexchange.authentication.AuthenticationService;
import com.openexchange.authentication.service.Authentication;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class AuthenticationCustomizer
implements ServiceTrackerCustomizer<AuthenticationService, AuthenticationService> {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(AuthenticationCustomizer.class));
    private final BundleContext context;

    public AuthenticationCustomizer(BundleContext context) {
        this.context = context;
    }

    public AuthenticationService addingService(ServiceReference<AuthenticationService> reference) {
        AuthenticationService auth = (AuthenticationService)this.context.getService(reference);
        if (Authentication.setService(auth)) {
            return auth;
        }
        LOG.error((Object)"Several authentication services found. Remove all except one!");
        return null;
    }

    public void modifiedService(ServiceReference<AuthenticationService> reference, AuthenticationService service) {
    }

    public void removedService(ServiceReference<AuthenticationService> reference, AuthenticationService service) {
        AuthenticationService auth = service;
        if (!Authentication.dropService(auth)) {
            LOG.error((Object)"Removed authentication services was not active!");
        }
        this.context.ungetService(reference);
    }
}

