/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.writer;

import com.openexchange.ajax.writer.ResponseWriter;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.json.OXJSONWriter;
import com.openexchange.login.LoginResult;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public final class LoginWriter {
    private static final Locale DEFAULT_LOCALE = Locale.US;
    private static final String PARAMETER_USER_ID = "user_id";
    private static final String PARAMETER_USER = "user";
    private static final String RANDOM_PARAM = "random";
    private static final String PARAMETER_SESSION = "session";
    private static final String PARAMETER_LOCALE = "locale";

    public void writeLogin(LoginResult result, JSONObject json) throws JSONException {
        LoginWriter.write(result, json);
    }

    public void writeLogin(Session session, JSONObject json) throws JSONException {
        LoginWriter.write(session, json);
    }

    public static void write(LoginResult result, JSONObject json) throws JSONException {
        LoginWriter.write(result.getSession(), json, result.warnings(), result.getUser().getLocale());
    }

    public static void write(Session session, JSONObject json) throws JSONException {
        Locale locale = null;
        if (session instanceof ServerSession) {
            locale = ((ServerSession)session).getUser().getLocale();
        } else {
            try {
                locale = UserStorage.getStorageUser(session.getUserId(), session.getContextId()).getLocale();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        LoginWriter.write(session, json, Collections.<OXException>emptyList(), locale);
    }

    public static void write(Session session, JSONObject json, Locale locale) throws JSONException {
        LoginWriter.write(session, json, Collections.<OXException>emptyList(), locale);
    }

    private static void write(Session session, JSONObject json, Collection<OXException> warnings, Locale locale) throws JSONException {
        json.put(PARAMETER_SESSION, (Object)session.getSessionID());
        json.put(RANDOM_PARAM, (Object)session.getRandomToken());
        json.put(PARAMETER_USER, (Object)session.getLogin());
        json.put(PARAMETER_USER_ID, session.getUserId());
        Locale loc = locale == null ? LoginWriter.resolveLocaleForUser(session, DEFAULT_LOCALE) : locale;
        json.put(PARAMETER_LOCALE, (Object)loc.toString());
        if (null != warnings && !warnings.isEmpty()) {
            OXJSONWriter writer = new OXJSONWriter(json);
            List<Object> list = warnings instanceof List ? (List<Object>)warnings : new ArrayList<OXException>(warnings);
            ResponseWriter.writeWarnings((List<OXException>)list, writer, loc);
        }
    }

    private static Locale resolveLocaleForUser(Session session, Locale defaultLocale) {
        if (session instanceof ServerSession) {
            return ((ServerSession)session).getUser().getLocale();
        }
        try {
            return UserStorage.getStorageUser(session.getUserId(), session.getContextId()).getLocale();
        }
        catch (Exception e) {
            return defaultLocale;
        }
    }
}

