/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.tools;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONValue;

public class JSONCoercion {
    public static Object coerceToNative(JSONValue object) throws JSONException {
        if (null == object) {
            return null;
        }
        if (object.isArray()) {
            JSONArray jsonArray = object.toArray();
            int length = jsonArray.length();
            ArrayList<Object> list = new ArrayList<Object>(length);
            for (int i = 0; i < length; ++i) {
                list.add(JSONCoercion.coerceToNative(jsonArray.get(i)));
            }
            return list;
        }
        if (object.isObject()) {
            JSONObject jsonObject = object.toObject();
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(jsonObject.length());
            for (String key : jsonObject.keySet()) {
                map.put(key, JSONCoercion.coerceToNative(jsonObject.get(key)));
            }
            return map;
        }
        return object;
    }

    public static Object coerceToNative(Object object) throws JSONException {
        if (object instanceof JSONArray) {
            JSONArray jsonArray = (JSONArray)object;
            int length = jsonArray.length();
            ArrayList<Object> list = new ArrayList<Object>(length);
            for (int i = 0; i < length; ++i) {
                list.add(JSONCoercion.coerceToNative(jsonArray.get(i)));
            }
            return list;
        }
        if (object instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)object;
            HashMap<String, Object> map = new HashMap<String, Object>(jsonObject.length());
            for (String key : jsonObject.keySet()) {
                map.put(key, JSONCoercion.coerceToNative(jsonObject.get(key)));
            }
            return map;
        }
        if (JSONObject.NULL == object) {
            return null;
        }
        return object;
    }

    public static boolean needsJSONCoercion(Object value) {
        return value instanceof Map || value instanceof Collection || JSONCoercion.isArray(value);
    }

    public static boolean needsNativeCoercion(Object value) {
        return value instanceof JSONValue;
    }

    public static Object coerceToJSON(Object value) throws JSONException {
        if (value instanceof JSONObject) {
            return value;
        }
        if (value instanceof JSONArray) {
            return value;
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            JSONObject jsonObject = new JSONObject(map.size());
            for (Map.Entry entry : map.entrySet()) {
                jsonObject.put((String)entry.getKey(), JSONCoercion.coerceToJSON(entry.getValue()));
            }
            return jsonObject;
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            JSONArray jsonArray = new JSONArray(collection.size());
            for (Object object : collection) {
                jsonArray.put(JSONCoercion.coerceToJSON(object));
            }
            return jsonArray;
        }
        if (JSONCoercion.isArray(value)) {
            int length = Array.getLength(value);
            JSONArray jsonArray = new JSONArray(length);
            for (int i = 0; i < length; ++i) {
                Object object = Array.get(value, i);
                jsonArray.put(JSONCoercion.coerceToJSON(object));
            }
            return jsonArray;
        }
        new JSONArray().put(value);
        return value;
    }

    public static boolean isArray(Object object) {
        return null != object && '[' == object.getClass().getName().charAt(0);
    }
}

