/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.converters.preview;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.Converter;
import com.openexchange.ajax.requesthandler.ResultConverter;
import com.openexchange.ajax.requesthandler.converters.preview.AbstractPreviewResultConverter;
import com.openexchange.exception.OXException;
import com.openexchange.filemanagement.ManagedFile;
import com.openexchange.filemanagement.ManagedFileManagement;
import com.openexchange.java.Charsets;
import com.openexchange.java.Streams;
import com.openexchange.preview.PreviewDocument;
import com.openexchange.preview.PreviewOutput;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;

public class DownloadPreviewResultConverter
extends AbstractPreviewResultConverter {
    @Override
    public String getInputFormat() {
        return "preview";
    }

    @Override
    public String getOutputFormat() {
        return "preview_download";
    }

    @Override
    public ResultConverter.Quality getQuality() {
        return ResultConverter.Quality.GOOD;
    }

    @Override
    public PreviewOutput getOutput() {
        return PreviewOutput.HTML;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void convert(AJAXRequestData requestData, AJAXRequestResult result, ServerSession session, Converter converter) throws OXException {
        ManagedFile managedFile;
        super.convert(requestData, result, session, converter);
        PreviewDocument previewDocument = (PreviewDocument)result.getResultObject();
        try {
            ManagedFileManagement fileManagement = ServerServiceRegistry.getInstance().getService(ManagedFileManagement.class);
            File tempFile = fileManagement.newTempFile();
            FileOutputStream fos = new FileOutputStream(tempFile);
            try {
                fos.write(((String)previewDocument.getContent().get(0)).getBytes(Charsets.UTF_8));
                fos.flush();
            }
            finally {
                Streams.close((Closeable)fos);
            }
            managedFile = fileManagement.createManagedFile(tempFile);
        }
        catch (IOException e) {
            throw AjaxExceptionCodes.IO_ERROR.create(e, e.getMessage());
        }
        Map metaData = previewDocument.getMetaData();
        managedFile.setContentType((String)metaData.get("content-type"));
        managedFile.setFileName((String)metaData.get("resourcename"));
        result.setResultObject(managedFile.constructURL((Session)session), this.getOutputFormat());
    }
}

