/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.converters.preview;

import com.openexchange.ajax.container.IFileHolder;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.Converter;
import com.openexchange.ajax.requesthandler.ResultConverter;
import com.openexchange.conversion.Data;
import com.openexchange.conversion.DataProperties;
import com.openexchange.conversion.SimpleData;
import com.openexchange.exception.OXException;
import com.openexchange.java.Streams;
import com.openexchange.java.StringAllocator;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.mail.utils.DisplayMode;
import com.openexchange.preview.PreviewDocument;
import com.openexchange.preview.PreviewOutput;
import com.openexchange.preview.PreviewService;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.io.Closeable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.logging.Log;

abstract class AbstractPreviewResultConverter
implements ResultConverter {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(AbstractPreviewResultConverter.class));
    protected static final String PARAMETER_VIEW = "view";
    protected static final String PARAMETER_EDIT = "edit";
    private static final Set<String> BOOLS = new HashSet<String>(Arrays.asList("true", "yes", "y", "on", "1"));
    private static final String VIEW_RAW = "raw";
    private static final String VIEW_TEXT = "text";
    private static final String VIEW_TEXT_NO_HTML_ATTACHMENT = "textNoHtmlAttach";
    private static final String VIEW_HTML = "html";
    private static final String VIEW_HTML_BLOCKED_IMAGES = "noimg";

    protected AbstractPreviewResultConverter() {
    }

    @Override
    public String getInputFormat() {
        return "file";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void convert(AJAXRequestData requestData, AJAXRequestResult result, ServerSession session, Converter converter) throws OXException {
        Object resultObject = result.getResultObject();
        if (!(resultObject instanceof IFileHolder)) {
            throw AjaxExceptionCodes.UNEXPECTED_RESULT.create(IFileHolder.class.getSimpleName(), null == resultObject ? "null" : resultObject.getClass().getSimpleName());
        }
        IFileHolder fileHolder = (IFileHolder)resultObject;
        try {
            PreviewService previewService = ServerServiceRegistry.getInstance().getService(PreviewService.class);
            DataProperties dataProperties = new DataProperties(4);
            dataProperties.put("com.openexchange.conversion.content-type", fileHolder.getContentType());
            dataProperties.put("com.openexchange.conversion.disposition", fileHolder.getDisposition());
            dataProperties.put("com.openexchange.conversion.name", fileHolder.getName());
            dataProperties.put("com.openexchange.conversion.size", Long.toString(fileHolder.getLength()));
            int pages = -1;
            if (requestData.containsParameter("pages")) {
                pages = requestData.getIntParameter("pages");
            }
            PreviewDocument previewDocument = previewService.getPreviewFor((Data)new SimpleData((Object)fileHolder.getStream(), dataProperties), this.getOutput(), (Session)session, pages);
            if (requestData.getIntParameter("save") == 1) {
            } else {
                result.setResultObject(previewDocument, this.getOutputFormat());
            }
        }
        finally {
            Streams.close((Closeable)fileHolder);
        }
    }

    protected static boolean parseBool(String value) {
        if (null == value) {
            return false;
        }
        return BOOLS.contains(value.trim().toLowerCase(Locale.US));
    }

    protected static DisplayMode detectDisplayMode(boolean modifyable, String view, UserSettingMail usm) {
        DisplayMode displayMode;
        if (null == view) {
            return modifyable ? DisplayMode.MODIFYABLE : DisplayMode.DISPLAY;
        }
        if (VIEW_RAW.equals(view)) {
            displayMode = DisplayMode.RAW;
        } else if (VIEW_TEXT_NO_HTML_ATTACHMENT.equals(view)) {
            usm.setDisplayHtmlInlineContent(false);
            usm.setSuppressHTMLAlternativePart(true);
            displayMode = modifyable ? DisplayMode.MODIFYABLE : DisplayMode.DISPLAY;
        } else if (VIEW_TEXT.equals(view)) {
            usm.setDisplayHtmlInlineContent(false);
            displayMode = modifyable ? DisplayMode.MODIFYABLE : DisplayMode.DISPLAY;
        } else if (VIEW_HTML.equals(view)) {
            usm.setDisplayHtmlInlineContent(true);
            usm.setAllowHTMLImages(true);
            displayMode = modifyable ? DisplayMode.MODIFYABLE : DisplayMode.DISPLAY;
        } else if (VIEW_HTML_BLOCKED_IMAGES.equals(view)) {
            usm.setDisplayHtmlInlineContent(true);
            usm.setAllowHTMLImages(false);
            displayMode = modifyable ? DisplayMode.MODIFYABLE : DisplayMode.DISPLAY;
        } else {
            LOG.warn((Object)new StringAllocator(64).append("Unknown value in parameter ").append(PARAMETER_VIEW).append(": ").append(view).append(". Using user's mail settings as fallback."));
            displayMode = modifyable ? DisplayMode.MODIFYABLE : DisplayMode.DISPLAY;
        }
        return displayMode;
    }

    public abstract PreviewOutput getOutput();
}

