/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.helper;

import com.openexchange.ajax.helper.BrowserDetector;
import com.openexchange.ajax.helper.CombinedInputStream;
import com.openexchange.ajax.helper.HTMLDetector;
import com.openexchange.exception.OXException;
import com.openexchange.html.HtmlService;
import com.openexchange.java.CharsetDetector;
import com.openexchange.java.Charsets;
import com.openexchange.java.Streams;
import com.openexchange.java.StringAllocator;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.ImageTypeDetector;
import com.openexchange.tools.encoding.Helper;
import com.openexchange.tools.encoding.URLCoder;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;

public final class DownloadUtility {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(DownloadUtility.class));
    private static final Pattern PAT_BSLASH = Pattern.compile("\\\\");
    private static final Pattern PAT_QUOTE = Pattern.compile("\"");
    private static final String DEFAULT_FILENAME = "file.dat";
    private static final String MIME_TEXT_PLAIN = "text/plain";
    private static final String MIME_TEXT_HTML = "text/htm";

    private DownloadUtility() {
    }

    public static CheckedDownload checkInlineDownload(InputStream inputStream, String fileName, String contentTypeStr, String userAgent) throws OXException {
        return DownloadUtility.checkInlineDownload(inputStream, fileName, contentTypeStr, null, userAgent);
    }

    public static CheckedDownload checkInlineDownload(InputStream inputStream, String fileName, String sContentType, String overridingDisposition, String userAgent) throws OXException {
        try {
            CheckedDownload retval;
            StringAllocator builder;
            String baseType;
            ContentType contentType = new ContentType(sContentType);
            if (contentType.startsWith("application/octet-stream")) {
                String ct = MimeType2ExtMap.getContentType(fileName);
                int pos = ct.indexOf(47);
                contentType.setPrimaryType(ct.substring(0, pos));
                contentType.setSubType(ct.substring(pos + 1));
            }
            String sContentDisposition = overridingDisposition;
            InputStream in = inputStream;
            String fn = fileName;
            if (contentType.startsWith(MIME_TEXT_HTML)) {
                if (null == sContentDisposition) {
                    sContentDisposition = "attachment";
                } else if (DownloadUtility.toLowerCase(sContentDisposition).startsWith("inline")) {
                    ByteArrayOutputStream bytes = Streams.stream2ByteArrayOutputStream((InputStream)in);
                    HtmlService htmlService = ServerServiceRegistry.getInstance().getService(HtmlService.class);
                    String cs = contentType.getCharsetParameter();
                    boolean valid = CharsetDetector.isValid((String)cs);
                    String htmlContent = bytes.toString(valid ? cs : null);
                    htmlContent = htmlService.sanitize(htmlContent, null, true, null, null);
                    in = Streams.newByteArrayInputStream((byte[])htmlContent.getBytes(valid ? Charsets.forName((String)cs) : Charsets.ISO_8859_1));
                }
            } else if (contentType.startsWith("image/")) {
                boolean msieOnWindows;
                BrowserDetector browserDetector = new BrowserDetector(userAgent);
                boolean bl = msieOnWindows = browserDetector.isMSIE() && browserDetector.isWindows();
                if (msieOnWindows && 8.0f > browserDetector.getBrowserVersion()) {
                    byte[] sequence = new byte[256];
                    int nRead = in.read(sequence, 0, sequence.length);
                    if (nRead < sequence.length) {
                        byte[] tmp = sequence;
                        sequence = new byte[nRead];
                        System.arraycopy(tmp, 0, sequence, 0, nRead);
                    }
                    String preparedFileName = DownloadUtility.getSaveAsFileName(fileName, msieOnWindows, sContentType);
                    String fileExtension = DownloadUtility.getFileExtension(fn);
                    if (null == fileExtension) {
                        if (HTMLDetector.containsHTMLTags(sequence)) {
                            return DownloadUtility.asAttachment(inputStream, preparedFileName);
                        }
                    } else {
                        HashSet<String> extensions = new HashSet<String>(MimeType2ExtMap.getFileExtensions(contentType.getBaseType()));
                        if (extensions.isEmpty() || extensions.size() == 1 && extensions.contains("dat")) {
                            String ct = MimeType2ExtMap.getContentType(fn);
                            if ("application/octet-stream".equals(ct)) {
                                if (HTMLDetector.containsHTMLTags(sequence)) {
                                    return DownloadUtility.asAttachment(inputStream, preparedFileName);
                                }
                            } else {
                                int pos = ct.indexOf(47);
                                contentType.setPrimaryType(ct.substring(0, pos));
                                contentType.setSubType(ct.substring(pos + 1));
                            }
                        } else if (!extensions.contains(fileExtension)) {
                            fn = DownloadUtility.addFileExtension(fileExtension, (String)extensions.iterator().next());
                            preparedFileName = DownloadUtility.getSaveAsFileName(fn, msieOnWindows, contentType.getBaseType());
                        }
                        String detectedCT = ImageTypeDetector.getMimeType(sequence);
                        if ("application/octet-stream".equals(detectedCT)) {
                            if (HTMLDetector.containsHTMLTags(sequence)) {
                                return DownloadUtility.asAttachment(inputStream, preparedFileName);
                            }
                        } else if (!contentType.isMimeType(detectedCT)) {
                            contentType.setBaseType(detectedCT);
                        }
                    }
                    in = new CombinedInputStream(sequence, in);
                }
            }
            if (sContentDisposition == null) {
                baseType = contentType.getBaseType();
                builder = new StringAllocator(32).append("attachment");
                DownloadUtility.appendFilenameParameter(fileName, contentType.isBaseType("application", "octet-stream") ? null : baseType, userAgent, builder);
                retval = new CheckedDownload(baseType, builder.toString(), in);
            } else if (sContentDisposition.indexOf(59) < 0) {
                baseType = contentType.getBaseType();
                builder = new StringAllocator(32).append(sContentDisposition);
                DownloadUtility.appendFilenameParameter(fileName, contentType.isBaseType("application", "octet-stream") ? null : baseType, userAgent, builder);
                retval = new CheckedDownload(baseType, builder.toString(), in);
            } else {
                retval = new CheckedDownload(contentType.getBaseType(), sContentDisposition, in);
            }
            return retval;
        }
        catch (UnsupportedEncodingException e) {
            throw AjaxExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        catch (IOException e) {
            throw AjaxExceptionCodes.IO_ERROR.create(e, e.getMessage());
        }
    }

    public static void appendFilenameParameter(String fileName, String baseCT, String userAgent, StringBuilder appendTo) {
        boolean isAndroid;
        if (null == fileName) {
            appendTo.append("; filename=\"").append(DEFAULT_FILENAME).append('\"');
            return;
        }
        String fn = fileName;
        if (null != baseCT && null == DownloadUtility.getFileExtension(fn)) {
            if (baseCT.regionMatches(true, 0, MIME_TEXT_PLAIN, 0, MIME_TEXT_PLAIN.length()) && !fileName.toLowerCase(Locale.US).endsWith(".txt")) {
                fn = fn + ".txt";
            } else if (baseCT.regionMatches(true, 0, MIME_TEXT_HTML, 0, MIME_TEXT_HTML.length()) && !fileName.toLowerCase(Locale.US).endsWith(".html")) {
                fn = fn + ".html";
            }
        }
        fn = DownloadUtility.escapeBackslashAndQuote(fn);
        if (null != userAgent && new BrowserDetector(userAgent).isMSIE()) {
            appendTo.append("; filename=\"").append(Helper.encodeFilenameForIE(fn, Charsets.UTF_8)).append('\"');
            return;
        }
        String foo = new String(fn.getBytes(Charsets.UTF_8), Charsets.ISO_8859_1);
        boolean bl = isAndroid = null != userAgent && DownloadUtility.toLowerCase(userAgent).indexOf("android") >= 0;
        if (isAndroid) {
            int pos = foo.lastIndexOf(46);
            if (pos >= 0) {
                foo = foo.substring(0, pos) + DownloadUtility.toUpperCase(foo.substring(pos));
            }
        } else {
            appendTo.append("; filename*=UTF-8''").append(URLCoder.encode(fn));
        }
        appendTo.append("; filename=\"").append(foo).append('\"');
    }

    public static void appendFilenameParameter(String fileName, String baseCT, String userAgent, StringAllocator appendTo) {
        boolean isAndroid;
        if (null == fileName) {
            appendTo.append("; filename=\"").append(DEFAULT_FILENAME).append('\"');
            return;
        }
        String fn = fileName;
        if (null != baseCT && null == DownloadUtility.getFileExtension(fn)) {
            if (baseCT.regionMatches(true, 0, MIME_TEXT_PLAIN, 0, MIME_TEXT_PLAIN.length())) {
                fn = fn + ".txt";
            } else if (baseCT.regionMatches(true, 0, MIME_TEXT_HTML, 0, MIME_TEXT_HTML.length())) {
                fn = fn + ".html";
            }
        }
        fn = DownloadUtility.escapeBackslashAndQuote(fn);
        if (null != userAgent && new BrowserDetector(userAgent).isMSIE()) {
            appendTo.append("; filename=\"").append(Helper.encodeFilenameForIE(fn, Charsets.UTF_8)).append('\"');
            return;
        }
        String foo = new String(fn.getBytes(Charsets.UTF_8), Charsets.ISO_8859_1);
        boolean bl = isAndroid = null != userAgent && DownloadUtility.toLowerCase(userAgent).indexOf("android") >= 0;
        if (isAndroid) {
            int pos = foo.lastIndexOf(46);
            if (pos >= 0) {
                foo = foo.substring(0, pos) + DownloadUtility.toUpperCase(foo.substring(pos));
            }
        } else {
            appendTo.append("; filename*=UTF-8''").append(URLCoder.encode(fn));
        }
        appendTo.append("; filename=\"").append(foo).append('\"');
    }

    private static String escapeBackslashAndQuote(String str) {
        return PAT_QUOTE.matcher(PAT_BSLASH.matcher(str).replaceAll("\\\\\\\\")).replaceAll("\\\\\\\"");
    }

    private static CheckedDownload asAttachment(InputStream inputStream, String preparedFileName) {
        return new CheckedDownload("application/octet-stream", new StringAllocator(64).append("attachment; filename=\"").append(preparedFileName).append('\"').toString(), inputStream);
    }

    private static String getFileExtension(String fileName) {
        if (null == fileName) {
            return null;
        }
        int pos = fileName.lastIndexOf(46);
        if (pos <= 0 || pos >= fileName.length()) {
            return null;
        }
        return fileName.substring(pos);
    }

    private static String addFileExtension(String fileName, String ext) {
        if (null == fileName) {
            return null;
        }
        int pos = fileName.indexOf(46);
        if (-1 == pos) {
            return new StringAllocator(fileName).append('.').append(ext).toString();
        }
        return new StringAllocator(fileName.substring(0, pos)).append('.').append(ext).toString();
    }

    public static final String getSaveAsFileName(String fileName, boolean internetExplorer, String baseCT) {
        if (null == fileName) {
            return DEFAULT_FILENAME;
        }
        StringBuilder tmp = new StringBuilder(32);
        try {
            if (fileName.indexOf(32) >= 0) {
                tmp.append(Helper.encodeFilename(fileName.replaceAll(" ", "_"), "UTF-8", internetExplorer));
            } else {
                tmp.append(Helper.encodeFilename(fileName, "UTF-8", internetExplorer));
            }
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return fileName;
        }
        if (null != baseCT && null == DownloadUtility.getFileExtension(fileName)) {
            if (baseCT.regionMatches(true, 0, MIME_TEXT_PLAIN, 0, MIME_TEXT_PLAIN.length()) && !fileName.toLowerCase(Locale.US).endsWith(".txt")) {
                tmp.append(".txt");
            } else if (baseCT.regionMatches(true, 0, MIME_TEXT_HTML, 0, MIME_TEXT_HTML.length()) && !fileName.toLowerCase(Locale.US).endsWith(".html")) {
                tmp.append(".html");
            }
        }
        return tmp.toString();
    }

    private static String toLowerCase(CharSequence chars) {
        if (null == chars) {
            return null;
        }
        int length = chars.length();
        StringAllocator builder = new StringAllocator(length);
        for (int i = 0; i < length; ++i) {
            char c = chars.charAt(i);
            builder.append(c >= 'A' && c <= 'Z' ? (char)(c ^ 0x20) : c);
        }
        return builder.toString();
    }

    private static String toUpperCase(CharSequence chars) {
        if (null == chars) {
            return null;
        }
        int length = chars.length();
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = chars.charAt(i);
            builder.append(c >= 'a' && c <= 'z' ? (char)(c & 0x5F) : c);
        }
        return builder.toString();
    }

    public static final class CheckedDownload {
        private final String contentType;
        private final String contentDisposition;
        private final InputStream inputStream;

        CheckedDownload(String contentType, String contentDisposition, InputStream inputStream) {
            this.contentType = contentType;
            this.contentDisposition = contentDisposition;
            this.inputStream = inputStream;
        }

        public String getContentType() {
            return this.contentType;
        }

        public String getContentDisposition() {
            return this.contentDisposition;
        }

        public InputStream getInputStream() {
            return this.inputStream;
        }
    }
}

