/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax;

import java.io.File;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.io.FileCleaningTracker;
import org.apache.commons.io.FileDeleteStrategy;

final class DeleteOnExitFileCleaningTracker
extends FileCleaningTracker {
    private static final Object PRESENCE = new Object();
    final ReferenceQueue<Object> q = new ReferenceQueue();
    final Map<Tracker, Object> trackers = new ConcurrentHashMap<Tracker, Object>();
    final List<String> deleteFailures = new CopyOnWriteArrayList<String>();
    volatile boolean exitWhenFinished = false;
    private Thread reaper;
    private final boolean deleteOnExit;
    private volatile Thread shutdownHookThread;

    protected DeleteOnExitFileCleaningTracker(boolean deleteOnExit) {
        this.deleteOnExit = deleteOnExit;
        Thread shutdownHookThread = new Thread(new Runnable(){

            @Override
            public void run() {
                DeleteOnExitFileCleaningTracker.this.deleteAllTracked0();
            }
        });
        Runtime.getRuntime().addShutdownHook(shutdownHookThread);
        this.shutdownHookThread = shutdownHookThread;
    }

    public void track(File file, Object marker, FileDeleteStrategy deleteStrategy) {
        super.track(file, marker, deleteStrategy);
        if (this.deleteOnExit) {
            file.deleteOnExit();
        }
    }

    public void deleteAllTracked() {
        this.deleteAllTracked0();
        Thread shutdownHookThread = this.shutdownHookThread;
        if (!shutdownHookThread.isAlive()) {
            try {
                Runtime.getRuntime().removeShutdownHook(shutdownHookThread);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        this.shutdownHookThread = null;
    }

    void deleteAllTracked0() {
        Tracker tracker = (Tracker)this.q.poll();
        while (tracker != null) {
            this.trackers.remove(tracker);
            if (!tracker.delete()) {
                this.deleteFailures.add(tracker.getPath());
            }
            tracker.clear();
            tracker = (Tracker)this.q.poll();
        }
        this.exitWhenFinished();
    }

    public void track(String path, Object marker, FileDeleteStrategy deleteStrategy) {
        if (path == null) {
            throw new NullPointerException("The path must not be null");
        }
        this.addTracker(path, marker, deleteStrategy);
    }

    private synchronized void addTracker(String path, Object marker, FileDeleteStrategy deleteStrategy) {
        if (this.exitWhenFinished) {
            throw new IllegalStateException("No new trackers can be added once exitWhenFinished() is called");
        }
        if (this.reaper == null) {
            this.reaper = new Reaper();
            this.reaper.start();
        }
        this.trackers.put(new Tracker(path, deleteStrategy, marker, this.q), PRESENCE);
    }

    public int getTrackCount() {
        return this.trackers.size();
    }

    public List<String> getDeleteFailures() {
        return this.deleteFailures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void exitWhenFinished() {
        this.exitWhenFinished = true;
        if (this.reaper != null) {
            Thread thread = this.reaper;
            synchronized (thread) {
                this.reaper.interrupt();
            }
        }
    }

    private static final class Tracker
    extends PhantomReference<Object> {
        private final String path;
        private final FileDeleteStrategy deleteStrategy;

        Tracker(String path, FileDeleteStrategy deleteStrategy, Object marker, ReferenceQueue<? super Object> queue) {
            super(marker, queue);
            this.path = path;
            this.deleteStrategy = deleteStrategy == null ? FileDeleteStrategy.NORMAL : deleteStrategy;
        }

        public String getPath() {
            return this.path;
        }

        public boolean delete() {
            return this.deleteStrategy.deleteQuietly(new File(this.path));
        }
    }

    private final class Reaper
    extends Thread {
        Reaper() {
            super("File Reaper");
            this.setPriority(10);
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (!DeleteOnExitFileCleaningTracker.this.exitWhenFinished || DeleteOnExitFileCleaningTracker.this.trackers.size() > 0) {
                try {
                    Tracker tracker = (Tracker)DeleteOnExitFileCleaningTracker.this.q.remove();
                    DeleteOnExitFileCleaningTracker.this.trackers.remove(tracker);
                    if (!tracker.delete()) {
                        DeleteOnExitFileCleaningTracker.this.deleteFailures.add(tracker.getPath());
                    }
                    tracker.clear();
                }
                catch (InterruptedException e) {}
            }
        }
    }
}

