/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax;

import com.openexchange.ajax.DeleteOnExitFileCleaningTracker;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.writer.ResponseWriter;
import com.openexchange.configuration.ServerConfig;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.upload.UploadFile;
import com.openexchange.groupware.upload.impl.UploadEvent;
import com.openexchange.groupware.upload.impl.UploadException;
import com.openexchange.groupware.upload.impl.UploadFileImpl;
import com.openexchange.groupware.upload.impl.UploadListener;
import com.openexchange.groupware.upload.impl.UploadRegistry;
import com.openexchange.groupware.upload.impl.UploadUtility;
import com.openexchange.java.Charsets;
import com.openexchange.java.Streams;
import com.openexchange.java.StringAllocator;
import com.openexchange.log.ForceLog;
import com.openexchange.log.LogFactory;
import com.openexchange.log.LogProperties;
import com.openexchange.log.Props;
import com.openexchange.monitoring.MonitoringInfo;
import com.openexchange.session.Session;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.servlet.CountingHttpServletRequest;
import com.openexchange.tools.servlet.http.Tools;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.stream.UnsynchronizedByteArrayOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.httpclient.URI;
import org.apache.commons.io.FileCleaningTracker;
import org.apache.commons.logging.Log;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONValue;
import org.json.JSONWriter;

public abstract class AJAXServlet
extends HttpServlet
implements UploadRegistry {
    private static final long serialVersionUID = 718576864014891156L;
    private static final transient Log LOG;
    public static final String MODULE_TASK = "tasks";
    public static final String MODULE_ATTACHMENTS = "attachment";
    public static final String MODULE_CALENDAR = "calendar";
    public static final String MODULE_CONTACT = "contacts";
    public static final String MODULE_UNBOUND = "unbound";
    public static final String MODULE_MAIL = "mail";
    public static final String MODULE_PROJECT = "projects";
    public static final String MODULE_MESSAGING = "messaging";
    public static final String MODULE_INFOSTORE = "infostore";
    public static final String MODULE_SYSTEM = "system";
    public static final String ACTION_APPEND = "append";
    public static final String ACTION_AUTOSAVE = "autosave";
    public static final String ACTION_NEW = "new";
    public static final String ACTION_ADDFILE = "addfile";
    public static final String ACTION_EDIT = "edit";
    public static final String ACTION_CONFIG = "config";
    public static final String ACTION_UPLOAD = "upload";
    public static final String ACTION_UPDATE = "update";
    public static final String ACTION_ERROR = "error";
    public static final String ACTION_UPDATES = "updates";
    public static final String ACTION_DELETE = "delete";
    public static final String ACTION_CONFIRM = "confirm";
    public static final String ACTION_LIST = "list";
    public static final String ACTION_VALIDATE = "validate";
    public static final String ACTION_RANGE = "range";
    public static final String ACTION_VIEW = "view";
    public static final String ACTION_SEARCH = "search";
    public static final String ACTION_NEW_APPOINTMENTS = "newappointments";
    public static final String ACTION_SEND = "send";
    public static final String ACTION_GET = "get";
    public static final String ACTION_GET_STRUCTURE = "get_structure";
    public static final String ACTION_IMAGE = "image";
    public static final String ACTION_REPLY = "reply";
    public static final String ACTION_REPLYALL = "replyall";
    public static final String ACTION_FORWARD = "forward";
    public static final String ACTION_MATTACH = "attachment";
    public static final String ACTION_ZIP_MATTACH = "zip_attachments";
    public static final String ACTION_ZIP_MESSAGES = "zip_messages";
    public static final String ACTION_MAIL_RECEIPT_ACK = "receipt_ack";
    public static final String ACTION_NEW_MSGS = "newmsgs";
    public static final String ACTION_COUNT = "count";
    public static final String ACTION_ROOT = "root";
    public static final String ACTION_ALL = "all";
    public static final String ACTION_HAS = "has";
    public static final String ACTION_FREEBUSY = "freebusy";
    protected static final String ACTION_GROUPS = "groups";
    public static final String ACTION_VERSIONS = "versions";
    public static final String ACTION_PATH = "path";
    public static final String ACTION_DOCUMENT = "document";
    public static final String ACTION_DETACH = "detach";
    public static final String ACTION_ATTACH = "attach";
    public static final String ACTION_REVERT = "revert";
    public static final String ACTION_COPY = "copy";
    public static final String ACTION_LOCK = "lock";
    public static final String ACTION_UNLOCK = "unlock";
    public static final String ACTION_SAVE_AS = "saveAs";
    public static final String ACTION_LOGIN = "login";
    public static final String ACTION_OAUTH = "oauth";
    public static final String ACTION_STORE = "store";
    public static final String ACTION_LOGOUT = "logout";
    public static final String ACTION_REDIRECT = "redirect";
    public static final String ACTION_REDEEM = "redeem";
    public static final String ACTION_AUTOLOGIN = "autologin";
    public static final String ACTION_SAVE_VERSIT = "saveVersit";
    public static final String ACTION_CLEAR = "clear";
    public static final String ACTION_KEEPALIVE = "keepalive";
    public static final String ACTION_RESOLVE_UID = "resolveuid";
    public static final String ACTION_IMPORT = "import";
    public static final String ACTION_REFRESH = "refresh";
    public static final String ACTION_REFRESH_SECRET = "refreshSecret";
    public static final String ACTION_TERMSEARCH = "advancedSearch";
    public static final String PARAMETER_FROM = "from";
    public static final String PARAMETER_TO = "to";
    public static final String PARAMETER_START = "start";
    public static final String PARAMETER_END = "end";
    public static final String PARAMETER_ID = "id";
    public static final String PARAMETER_ATTACHEDID = "attached";
    public static final String PARAMETER_SESSION = "session";
    public static final String PARAMETER_DATA = "data";
    public static final String PARAMETER_FOLDERID = "folder";
    public static final String PARAMETER_INFOLDER = "folder";
    public static final String PARAMETER_MODULE = "module";
    public static final String PARAMETER_MAIL = "mail";
    public static final String PARAMETER_SORT = "sort";
    public static final String PARAMETER_ORDER = "order";
    public static final String PARAMETER_RECURRENCE_MASTER = "recurrence_master";
    public static final String LEFT_HAND_LIMIT = "left_hand_limit";
    public static final String RIGHT_HAND_LIMIT = "right_hand_limit";
    public static final String PARAMETER_HARDDELETE = "harddelete";
    public static final String PARAMETER_ACTION = "action";
    public static final String PARAMETER_COLUMNS = "columns";
    public static final String PARAMETER_SEARCHPATTERN = "pattern";
    public static final String PARAMETER_TIMESTAMP = "timestamp";
    public static final String PARAMETER_TIMEZONE = "timezone";
    public static final String PARAMETER_VERSION = "version";
    public static final String UPLOAD_FORMFIELD_MAIL = "json_0";
    public static final String PARAMETER_IGNORE = "ignore";
    public static final String PARAMETER_ALL = "all";
    public static final String PARAMETER_ATTACHMENT = "attachment";
    public static final String PARAMETER_JSON = "json";
    public static final String PARAMETER_FILE = "file";
    public static final String PARAMETER_CONTENT_TYPE = "content_type";
    public static final String PARAMETER_LIMIT = "limit";
    public static final String PARAMETER_TYPE = "type";
    public static final String PARAMETER_USER = "user";
    public static final String PARAMETER_USER_ID = "user_id";
    public static final String PARAMETER_TEMPLATE = "template";
    public static final String PARAMETER_UID = "uid";
    public static final String PARAMETER_SHOW_PRIVATE_APPOINTMENTS = "showPrivate";
    public static final String PARAMETER_USERNAME = "name";
    public static final String PARAMETER_PASSWORD = "password";
    public static final String PARAMETER_FILTER = "filter";
    public static final String PARAMETER_COLLATION = "collation";
    public static final String CONTENTTYPE_JAVASCRIPT = "text/javascript; charset=UTF-8";
    public static final String CONTENTTYPE_HTML = "text/html; charset=UTF-8";
    private static final String STR_EMPTY = "";
    private static final String STR_ERROR = "error";
    private static final String STR_ERROR_PARAMS = "error_params";
    public static final String JS_FRAGMENT = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\"><html><head><META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"><script type=\"text/javascript\">(parent.callback_**action** || window.opener && window.opener.callback_**action**)(**json**)</script></head></html>";
    public static final String SAVE_AS_TYPE = "application/octet-stream";
    protected static final String _doGet = "doGet";
    protected static final String _doPut = "doPut";
    protected static final String RESPONSE_ERROR = "Error while writing response object.";
    private static final AtomicLong REQUEST_NUMBER;
    private static final boolean BYTE_BASED_READING = true;
    private static final int BUF_SIZE = 2048;
    private static final int SB_SIZE = 8192;
    private static final URLCodec URL_CODEC;
    protected static final BitSet WWW_FORM_URL;
    protected static final BitSet WWW_FORM_URL_ANCHOR;
    private static final Pattern PATTERN_CRLF;
    private static volatile ServletFileUpload servletFileUpload;
    private static final int SIZE_THRESHOLD = 0x100000;
    private static volatile DeleteOnExitFileCleaningTracker tracker;
    private static final Set<String> UPLOAD_ACTIONS;

    protected AJAXServlet() {
    }

    protected static Locale localeFrom(ServerSession session) {
        if (null == session) {
            return Locale.US;
        }
        User user = session.getUser();
        if (null != user) {
            return user.getLocale();
        }
        return UserStorage.getStorageUser(session.getUserId(), session.getContextId()).getLocale();
    }

    protected static Locale localeFrom(Session session) {
        if (null == session) {
            return Locale.US;
        }
        if (session instanceof ServerSession) {
            return ((ServerSession)session).getUser().getLocale();
        }
        return UserStorage.getStorageUser(session.getUserId(), session.getContextId()).getLocale();
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.incrementRequests();
        Props props = LogProperties.getLogProperties();
        props.put(LogProperties.Name.AJAX_REQUEST_NUMBER, (Object)ForceLog.valueOf((Object)Long.toString(REQUEST_NUMBER.incrementAndGet())));
        try {
            req.getSession(true);
            resp.setStatus(200);
            resp.setContentType(CONTENTTYPE_JAVASCRIPT);
            super.service((HttpServletRequest)new CountingHttpServletRequest(req), resp);
        }
        catch (RuntimeException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            ServletException se = new ServletException(e.getMessage());
            se.initCause((Throwable)e);
            throw se;
        }
        finally {
            this.decrementRequests();
            props.remove(LogProperties.Name.AJAX_REQUEST_NUMBER);
        }
    }

    protected void incrementRequests() {
        MonitoringInfo.incrementNumberOfConnections((int)1);
    }

    protected void decrementRequests() {
        MonitoringInfo.decrementNumberOfConnections((int)1);
    }

    public static boolean containsParameter(HttpServletRequest req, String name) {
        return req.getParameter(name) != null;
    }

    private static int getMaxBodySize() {
        try {
            return ServerConfig.getInt(ServerConfig.Property.MAX_BODY_SIZE);
        }
        catch (OXException e) {
            return Integer.parseInt(ServerConfig.Property.MAX_BODY_SIZE.getDefaultValue());
        }
    }

    public static Reader getReaderFor(HttpServletRequest req) throws IOException {
        String charEnc = req.getCharacterEncoding();
        if (charEnc == null) {
            charEnc = ServerConfig.getProperty(ServerConfig.Property.DefaultEncoding);
        }
        return new BufferedReader(new InputStreamReader((InputStream)req.getInputStream(), Charsets.forName((String)charEnc)), 2048);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONValue getBodyAsJsonValue(HttpServletRequest req) throws IOException, JSONException {
        JSONValue jSONValue;
        String charEnc = req.getCharacterEncoding();
        if (charEnc == null) {
            charEnc = ServerConfig.getProperty(ServerConfig.Property.DefaultEncoding);
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)req.getInputStream(), Charsets.forName((String)charEnc)), 2048);
            jSONValue = JSONObject.parse((Reader)reader);
        }
        catch (UnsupportedCharsetException e) {
            JSONObject jSONObject;
            try {
                LOG.error((Object)"Unsupported encoding in request", (Throwable)e);
                jSONObject = new JSONObject();
            }
            catch (Throwable throwable) {
                Streams.close(reader);
                throw throwable;
            }
            Streams.close((Closeable)reader);
            return jSONObject;
        }
        Streams.close((Closeable)reader);
        return jSONValue;
    }

    public static String getBody(HttpServletRequest req) throws IOException {
        return AJAXServlet.byteBasedBodyReading(req);
    }

    public static String readFrom(Reader reader) throws IOException {
        if (null == reader) {
            return null;
        }
        int buflen = 2048;
        char[] cbuf = new char[2048];
        StringAllocator builder = new StringAllocator(8192);
        int maxBodySize = AJAXServlet.getMaxBodySize();
        if (maxBodySize > 0) {
            int count = 0;
            int read = reader.read(cbuf, 0, 2048);
            while (read > 0) {
                if ((count += read) > maxBodySize) {
                    throw new IOException("Max. body size (" + UploadUtility.getSize(maxBodySize, 2, false, true) + ") exceeded.");
                }
                builder.append(cbuf, 0, read);
                read = reader.read(cbuf, 0, 2048);
            }
        } else {
            int read = reader.read(cbuf, 0, 2048);
            while (read > 0) {
                builder.append(cbuf, 0, read);
                read = reader.read(cbuf, 0, 2048);
            }
        }
        if (0 == builder.length()) {
            return null;
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String decoderBasedBodyReading(HttpServletRequest req) throws IOException {
        String charEnc = req.getCharacterEncoding();
        if (charEnc == null) {
            charEnc = ServerConfig.getProperty(ServerConfig.Property.DefaultEncoding);
        }
        InputStreamReader reader = new InputStreamReader((InputStream)req.getInputStream(), Charsets.forName((String)charEnc));
        try {
            int buflen = 2048;
            char[] cbuf = new char[2048];
            StringAllocator builder = new StringAllocator(8192);
            int maxBodySize = AJAXServlet.getMaxBodySize();
            if (maxBodySize > 0) {
                int count = 0;
                int read = ((Reader)reader).read(cbuf, 0, 2048);
                while (read > 0) {
                    if ((count += read) > maxBodySize) {
                        throw new IOException("Max. body size (" + UploadUtility.getSize(maxBodySize, 2, false, true) + ") exceeded.");
                    }
                    builder.append(cbuf, 0, read);
                    read = ((Reader)reader).read(cbuf, 0, 2048);
                }
            } else {
                int read = ((Reader)reader).read(cbuf, 0, 2048);
                while (read > 0) {
                    builder.append(cbuf, 0, read);
                    read = ((Reader)reader).read(cbuf, 0, 2048);
                }
            }
            String string = builder.toString();
            return string;
        }
        catch (UnsupportedCharsetException e) {
            LOG.error((Object)"Unsupported encoding in request", (Throwable)e);
            String string = STR_EMPTY;
            return string;
        }
        finally {
            Streams.close((Closeable)reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String byteBasedBodyReading(HttpServletRequest req) throws IOException {
        ServletInputStream inputStream = req.getInputStream();
        try {
            int buflen = 2048;
            byte[] buf = new byte[2048];
            UnsynchronizedByteArrayOutputStream baos = new UnsynchronizedByteArrayOutputStream(8192);
            int maxBodySize = AJAXServlet.getMaxBodySize();
            if (maxBodySize > 0) {
                int count = 0;
                int read = inputStream.read(buf, 0, 2048);
                while (read > 0) {
                    if ((count += read) > maxBodySize) {
                        throw new IOException("Max. body size (" + UploadUtility.getSize(maxBodySize, 2, false, true) + ") exceeded.");
                    }
                    baos.write(buf, 0, read);
                    read = inputStream.read(buf, 0, 2048);
                }
            } else {
                int read = inputStream.read(buf, 0, 2048);
                while (read > 0) {
                    baos.write(buf, 0, read);
                    read = inputStream.read(buf, 0, 2048);
                }
            }
            try {
                String charEnc = req.getCharacterEncoding();
                if (charEnc == null) {
                    charEnc = ServerConfig.getProperty(ServerConfig.Property.DefaultEncoding);
                }
                String string = new String(baos.toByteArray(), Charsets.forName((String)charEnc));
                return string;
            }
            catch (UnsupportedCharsetException e) {
                LOG.error((Object)"Unsupported encoding in request", (Throwable)e);
                String string = new String(baos.toByteArray(), Charsets.ISO_8859_1);
                Streams.close((Closeable)inputStream);
                return string;
            }
        }
        finally {
            Streams.close((Closeable)inputStream);
        }
    }

    public static String getServletSpecificURI(HttpServletRequest req) {
        String path;
        String uri;
        int pos;
        String characterEncoding = req.getCharacterEncoding();
        if (null == characterEncoding && null == (characterEncoding = ServerConfig.getProperty(ServerConfig.Property.DefaultEncoding))) {
            characterEncoding = "ISO-8859-1";
        }
        if ((pos = (uri = AJAXServlet.decodeUrl(req.getRequestURI(), characterEncoding)).indexOf(path = new StringAllocator(req.getContextPath()).append(req.getServletPath()).toString())) >= 0) {
            uri = uri.substring(pos + path.length());
        }
        return uri;
    }

    public static String encodeUrl(String s) {
        return AJAXServlet.encodeUrl(s, false);
    }

    public static String encodeUrl(String s, boolean forAnchor) {
        if (AJAXServlet.isEmpty(s)) {
            return s;
        }
        try {
            String ascii = forAnchor ? Charsets.toAsciiString((byte[])URLCodec.encodeUrl((BitSet)WWW_FORM_URL_ANCHOR, (byte[])s.getBytes(Charsets.ISO_8859_1))) : Charsets.toAsciiString((byte[])URLCodec.encodeUrl((BitSet)WWW_FORM_URL, (byte[])s.getBytes(Charsets.ISO_8859_1)));
            if (ascii.indexOf(10) < 0 && ascii.indexOf("%0") < 0) {
                return ascii;
            }
            return PATTERN_CRLF.matcher(ascii).replaceAll(STR_EMPTY);
        }
        catch (RuntimeException e) {
            LOG.error((Object)"A runtime error occurred.", (Throwable)e);
            return s;
        }
    }

    public static String sanitizeParam(String s) {
        if (AJAXServlet.isEmpty(s)) {
            return s;
        }
        try {
            if (s.indexOf(10) < 0 && s.indexOf("%0") < 0) {
                return s;
            }
            return PATTERN_CRLF.matcher(s).replaceAll(STR_EMPTY);
        }
        catch (RuntimeException e) {
            LOG.error((Object)"A runtime error occurred.", (Throwable)e);
            return s;
        }
    }

    public static String decodeUrl(String s, String charset) {
        try {
            return AJAXServlet.isEmpty(s) ? s : (AJAXServlet.isEmpty(charset) ? URL_CODEC.decode(s) : URL_CODEC.decode(s, charset));
        }
        catch (DecoderException e) {
            return s;
        }
        catch (UnsupportedEncodingException e) {
            return s;
        }
    }

    protected static String getAction(HttpServletRequest req) throws OXException {
        String action = req.getParameter(PARAMETER_ACTION);
        if (action == null) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create(PARAMETER_ACTION);
        }
        return action;
    }

    @Deprecated
    protected static void sendErrorAsJS(HttpServletResponse resp, String errorMessage) throws IOException, ServletException {
        resp.setStatus(200);
        resp.setContentType(CONTENTTYPE_JAVASCRIPT);
        try {
            PrintWriter w = resp.getWriter();
            JSONWriter jw = new JSONWriter((Writer)w);
            jw.object();
            jw.key("error");
            jw.value((Object)errorMessage);
            jw.endObject();
            w.flush();
        }
        catch (JSONException e1) {
            ServletException se = new ServletException(e1.getMessage(), (Throwable)e1);
            se.initCause((Throwable)e1);
            throw se;
        }
    }

    protected static void sendError(HttpServletResponse resp) throws IOException {
        resp.sendError(500);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    protected static void sendErrorAsJSHTML(HttpServletResponse res, String error, String action) throws IOException {
        res.setContentType("text/html");
        PrintWriter w = null;
        try {
            w = res.getWriter();
            JSONObject obj = new JSONObject();
            obj.put("error", (Object)error);
            obj.put(STR_ERROR_PARAMS, Collections.emptyList());
            w.write(AJAXServlet.substituteJS(obj.toString(), action));
        }
        catch (JSONException e) {
            LOG.error((Object)e);
        }
        finally {
            AJAXServlet.close(w);
        }
    }

    protected void unknownColumn(HttpServletResponse res, String parameter, String columnId, boolean html, String action) throws IOException, ServletException {
        String msg = "Unknown column in " + parameter + " :" + columnId;
        if (html) {
            AJAXServlet.sendErrorAsJSHTML(res, msg, action);
            return;
        }
        AJAXServlet.sendErrorAsJS(res, msg);
    }

    protected void invalidParameter(HttpServletResponse res, String parameter, String value, boolean html, String action) throws IOException, ServletException {
        String msg = "Invalid Parameter " + parameter + " :" + value;
        if (html) {
            AJAXServlet.sendErrorAsJSHTML(res, msg, action);
            return;
        }
        AJAXServlet.sendErrorAsJS(res, msg);
    }

    protected void missingParameter(String parameter, HttpServletResponse res, boolean html, String action) throws IOException, ServletException {
        String msg = "Missing Parameter: " + parameter;
        if (html) {
            AJAXServlet.sendErrorAsJSHTML(res, msg, action);
            return;
        }
        AJAXServlet.sendErrorAsJS(res, msg);
    }

    protected void unknownAction(String method, String action, HttpServletResponse res, boolean html) throws IOException, ServletException {
        String msg = "The action " + action + " isn't even specified yet. At least not for the method: " + method;
        if (html) {
            AJAXServlet.sendErrorAsJSHTML(res, msg, action);
            return;
        }
        AJAXServlet.sendErrorAsJS(res, msg);
    }

    public static String substituteJS(String json, String action) {
        return JS_FRAGMENT.replace("**json**", json.replaceAll(Pattern.quote("</"), "<\\/")).replace("**action**", action);
    }

    @Override
    public UploadEvent processUpload(HttpServletRequest req) throws OXException {
        return AJAXServlet.processUploadStatic(req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ServletFileUpload getFileUploadBase() {
        ServletFileUpload tmp = servletFileUpload;
        if (null != tmp) return tmp;
        Class<AJAXServlet> clazz = AJAXServlet.class;
        synchronized (AJAXServlet.class) {
            tmp = servletFileUpload;
            if (null != tmp) return tmp;
            servletFileUpload = AJAXServlet.newFileUploadBase();
            return servletFileUpload;
        }
    }

    public static void exitTracker() {
        servletFileUpload = null;
        DeleteOnExitFileCleaningTracker tracker = AJAXServlet.tracker;
        if (null != tracker) {
            tracker.deleteAllTracked();
            AJAXServlet.tracker = null;
        }
    }

    private static ServletFileUpload newFileUploadBase() {
        DiskFileItemFactory factory = new DiskFileItemFactory();
        factory.setSizeThreshold(0x100000);
        factory.setRepository(new File(ServerConfig.getProperty(ServerConfig.Property.UploadDirectory)));
        DeleteOnExitFileCleaningTracker tracker = new DeleteOnExitFileCleaningTracker(false);
        factory.setFileCleaningTracker((FileCleaningTracker)tracker);
        AJAXServlet.tracker = tracker;
        ServletFileUpload sfu = new ServletFileUpload((FileItemFactory)factory);
        sfu.setSizeMax(-1L);
        return sfu;
    }

    public static final UploadEvent processUploadStatic(HttpServletRequest req) throws OXException {
        List items;
        String action;
        if (!Tools.isMultipartContent(req)) {
            throw UploadException.UploadCode.NO_MULTIPART_CONTENT.create();
        }
        try {
            action = AJAXServlet.getAction(req);
        }
        catch (OXException e) {
            throw UploadException.UploadCode.UPLOAD_FAILED.create(e, new Object[0]);
        }
        if (!AJAXServlet.mayUpload(action)) {
            throw UploadException.UploadCode.UNKNOWN_ACTION_VALUE.create(action);
        }
        ServletFileUpload upload = AJAXServlet.getFileUploadBase();
        try {
            List tmp;
            items = tmp = upload.parseRequest(req);
        }
        catch (FileUploadException e) {
            String message;
            Throwable cause = e.getCause();
            if (cause instanceof IOException && (message = cause.getMessage()).startsWith("Max. byte count of ")) {
                int pos = message.indexOf(" exceeded", 20);
                String limit = message.substring(19, pos);
                throw UploadException.UploadCode.MAX_UPLOAD_SIZE_EXCEEDED_UNKNOWN.create(cause, limit);
            }
            throw UploadException.UploadCode.UPLOAD_FAILED.create(e, null == cause ? e.getMessage() : cause.getMessage());
        }
        UploadEvent uploadEvent = new UploadEvent();
        uploadEvent.setAction(action);
        uploadEvent.setAffiliationId(1);
        String rce = req.getCharacterEncoding();
        String charEnc = null == rce ? ServerConfig.getProperty(ServerConfig.Property.DefaultEncoding) : rce;
        for (FileItem fileItem : items) {
            if (fileItem.isFormField()) {
                try {
                    uploadEvent.addFormField(fileItem.getFieldName(), fileItem.getString(charEnc));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw UploadException.UploadCode.UPLOAD_FAILED.create(e, action);
                }
            }
            if (fileItem.getSize() <= 0L && AJAXServlet.isEmpty(fileItem.getName())) continue;
            try {
                uploadEvent.addUploadFile(AJAXServlet.processUploadedFile(fileItem, ServerConfig.getProperty(ServerConfig.Property.UploadDirectory)));
            }
            catch (Exception e) {
                throw UploadException.UploadCode.UPLOAD_FAILED.create(e, action);
            }
        }
        if (uploadEvent.getAffiliationId() < 0) {
            throw UploadException.UploadCode.MISSING_AFFILIATION_ID.create(action);
        }
        return uploadEvent;
    }

    protected static boolean mayUpload(String action) {
        return UPLOAD_ACTIONS.contains(action) || Arrays.asList("CSV", "VCARD", "ICAL", "OUTLOOK_CSV").contains(action);
    }

    private static boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < len; ++i) {
            isWhitespace = Character.isWhitespace(string.charAt(i));
        }
        return isWhitespace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final UploadFile processUploadedFile(FileItem item, String uploadDir) throws Exception {
        try {
            UploadFileImpl retval = new UploadFileImpl();
            retval.setFieldName(item.getFieldName());
            retval.setFileName(item.getName());
            retval.setContentType(item.getContentType());
            retval.setSize(item.getSize());
            File tmpFile = File.createTempFile("openexchange", null, new File(uploadDir));
            tmpFile.deleteOnExit();
            item.write(tmpFile);
            retval.setTmpFile(tmpFile);
            UploadFileImpl uploadFileImpl = retval;
            return uploadFileImpl;
        }
        finally {
            item.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireUploadEvent(UploadEvent uploadEvent, Collection<UploadListener> uploadListeners) throws OXException {
        try {
            for (UploadListener uploadListener : uploadListeners) {
                try {
                    uploadListener.action(uploadEvent);
                }
                catch (OXException e) {
                    LOG.error((Object)new StringAllocator(64).append("Failed upload listener: ").append(uploadListener.getClass()), (Throwable)e);
                }
            }
        }
        finally {
            uploadEvent.cleanUp();
        }
    }

    public static void startResponse(JSONWriter jsonwriter) throws JSONException {
        jsonwriter.object();
        jsonwriter.key(PARAMETER_DATA);
    }

    public static void endResponse(JSONWriter jsonwriter, Date timestamp, String error) throws JSONException {
        if (timestamp != null) {
            jsonwriter.key(PARAMETER_TIMESTAMP);
            jsonwriter.value(timestamp.getTime());
        }
        if (error != null) {
            jsonwriter.key("error");
            jsonwriter.value((Object)error);
            jsonwriter.key(STR_ERROR_PARAMS);
            jsonwriter.value((Object)new JSONArray());
        }
        jsonwriter.endObject();
    }

    protected boolean checkRequired(HttpServletRequest req, HttpServletResponse res, boolean html, String action, String ... parameters) throws IOException, ServletException {
        if (html) {
            res.setContentType(CONTENTTYPE_HTML);
        }
        for (String param : parameters) {
            if (req.getParameter(param) != null) continue;
            this.missingParameter(param, res, html, action);
            return false;
        }
        return true;
    }

    protected static void close(Writer w) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)new StringAllocator("Called close() with writer").append(w.toString()));
        }
    }

    protected void writeResponse(Response response, HttpServletResponse servletResponse, Session optSession) throws IOException {
        servletResponse.setContentType(CONTENTTYPE_JAVASCRIPT);
        try {
            ResponseWriter.write(response, servletResponse.getWriter(), AJAXServlet.localeFrom(optSession));
        }
        catch (JSONException e) {
            this.log(RESPONSE_ERROR, e);
            AJAXServlet.sendError(servletResponse);
        }
    }

    protected final boolean isIE(HttpServletRequest req) {
        return req.getHeader("User-Agent").contains("MSIE");
    }

    protected final boolean isIE7(HttpServletRequest req) {
        return req.getHeader("User-Agent").contains("MSIE 7");
    }

    public static final String getModuleString(int module, int objectId) {
        String moduleStr = null;
        switch (module) {
            case 1: {
                moduleStr = MODULE_TASK;
                break;
            }
            case 3: {
                moduleStr = MODULE_CONTACT;
                break;
            }
            case 2: {
                moduleStr = MODULE_CALENDAR;
                break;
            }
            case 4: {
                moduleStr = MODULE_UNBOUND;
                break;
            }
            case 7: {
                moduleStr = "mail";
                break;
            }
            case 6: {
                moduleStr = MODULE_PROJECT;
                break;
            }
            case 8: {
                moduleStr = MODULE_INFOSTORE;
                break;
            }
            case 5: {
                if (objectId == 8) {
                    moduleStr = MODULE_PROJECT;
                    break;
                }
                if (objectId == 9) {
                    moduleStr = MODULE_INFOSTORE;
                    break;
                }
                moduleStr = MODULE_SYSTEM;
                break;
            }
            case 13: {
                moduleStr = MODULE_MESSAGING;
                break;
            }
            default: {
                moduleStr = STR_EMPTY;
            }
        }
        return moduleStr;
    }

    public static final int getModuleInteger(String moduleStr) {
        int module = MODULE_TASK.equalsIgnoreCase(moduleStr) ? 1 : (MODULE_CONTACT.equalsIgnoreCase(moduleStr) ? 3 : (MODULE_CALENDAR.equalsIgnoreCase(moduleStr) ? 2 : (MODULE_UNBOUND.equalsIgnoreCase(moduleStr) ? 4 : ("mail".equalsIgnoreCase(moduleStr) ? 7 : (MODULE_PROJECT.equalsIgnoreCase(moduleStr) ? 6 : (MODULE_INFOSTORE.equalsIgnoreCase(moduleStr) ? 8 : -1))))));
        return module;
    }

    static {
        int i;
        LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(AJAXServlet.class));
        REQUEST_NUMBER = new AtomicLong(0L);
        URL_CODEC = new URLCodec("ISO-8859-1");
        BitSet bitSet = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            bitSet.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            bitSet.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            bitSet.set(i);
        }
        bitSet.set(45);
        bitSet.set(95);
        bitSet.set(46);
        bitSet.set(42);
        bitSet.set(32);
        WWW_FORM_URL = bitSet;
        WWW_FORM_URL_ANCHOR = URIExtended.URI_REFERENCE;
        PATTERN_CRLF = Pattern.compile("\r?\n|(?:%0[aA])?%0[dD]");
        UPLOAD_ACTIONS = new HashSet<String>(Arrays.asList(ACTION_NEW, ACTION_ADDFILE, ACTION_UPLOAD, ACTION_APPEND, ACTION_UPDATE, ACTION_ATTACH, ACTION_COPY, ACTION_IMPORT));
    }

    private static final class URIExtended
    extends URI {
        public static BitSet URI_REFERENCE = URI_reference;

        private URIExtended() {
        }
    }
}

