/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.java;

import com.openexchange.java.Autoboxing;
import com.openexchange.java.Charsets;
import com.openexchange.java.StringAllocator;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.regex.Pattern;

public class Strings {
    private static final Pattern P_SPLIT_COMMA = Pattern.compile("\\s*,\\s*");
    private static final Pattern P_SPLIT_CRLF = Pattern.compile("\r?\n");
    private static final Pattern P_SPLIT_WHITESPACE = Pattern.compile("\\s+");
    private static final CharsetDecoder UTF8_CHARSET_DECODER;

    private Strings() {
    }

    public static byte[] toAsciiBytes(CharSequence cs) {
        return Charsets.toAsciiBytes(cs);
    }

    public static byte[] toAsciiBytes(String str) {
        return Charsets.toAsciiBytes(str);
    }

    public static void writeAsciiBytes(String str, OutputStream out) throws IOException {
        Charsets.writeAsciiBytes(str, out);
    }

    public static String[] splitByComma(String s) {
        if (null == s) {
            return null;
        }
        return P_SPLIT_COMMA.split(s, 0);
    }

    public static String[] splitByCRLF(String s) {
        if (null == s) {
            return null;
        }
        return P_SPLIT_CRLF.split(s, 0);
    }

    public static String[] splitByWhitespaces(String s) {
        if (null == s) {
            return null;
        }
        return P_SPLIT_WHITESPACE.split(s, 0);
    }

    public static String quoteReplacement(String s) {
        if (Strings.isEmpty(s) || s.indexOf(92) == -1 && s.indexOf(36) == -1) {
            return s;
        }
        int length = s.length();
        StringAllocator sb = new StringAllocator(length << 1);
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                sb.append('\\');
                sb.append('\\');
                continue;
            }
            if (c == '$') {
                sb.append('\\');
                sb.append('$');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < len; ++i) {
            isWhitespace = Character.isWhitespace(string.charAt(i));
        }
        return isWhitespace;
    }

    public static String fixCharsetProblem(String s) {
        if (Strings.isEmpty(s)) {
            return s;
        }
        try {
            byte[] bytes = s.getBytes(Charsets.ISO_8859_1);
            if (Strings.isUTF8Bytes(bytes)) {
                return new String(bytes, Charsets.UTF_8);
            }
            return s;
        }
        catch (UnsupportedCharsetException e) {
            return s;
        }
    }

    public static boolean isUTF8Bytes(byte[] bytes) {
        try {
            UTF8_CHARSET_DECODER.decode(ByteBuffer.wrap(bytes));
            return true;
        }
        catch (CharacterCodingException e) {
            return false;
        }
    }

    public static String join(Collection<? extends Object> coll, String connector) {
        if (coll == null) {
            return null;
        }
        if (coll.size() == 0) {
            return "";
        }
        StringAllocator builder = new StringAllocator();
        for (Object object : coll) {
            if (object == null) {
                builder.append("null");
            } else {
                builder.append(object.toString());
            }
            builder.append(connector);
        }
        return builder.substring(0, builder.length() - connector.length());
    }

    public static <T> String join(T[] arr, String connector) {
        return Strings.join(Arrays.asList(arr), connector);
    }

    public static String join(int[] arr, String connector) {
        LinkedList<Integer> list = new LinkedList<Integer>();
        for (int i : arr) {
            list.add(Autoboxing.I(i));
        }
        return Strings.join(list, connector);
    }

    public static String join(byte[] arr, String connector) {
        LinkedList<Byte> list = new LinkedList<Byte>();
        byte[] arr$ = arr;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Byte i = arr$[i$];
            list.add(i);
        }
        return Strings.join(list, connector);
    }

    public static String trimBOM(String str) {
        byte[][] byteOrderMarks = new byte[][]{{0, 0, -2, -1}, {-1, -2, 0, 0}, {-17, -69, -65}, {-2, -1}, {-2, -1}};
        byte[] bytes = str.getBytes();
        for (byte[] bom : byteOrderMarks) {
            String pattern;
            if (bom.length > bytes.length || !str.startsWith(pattern = new String(bom))) continue;
            int bomLen = new String(bom).getBytes().length;
            int len = bytes.length - bomLen;
            byte[] trimmed = new byte[len];
            for (int i = 0; i < len; ++i) {
                trimmed[i] = bytes[i + bomLen];
            }
            return new String(trimmed);
        }
        return str;
    }

    public static String abbreviate(String str, int maxWidth) {
        return Strings.abbreviate(str, 0, maxWidth);
    }

    public static String abbreviate(String str, int offset, int maxWidth) {
        if (str == null) {
            return null;
        }
        if (maxWidth < 4) {
            throw new IllegalArgumentException("Minimum abbreviation width is 4");
        }
        if (str.length() <= maxWidth) {
            return str;
        }
        int off = offset;
        if (off > str.length()) {
            off = str.length();
        }
        if (str.length() - off < maxWidth - 3) {
            off = str.length() - (maxWidth - 3);
        }
        if (off <= 4) {
            return str.substring(0, maxWidth - 3) + "...";
        }
        if (maxWidth < 7) {
            throw new IllegalArgumentException("Minimum abbreviation width with offset is 7");
        }
        if (off + (maxWidth - 3) < str.length()) {
            return "..." + Strings.abbreviate(str.substring(off), maxWidth - 3);
        }
        return "..." + str.substring(str.length() - (maxWidth - 3));
    }

    static {
        CharsetDecoder utf8Decoder = Charsets.UTF_8.newDecoder();
        utf8Decoder.onMalformedInput(CodingErrorAction.REPORT);
        utf8Decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        UTF8_CHARSET_DECODER = utf8Decoder;
    }
}

