/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.java;

public final class ClassLoaders {
    private static ThreadLocal<ClassLoaderModifier> MODIFIER = new ThreadLocal();

    private ClassLoaders() {
    }

    public static void setClassLoader(Class<?> bundleClass) {
        if (null == bundleClass) {
            return;
        }
        ClassLoaderModifier classLoaderModifier = MODIFIER.get();
        if (null != classLoaderModifier) {
            throw new IllegalStateException("Current thread's class loader has already been modified (and not yet restored): " + Thread.currentThread().getName());
        }
        classLoaderModifier = new ClassLoaderModifier();
        classLoaderModifier.setClassLoader(bundleClass);
        MODIFIER.set(classLoaderModifier);
    }

    public static void restoreClassLoader() {
        ClassLoaderModifier classLoaderModifier = MODIFIER.get();
        if (null != classLoaderModifier) {
            classLoaderModifier.restoreClassLoader();
            MODIFIER.set(null);
        }
    }

    public static final class ClassLoaderModifier {
        private volatile ClassLoader classLoader;

        public void setClassLoader(Class<?> clazz) {
            ClassLoader ccl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(clazz.getClassLoader());
            this.classLoader = ccl;
        }

        public void restoreClassLoader() {
            ClassLoader ccl = this.classLoader;
            if (null != ccl) {
                Thread.currentThread().setContextClassLoader(ccl);
            }
        }
    }
}

