/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.server;

import com.openexchange.classloader.osgi.DynamicClassLoaderActivator;
import com.openexchange.exception.internal.I18nCustomizer;
import com.openexchange.i18n.I18nService;
import com.openexchange.log.LogFactory;
import com.openexchange.log.LogWrapperFactory;
import com.openexchange.server.Initialization;
import com.openexchange.server.ServerInitialization;
import com.openexchange.server.ServiceHolderInit;
import com.openexchange.tools.strings.BasicTypesStringParser;
import com.openexchange.tools.strings.CompositeParser;
import com.openexchange.tools.strings.DateStringParser;
import com.openexchange.tools.strings.StringParser;
import com.openexchange.tools.strings.TimeSpanParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public final class GlobalActivator
implements BundleActivator {
    private static final Log LOG = LogFactory.getLog(GlobalActivator.class);
    private Initialization initialization;
    protected ServiceTracker<StringParser, StringParser> parserTracker = null;
    private ServiceRegistration<StringParser> parserRegistration;
    private List<ServiceTracker<?, ?>> trackers;
    private volatile DynamicClassLoaderActivator dynamicClassLoaderActivator;

    public void start(BundleContext context) throws Exception {
        try {
            this.initialization = new ServerInitialization();
            this.initialization.start();
            ServiceHolderInit.getInstance().start();
            this.initStringParsers(context);
            this.trackers = new ArrayList(2);
            this.trackers.add(new ServiceTracker(context, I18nService.class, (ServiceTrackerCustomizer)new I18nCustomizer(context)));
            final ServiceTracker logWrapperTracker = new ServiceTracker(context, LogWrapperFactory.class, null);
            LogFactory.FACTORY.set(new LogWrapperFactory(){

                @Override
                public Log wrap(String name, Log log) {
                    Log retval = log;
                    for (LogWrapperFactory factory : logWrapperTracker.getTracked().values()) {
                        retval = factory.wrap(name, retval);
                    }
                    return retval;
                }
            });
            this.trackers.add(logWrapperTracker);
            for (ServiceTracker<?, ?> tracker : this.trackers) {
                tracker.open();
            }
            DynamicClassLoaderActivator dynamicClassLoaderActivator = new DynamicClassLoaderActivator();
            dynamicClassLoaderActivator.start(context);
            this.dynamicClassLoaderActivator = dynamicClassLoaderActivator;
            LOG.info((Object)"Global bundle successfully started");
        }
        catch (Throwable t) {
            LOG.error((Object)t.getMessage(), t);
            throw t instanceof Exception ? (Exception)t : new Exception(t.getMessage(), t);
        }
    }

    private void initStringParsers(BundleContext context) {
        this.parserTracker = new ServiceTracker(context, StringParser.class, null);
        final ArrayList<StringParser> standardParsers = new ArrayList<StringParser>(3);
        final CompositeParser standardParsersComposite = new CompositeParser(){

            @Override
            protected Collection<StringParser> getParsers() {
                return standardParsers;
            }
        };
        CompositeParser allParsers = new CompositeParser(){

            @Override
            protected Collection<StringParser> getParsers() {
                Object[] services = GlobalActivator.this.parserTracker.getServices();
                if (services == null) {
                    return Arrays.asList(standardParsersComposite);
                }
                ArrayList<StringParser> parsers = new ArrayList<StringParser>(services.length);
                for (Object object : services) {
                    if (object == this) continue;
                    parsers.add((StringParser)object);
                }
                parsers.add(standardParsersComposite);
                return parsers;
            }
        };
        standardParsers.add(new BasicTypesStringParser());
        standardParsers.add(new DateStringParser(allParsers));
        standardParsers.add(new TimeSpanParser());
        Hashtable<String, Integer> properties = new Hashtable<String, Integer>();
        properties.put("service.ranking", 100);
        this.parserTracker.open();
        this.parserRegistration = context.registerService(StringParser.class, (Object)allParsers, properties);
    }

    public void stop(BundleContext context) throws Exception {
        try {
            DynamicClassLoaderActivator dynamicClassLoaderActivator = this.dynamicClassLoaderActivator;
            if (null != dynamicClassLoaderActivator) {
                dynamicClassLoaderActivator.stop(context);
                this.dynamicClassLoaderActivator = null;
            }
            if (null != this.trackers) {
                while (!this.trackers.isEmpty()) {
                    this.trackers.remove(0).close();
                }
                this.trackers = null;
            }
            ServiceHolderInit.getInstance().stop();
            this.initialization.stop();
            this.initialization = null;
            this.shutdownStringParsers();
            LOG.debug((Object)"Global bundle successfully stopped");
        }
        catch (Throwable t) {
            LOG.error((Object)t.getMessage(), t);
            throw t instanceof Exception ? (Exception)t : new Exception(t.getMessage(), t);
        }
    }

    private void shutdownStringParsers() {
        this.parserRegistration.unregister();
        this.parserTracker.close();
    }
}

