/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml.contact.actions;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Contact;
import com.openexchange.webdav.xml.ContactWriter;
import com.openexchange.webdav.xml.contact.actions.AbstractContactRequest;
import com.openexchange.webdav.xml.contact.actions.InsertParser;
import com.openexchange.webdav.xml.contact.actions.InsertResponse;
import com.openexchange.webdav.xml.framework.Constants;
import com.openexchange.webdav.xml.framework.RequestTools;
import com.openexchange.webdav.xml.framework.WebDAVRequest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.mail.internet.AddressException;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.XMLOutputter;

public class InsertRequest
extends AbstractContactRequest<InsertResponse> {
    private final Contact contact;

    public InsertRequest(Contact contact) {
        this.contact = contact;
    }

    @Override
    public RequestEntity getEntity() throws OXException, IOException {
        Document doc = RequestTools.createPropertyUpdate(this.createProp());
        XMLOutputter xo = new XMLOutputter();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        xo.output(doc, (OutputStream)baos);
        return new ByteArrayRequestEntity(baos.toByteArray());
    }

    private Element createProp() throws OXException, IOException {
        this.contact.removeObjectID();
        Element eProp = new Element("prop", Constants.NS_DAV);
        ContactWriter contactWriter = new ContactWriter();
        try {
            contactWriter.addContent2PropElement(eProp, this.contact, false, true);
        }
        catch (OXException e) {
            throw new OXException(e);
        }
        catch (AddressException e) {
            throw new OXException((Throwable)e);
        }
        return eProp;
    }

    @Override
    public WebDAVRequest.Method getMethod() {
        return WebDAVRequest.Method.PUT;
    }

    public InsertParser getParser() {
        return new InsertParser();
    }
}

