/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.action;

import com.openexchange.exception.OXException;
import com.openexchange.test.XMLCompare;
import com.openexchange.webdav.action.ActionTestCase;
import com.openexchange.webdav.action.MockWebdavRequest;
import com.openexchange.webdav.action.MockWebdavResponse;
import com.openexchange.webdav.action.WebdavLockAction;
import com.openexchange.webdav.action.WebdavRequest;
import com.openexchange.webdav.action.WebdavResponse;
import com.openexchange.webdav.protocol.WebdavLock;
import com.openexchange.webdav.protocol.WebdavPath;
import com.openexchange.webdav.protocol.WebdavResource;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;

public class LockTest
extends ActionTestCase {
    private static final Namespace TEST_NS = Namespace.getNamespace((String)"http://www.open-xchange.com/namespace/webdav-test");
    private WebdavPath INDEX_HTML_URL;
    private WebdavPath GUI_URL;
    private WebdavPath LOCK_HTML_URL;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.INDEX_HTML_URL = this.testCollection.dup().append(new String[]{"index.html"});
        this.GUI_URL = this.testCollection.dup().append(new String[]{"development"}).append(new String[]{"gui"});
        this.LOCK_HTML_URL = this.testCollection.dup().append(new String[]{"lock.html"});
    }

    public void testLock() throws Exception {
        String body = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><lockinfo xmlns=\"DAV:\"><lockscope><exclusive /></lockscope><locktype><write /></locktype><owner>me</owner></lockinfo>";
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost/");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setBodyAsString("<?xml version=\"1.0\" encoding=\"utf-8\" ?><lockinfo xmlns=\"DAV:\"><lockscope><exclusive /></lockscope><locktype><write /></locktype><owner>me</owner></lockinfo>");
        req.setUrl(this.INDEX_HTML_URL);
        req.setHeader("Timeout", "infinite");
        WebdavLockAction action = new WebdavLockAction();
        action.perform((WebdavRequest)req, (WebdavResponse)res);
        LockTest.assertEquals((int)200, (int)res.getStatus());
        LockTest.assertEquals((int)1, (int)this.factory.resolveResource(this.INDEX_HTML_URL).getLocks().size());
        WebdavLock lock = (WebdavLock)this.factory.resolveResource(this.INDEX_HTML_URL).getLocks().get(0);
        LockTest.assertNotNull((Object)lock.getToken());
        String lockToken = lock.getToken();
        LockTest.assertEquals((String)lockToken, (String)res.getHeader("Lock-Token"));
        String expect = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><prop xmlns=\"DAV:\"><lockdiscovery><activelock><lockscope><exclusive /></lockscope><locktype><write /></locktype><owner>me</owner><depth>0</depth><locktoken><href>" + lockToken + "</href></locktoken><timeout></timeout></activelock></lockdiscovery></prop>";
        XMLCompare compare = new XMLCompare();
        compare.setCheckTextNames("owner", "locktoken");
        LockTest.assertTrue((boolean)compare.compare(expect, res.getResponseBodyAsString()));
        WebdavResource r = this.factory.resolveResource(this.INDEX_HTML_URL);
        r.unlock(lockToken);
        r.save();
    }

    public void testLockOwnerInXML() throws Exception {
        String body = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><lockinfo xmlns=\"DAV:\"><lockscope><exclusive /></lockscope><locktype><write /></locktype><owner><shortName xmlns=\"" + TEST_NS.getURI() + "\">me</shortName></owner></lockinfo>";
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost/");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setBodyAsString(body);
        req.setUrl(this.INDEX_HTML_URL);
        req.setHeader("Timeout", "infinite");
        WebdavLockAction action = new WebdavLockAction();
        action.perform((WebdavRequest)req, (WebdavResponse)res);
        LockTest.assertEquals((int)200, (int)res.getStatus());
        LockTest.assertEquals((int)1, (int)this.factory.resolveResource(this.INDEX_HTML_URL).getLocks().size());
        WebdavLock lock = (WebdavLock)this.factory.resolveResource(this.INDEX_HTML_URL).getLocks().get(0);
        LockTest.assertNotNull((Object)lock.getToken());
        String lockToken = lock.getToken();
        LockTest.assertEquals((String)lockToken, (String)res.getHeader("Lock-Token"));
        String expect = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><prop xmlns=\"DAV:\"><lockdiscovery><activelock><lockscope><exclusive /></lockscope><locktype><write /></locktype><owner><shortName xmlns=\"" + TEST_NS.getURI() + "\">me</shortName></owner><depth>0</depth><locktoken><href>" + lockToken + "</href></locktoken><timeout>Infinite</timeout></activelock></lockdiscovery></prop>";
        XMLCompare compare = new XMLCompare();
        compare.setCheckTextNames("owner", "locktoken", "timeout", "shortName");
        LockTest.assertTrue((boolean)compare.compare(expect, res.getResponseBodyAsString()));
        WebdavResource r = this.factory.resolveResource(this.INDEX_HTML_URL);
        r.unlock(lockToken);
        r.save();
    }

    public void testDepth() throws Exception {
        String body = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><lockinfo xmlns=\"DAV:\"><lockscope><exclusive /></lockscope><locktype><write /></locktype><owner>me</owner></lockinfo>";
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost/");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setBodyAsString("<?xml version=\"1.0\" encoding=\"utf-8\" ?><lockinfo xmlns=\"DAV:\"><lockscope><exclusive /></lockscope><locktype><write /></locktype><owner>me</owner></lockinfo>");
        req.setUrl(this.GUI_URL);
        req.setHeader("Timeout", "infinite");
        req.setHeader("Depth", "infinity");
        WebdavLockAction action = new WebdavLockAction();
        action.perform((WebdavRequest)req, (WebdavResponse)res);
        LockTest.assertEquals((int)200, (int)res.getStatus());
        WebdavResource resource = this.factory.resolveResource(this.GUI_URL);
        LockTest.assertEquals((int)1, (int)resource.getLocks().size());
        WebdavLock lock = (WebdavLock)resource.getLocks().get(0);
        LockTest.assertEquals((int)-1, (int)lock.getDepth());
        resource.unlock(lock.getToken());
        req = new MockWebdavRequest(this.factory, "http://localhost/");
        res = new MockWebdavResponse();
        req.setBodyAsString("<?xml version=\"1.0\" encoding=\"utf-8\" ?><lockinfo xmlns=\"DAV:\"><lockscope><exclusive /></lockscope><locktype><write /></locktype><owner>me</owner></lockinfo>");
        req.setUrl(this.GUI_URL);
        req.setHeader("Timeout", "infinite");
        req.setHeader("Depth", "1");
        action.perform((WebdavRequest)req, (WebdavResponse)res);
        LockTest.assertEquals((int)1, (int)resource.getLocks().size());
        lock = (WebdavLock)resource.getLocks().get(0);
        LockTest.assertEquals((int)1, (int)lock.getDepth());
    }

    public void testTimeoutInSeconds() throws Exception {
        String body = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><lockinfo xmlns=\"DAV:\"><lockscope><exclusive /></lockscope><locktype><write /></locktype><owner>me</owner></lockinfo>";
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost/");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setBodyAsString("<?xml version=\"1.0\" encoding=\"utf-8\" ?><lockinfo xmlns=\"DAV:\"><lockscope><exclusive /></lockscope><locktype><write /></locktype><owner>me</owner></lockinfo>");
        req.setUrl(this.INDEX_HTML_URL);
        req.setHeader("Timeout", "Second-3600");
        WebdavLockAction action = new WebdavLockAction();
        action.perform((WebdavRequest)req, (WebdavResponse)res);
        LockTest.assertEquals((int)200, (int)res.getStatus());
        LockTest.assertEquals((int)1, (int)this.factory.resolveResource(this.INDEX_HTML_URL).getLocks().size());
        WebdavLock lock = (WebdavLock)this.factory.resolveResource(this.INDEX_HTML_URL).getLocks().get(0);
        LockTest.assertTrue((3600000L - lock.getTimeout() < 200L ? 1 : 0) != 0);
        LockTest.assertTrue((lock.getTimeout() <= 3600000L ? 1 : 0) != 0);
        WebdavResource r = this.factory.resolveResource(this.INDEX_HTML_URL);
        String lockToken = ((WebdavLock)r.getLocks().iterator().next()).getToken();
        r.unlock(lockToken);
        r.save();
    }

    public void testLockNull() throws Exception {
        String body = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><lockinfo xmlns=\"DAV:\"><lockscope><exclusive /></lockscope><locktype><write /></locktype><owner>me</owner></lockinfo>";
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost/");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setBodyAsString("<?xml version=\"1.0\" encoding=\"utf-8\" ?><lockinfo xmlns=\"DAV:\"><lockscope><exclusive /></lockscope><locktype><write /></locktype><owner>me</owner></lockinfo>");
        req.setUrl(this.LOCK_HTML_URL);
        req.setHeader("Timeout", "infinite");
        WebdavLockAction action = new WebdavLockAction();
        action.perform((WebdavRequest)req, (WebdavResponse)res);
        LockTest.assertEquals((int)200, (int)res.getStatus());
        WebdavResource resource = this.factory.resolveResource(this.LOCK_HTML_URL);
        LockTest.assertTrue((boolean)resource.isLockNull());
        WebdavLock lock = (WebdavLock)resource.getLocks().get(0);
        String lockToken = lock.getToken();
        String expect = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><prop xmlns=\"DAV:\"><lockdiscovery><activelock><lockscope><exclusive /></lockscope><locktype><write /></locktype><owner>me</owner><depth>0</depth><locktoken><href>" + lockToken + "</href></locktoken><timeout></timeout></activelock></lockdiscovery></prop>";
        XMLCompare compare = new XMLCompare();
        compare.setCheckTextNames("owner", "locktoken");
        LockTest.assertTrue((boolean)compare.compare(expect, res.getResponseBodyAsString()));
    }

    public void testLockWithoutXMLBody() throws OXException, UnsupportedEncodingException, JDOMException, IOException {
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost/");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setUrl(this.INDEX_HTML_URL);
        req.setHeader("Timeout", "infinite");
        WebdavLockAction action = new WebdavLockAction();
        action.perform((WebdavRequest)req, (WebdavResponse)res);
        LockTest.assertEquals((int)200, (int)res.getStatus());
        LockTest.assertEquals((int)1, (int)this.factory.resolveResource(this.INDEX_HTML_URL).getLocks().size());
        WebdavLock lock = (WebdavLock)this.factory.resolveResource(this.INDEX_HTML_URL).getLocks().get(0);
        LockTest.assertNotNull((Object)lock.getToken());
        String lockToken = lock.getToken();
        LockTest.assertEquals((String)lockToken, (String)res.getHeader("Lock-Token"));
        String expect = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><prop xmlns=\"DAV:\"><lockdiscovery><activelock><lockscope><exclusive /></lockscope><locktype><write /></locktype><owner>me</owner><depth>0</depth><locktoken><href>" + lockToken + "</href></locktoken><timeout></timeout></activelock></lockdiscovery></prop>";
        XMLCompare compare = new XMLCompare();
        compare.setCheckTextNames("locktoken");
        LockTest.assertTrue((boolean)compare.compare(expect, res.getResponseBodyAsString()));
        WebdavResource r = this.factory.resolveResource(this.INDEX_HTML_URL);
        r.unlock(lockToken);
        r.save();
    }

    public void testRelock() throws OXException, UnsupportedEncodingException, JDOMException, IOException {
        String body = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><lockinfo xmlns=\"DAV:\"><lockscope><exclusive /></lockscope><locktype><write /></locktype><owner>Administrator</owner></lockinfo>";
        MockWebdavRequest req = new MockWebdavRequest(this.factory, "http://localhost/");
        MockWebdavResponse res = new MockWebdavResponse();
        req.setBodyAsString("<?xml version=\"1.0\" encoding=\"utf-8\" ?><lockinfo xmlns=\"DAV:\"><lockscope><exclusive /></lockscope><locktype><write /></locktype><owner>Administrator</owner></lockinfo>");
        req.setUrl(this.INDEX_HTML_URL);
        req.setHeader("Timeout", "infinite");
        WebdavLockAction action = new WebdavLockAction();
        action.perform((WebdavRequest)req, (WebdavResponse)res);
        String lockToken = res.getHeader("Lock-Token");
        req = new MockWebdavRequest(this.factory, "http://localhost/");
        req.setUrl(this.INDEX_HTML_URL);
        req.setHeader("Timeout", "infinite");
        req.setHeader("If", "(<" + lockToken + ">)");
        req.getUserInfo().put("mentionedLocks", Arrays.asList(lockToken));
        res = new MockWebdavResponse();
        action = new WebdavLockAction();
        action.perform((WebdavRequest)req, (WebdavResponse)res);
        LockTest.assertEquals((int)200, (int)res.getStatus());
        LockTest.assertEquals((int)1, (int)this.factory.resolveResource(this.INDEX_HTML_URL).getLocks().size());
        String expect = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><prop xmlns=\"DAV:\"><lockdiscovery><activelock><lockscope><exclusive /></lockscope><locktype><write /></locktype><owner>Administrator</owner><depth>0</depth><locktoken><href>" + lockToken + "</href></locktoken><timeout>Infinite</timeout></activelock></lockdiscovery></prop>";
        XMLCompare compare = new XMLCompare();
        compare.setCheckTextNames("owner", "locktoken", "timeout", "shortName");
        LockTest.assertTrue((String)("got: " + res.getResponseBodyAsString()), (boolean)compare.compare(expect, res.getResponseBodyAsString()));
        WebdavResource r = this.factory.resolveResource(this.INDEX_HTML_URL);
        r.unlock(lockToken);
        r.save();
    }
}

