/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.test.fixtures;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.GroupParticipant;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.test.fixtures.DefaultFixtures;
import com.openexchange.test.fixtures.Fixture;
import com.openexchange.test.fixtures.FixtureException;
import com.openexchange.test.fixtures.FixtureFactory;
import com.openexchange.test.fixtures.FixtureLoader;
import com.openexchange.test.fixtures.Fixtures;
import com.openexchange.test.fixtures.GroupResolver;
import com.openexchange.test.fixtures.transformators.BooleanTransformator;
import com.openexchange.test.fixtures.transformators.FloatTransformator;
import com.openexchange.test.fixtures.transformators.ParticipantTransformator;
import com.openexchange.test.fixtures.transformators.PriorityTransformator;
import com.openexchange.test.fixtures.transformators.StatusTransformator;
import com.openexchange.test.fixtures.transformators.Transformator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class TaskFixtureFactory
implements FixtureFactory<Task> {
    private final FixtureLoader fixtureLoader;
    private final GroupResolver groupResolver;

    public TaskFixtureFactory(GroupResolver groupResolver, FixtureLoader fixtureLoader) {
        this.fixtureLoader = fixtureLoader;
        this.groupResolver = groupResolver;
    }

    @Override
    public Fixtures<Task> createFixture(String fixtureName, Map<String, Map<String, String>> entries) {
        return new TaskFixtures(fixtureName, entries, this.fixtureLoader, this.groupResolver);
    }

    private class TaskFixtures
    extends DefaultFixtures<Task>
    implements Fixtures<Task> {
        private final Map<String, Map<String, String>> entries;
        private final Map<String, Fixture<Task>> tasks;
        private final GroupResolver groupResolver;

        public TaskFixtures(String fixtureName, Map<String, Map<String, String>> entries, FixtureLoader fixtureLoader, GroupResolver groupResolver) {
            super(Task.class, entries, fixtureLoader);
            this.tasks = new HashMap<String, Fixture<Task>>();
            this.entries = entries;
            this.groupResolver = groupResolver;
            this.addTransformator((Transformator)new PriorityTransformator(), "priority");
            this.addTransformator((Transformator)new StatusTransformator(), "status");
            this.addTransformator((Transformator)new BooleanTransformator(), "private_flag");
            this.addTransformator((Transformator)new FloatTransformator(), "target_costs");
            this.addTransformator((Transformator)new FloatTransformator(), "actual_costs");
            this.addTransformator((Transformator)new ParticipantTransformator(fixtureLoader), "participants");
        }

        @Override
        public Fixture<Task> getEntry(String entryName) throws OXException {
            if (this.tasks.containsKey(entryName)) {
                return this.tasks.get(entryName);
            }
            Map<String, String> values = this.entries.get(entryName);
            if (null == values) {
                throw new FixtureException("Entry with name " + entryName + " not found");
            }
            Task task = new Task();
            this.apply(task, values);
            this.applyUsers(task, this.groupResolver);
            Fixture<Task> fixture = new Fixture<Task>(task, values.keySet().toArray(new String[values.size()]), values);
            this.tasks.put(entryName, fixture);
            return fixture;
        }

        private void applyUsers(Task task, GroupResolver groupResolver) {
            Participant[] participants;
            if (null != task && null != (participants = task.getParticipants())) {
                ArrayList<UserParticipant> users = new ArrayList<UserParticipant>();
                for (Participant participant : participants) {
                    GroupParticipant group;
                    Contact[] groupMembers;
                    if (1 == participant.getType()) {
                        users.add((UserParticipant)participant);
                        continue;
                    }
                    if (2 != participant.getType() || null == (groupMembers = groupResolver.resolveGroup((group = (GroupParticipant)participant).getIdentifier()))) continue;
                    for (Contact groupMember : groupMembers) {
                        UserParticipant userParticipant = new UserParticipant(groupMember.getInternalUserId());
                        userParticipant.setDisplayName(groupMember.getDisplayName());
                        userParticipant.setEmailAddress(groupMember.getEmail1());
                        users.add(userParticipant);
                    }
                }
                task.setUsers(users);
            }
        }
    }
}

