/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.test;

import com.openexchange.server.impl.OCLPermission;
import java.util.ArrayList;
import java.util.List;

public class PermissionTools {
    public static final String ADMIN = "arawada/a";
    public static final String ADMIN_GROUP = "arawada/ag";

    public static OCLPermission OCLP(int entity, String permissionDef) {
        OCLPermission permission = new OCLPermission();
        permission.setEntity(entity);
        PermissionScanner scanner = new PermissionScanner(permissionDef);
        int[] permissions = scanner.getPermissions();
        permission.setFolderPermission(permissions[0]);
        permission.setReadObjectPermission(permissions[1]);
        permission.setWriteObjectPermission(permissions[2]);
        permission.setDeleteObjectPermission(permissions[3]);
        boolean[] options = scanner.getOptions();
        permission.setFolderAdmin(options[0]);
        permission.setGroupPermission(options[1]);
        return permission;
    }

    public static List<OCLPermission> P(Object ... permDefs) {
        if (permDefs.length % 2 != 0) {
            throw new IllegalArgumentException("Expecting alternating ints and Strings");
        }
        ArrayList<OCLPermission> retval = new ArrayList<OCLPermission>();
        for (int i = 0; i < permDefs.length; ++i) {
            int entity = (Integer)permDefs[i++];
            String permissionDef = (String)permDefs[i];
            retval.add(PermissionTools.OCLP(entity, permissionDef));
        }
        return retval;
    }

    private static final class PermissionScanner {
        private static final int OPTIONS_MODE = 1;
        private static final int PERMISSIONS_MODE = 0;
        private final String permissionString;
        private int index;
        private final int[] permissions = new int[]{0, 0, 0, 0};
        private int mode;
        private final boolean[] options = new boolean[2];

        public PermissionScanner(String permission) {
            this.permissionString = permission;
            while (!this.eol()) {
                this.lookupNext();
            }
        }

        private boolean eol() {
            return this.index >= this.permissionString.length();
        }

        private char lookahead() {
            return this.permissionString.charAt(this.index);
        }

        private char consume() {
            return this.permissionString.charAt(this.index++);
        }

        private void lookupNext() {
            switch (this.mode) {
                case 0: {
                    this.parsePermission();
                    break;
                }
                case 1: {
                    this.parseOptions();
                }
            }
        }

        private void parseOptions() {
            switch (this.lookahead()) {
                case 'a': {
                    this.consume();
                    this.options[0] = true;
                    break;
                }
                case 'g': {
                    this.consume();
                    this.options[1] = true;
                    break;
                }
                default: {
                    this.consume();
                }
            }
        }

        private void parsePermission() {
            switch (this.lookahead()) {
                case 'a': {
                    this.consume();
                    this.permissions[0] = 128;
                    break;
                }
                case 'r': {
                    this.consume();
                    this.permissions[1] = this.own() ? 2 : (this.admin() ? 128 : 4);
                    break;
                }
                case 'w': {
                    this.consume();
                    this.permissions[2] = this.own() ? 2 : (this.admin() ? 128 : 4);
                    break;
                }
                case 'd': {
                    this.consume();
                    this.permissions[3] = this.own() ? 2 : (this.admin() ? 128 : 4);
                    break;
                }
                case 'v': {
                    this.consume();
                    this.permissions[0] = 2;
                    break;
                }
                case 'c': {
                    this.consume();
                    this.permissions[0] = 4;
                    break;
                }
                case 's': {
                    this.consume();
                    this.permissions[0] = 8;
                    break;
                }
                case '/': {
                    this.consume();
                    this.mode = 1;
                    break;
                }
                default: {
                    this.consume();
                }
            }
        }

        private boolean own() {
            return this.isNextLetter('o');
        }

        private boolean admin() {
            return this.isNextLetter('a');
        }

        private boolean isNextLetter(char c) {
            if (!this.eol() && c == this.lookahead()) {
                this.consume();
                return true;
            }
            return false;
        }

        public int[] getPermissions() {
            return this.permissions;
        }

        public boolean[] getOptions() {
            return this.options;
        }
    }
}

