/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.test;

import com.openexchange.test.TestInit;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;

public class JMXInit {
    private static boolean jmxPropertiesLoaded;
    private static boolean isJMXDirInitialized;
    private static String[] jmxPropFiles;
    public static Properties jmxProps;

    private static void loadJMXProperties() {
        TestInit.loadTestProperties();
        jmxProps = new Properties();
        try {
            jmxProps.load(new FileInputStream(JMXInit.getFileName()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        jmxPropertiesLoaded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getFileName() {
        String retval = null;
        if (TestInit.getTestProperties().getProperty("jmxPropertiesDir") == null) return TestInit.getTestProperties().getProperty("jmxPropertiesFile");
        if (isJMXDirInitialized) return jmxPropFiles[(int)(Math.random() * (double)jmxPropFiles.length)];
        Class<JMXInit> clazz = JMXInit.class;
        synchronized (JMXInit.class) {
            if (isJMXDirInitialized) return jmxPropFiles[(int)(Math.random() * (double)jmxPropFiles.length)];
            JMXInit.initJMXProperties();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return jmxPropFiles[(int)(Math.random() * (double)jmxPropFiles.length)];
        }
    }

    private static void initJMXProperties() {
        File dir;
        String jmxPropertiesDir = TestInit.getTestProperties().getProperty("jmxPropertiesDir");
        if (!jmxPropertiesDir.endsWith(System.getProperty("file.separator"))) {
            jmxPropertiesDir = jmxPropertiesDir + System.getProperty("file.separator");
        }
        if ((dir = new File(jmxPropertiesDir)).isDirectory()) {
            ArrayList<String> fileList = new ArrayList<String>();
            for (String fileName : dir.list()) {
                File myFile = new File(jmxPropertiesDir + fileName);
                if (myFile.isDirectory() || !myFile.canRead() || myFile.getName().length() != 0 && myFile.getName().charAt(0) == '.') continue;
                fileList.add(myFile.getAbsolutePath());
            }
            jmxPropFiles = new String[fileList.size()];
            System.arraycopy(fileList.toArray(), 0, jmxPropFiles, 0, fileList.size());
        }
        isJMXDirInitialized = true;
    }

    public static Properties getJMXProperties() {
        if (!jmxPropertiesLoaded || TestInit.getTestProperties().getProperty("jmxPropertiesDir") != null) {
            JMXInit.loadJMXProperties();
        }
        return jmxProps;
    }

    public static String getJMXProperty(String key) {
        return JMXInit.getJMXProperties().getProperty(key);
    }

    public static String getJMXProperty(Property property) {
        return JMXInit.getJMXProperties().getProperty(property.toString());
    }

    public static enum Property {
        JMX_HOST("jmxHost"),
        JMX_PORT("jmxPort"),
        JMX_LOGIN("jmxLogin"),
        JMX_PASSWORD("jmxPassword");

        private final String name;

        private Property(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

