/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.test;

import com.openexchange.ajax.contact.action.DoAssociationRequest;
import com.openexchange.ajax.contact.action.DoAssociationResponse;
import com.openexchange.ajax.contact.action.DoSeparationRequest;
import com.openexchange.ajax.contact.action.DoSeparationResponse;
import com.openexchange.ajax.contact.action.GetAssociatedContactsRequest;
import com.openexchange.ajax.contact.action.GetAssociatedContactsResponse;
import com.openexchange.ajax.contact.action.GetAssociationRequest;
import com.openexchange.ajax.contact.action.GetAssociationResponse;
import com.openexchange.ajax.contact.action.GetContactByUIDRequest;
import com.openexchange.ajax.contact.action.GetResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contact.ContactUnificationState;
import com.openexchange.groupware.container.Contact;
import com.openexchange.test.ContactTestManager;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.json.JSONException;
import org.xml.sax.SAXException;

public class AggregatingContactTestManager
extends ContactTestManager {
    private final Set<UUID> createdAssociations = new HashSet<UUID>();

    public AggregatingContactTestManager(AJAXClient client) throws OXException, IOException, SAXException, JSONException {
        super(client);
    }

    public ContactUnificationState getAssociationBetween(Contact contributor, Contact aggregator) throws IOException, SAXException, JSONException, OXException {
        GetAssociationResponse response = this.getClient().execute(new GetAssociationRequest(contributor, aggregator));
        this.doJanitorialTasks(response);
        return response.getState();
    }

    public void associateTwoContacts(Contact aggregator, Contact contributor) {
        try {
            DoAssociationResponse doAssociationResponse = this.getClient().execute(new DoAssociationRequest(contributor, aggregator));
            Contact temp = this.getAction(aggregator);
            aggregator.setUserField20(temp.getUserField20());
            temp = this.getAction(contributor);
            contributor.setUserField20(temp.getUserField20());
            this.doJanitorialTasks(doAssociationResponse);
        }
        catch (Exception e) {
            this.doExceptionHandling(e, "DoAssociationRequest");
        }
    }

    public void separateTwoContacts(Contact aggregator, Contact contributor) {
        try {
            DoSeparationResponse doSeparationResponse = this.getClient().execute(new DoSeparationRequest(contributor, aggregator));
            aggregator = this.getAction(aggregator);
            contributor = this.getAction(contributor);
            this.doJanitorialTasks(doSeparationResponse);
        }
        catch (Exception e) {
            this.doExceptionHandling(e, "DoSeparationRequest");
        }
    }

    public Contact getContactByUID(UUID uid) {
        try {
            GetResponse response = this.getClient().execute(new GetContactByUIDRequest(uid, this.timeZone));
            this.doJanitorialTasks(response);
            return response.getContact();
        }
        catch (Exception e) {
            this.doExceptionHandling(e, "GetContactByUIDRequest");
            return null;
        }
    }

    public List<UUID> getAssociatedContactsByUID(UUID uid) {
        try {
            GetAssociatedContactsResponse response = this.getClient().execute(new GetAssociatedContactsRequest(uid, this.timeZone));
            this.doJanitorialTasks(response);
            return response.getUUIDs();
        }
        catch (Exception e) {
            this.doExceptionHandling(e, "GetAssociatedContactsRequest");
            return null;
        }
    }

    public List<UUID> getAssociatedContacts(Contact c) {
        try {
            GetAssociatedContactsResponse response = this.getClient().execute(new GetAssociatedContactsRequest(c, this.timeZone));
            this.doJanitorialTasks(response);
            return response.getUUIDs();
        }
        catch (Exception e) {
            this.doExceptionHandling(e, "GetAssociatedContactsRequest");
            return null;
        }
    }
}

